/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.serializer;

import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprNode1;
import mx.com.hp.hpl.jena.query.expr.ExprNode2;
import mx.com.hp.hpl.jena.query.expr.ExprNodeFunction;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.expr.NodeVar;
import mx.com.hp.hpl.jena.query.serializer.FormatterExpr;
import mx.com.hp.hpl.jena.query.serializer.SerializationContext;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;
import mx.com.hp.hpl.jena.shared.PrefixMapping;

public class FmtExprAbstract
extends FormatterExpr {
    static final boolean ONELINE = true;
    IndentedWriter out;
    SerializationContext context;

    public FmtExprAbstract(IndentedWriter writer, PrefixMapping pm) {
        this(writer, new SerializationContext(null, pm, null));
    }

    public FmtExprAbstract(IndentedWriter writer, SerializationContext qCxt) {
        this.out = writer;
        this.context = qCxt;
        if (this.context == null) {
            this.context = new SerializationContext(null, null, null);
        }
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Expr expr) {
        FmtExprAbstract fmt = new FmtExprAbstract(out, cxt);
        fmt.startVisit();
        expr.visit(fmt);
        fmt.finishVisit();
    }

    public void startVisit() {
    }

    public void visit(ExprNode1 expr) {
        this.out.print("(");
        this.out.print(expr.getOpName());
        this.endLine();
        this.out.incIndent(2);
        expr.getExpr().visit(this);
        this.out.decIndent(2);
        this.out.print(")");
    }

    public void visit(ExprNode2 expr) {
        this.out.print("(");
        this.out.print(expr.getOpName());
        this.endLine();
        this.out.incIndent(2);
        expr.getLeft().visit(this);
        this.endLine();
        expr.getRight().visit(this);
        this.out.decIndent(2);
        this.out.print(")");
    }

    public void visit(ExprNodeFunction func) {
        Expr expr;
        this.out.print("(");
        this.out.print(func.getPrintName(this.context));
        this.out.incIndent(2);
        int i = 1;
        while ((expr = func.getArg(i)) != null) {
            this.out.print(' ');
            expr.visit(this);
            ++i;
        }
        this.out.print(")");
        this.out.decIndent(2);
    }

    public void visit(NodeValue nv) {
        this.out.print(nv.asQuotedString(this.context));
    }

    public void visit(NodeVar nv) {
        this.out.print("?");
        this.out.print(nv.getVarName());
    }

    public void finishVisit() {
        this.out.flush();
    }

    private void endLine() {
        this.out.print(' ');
    }
}

