/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.serializer;

import java.util.Iterator;
import mx.com.hp.hpl.jena.query.core.Element;
import mx.com.hp.hpl.jena.query.core.ElementBlock;
import mx.com.hp.hpl.jena.query.core.ElementExtension;
import mx.com.hp.hpl.jena.query.core.ElementFilter;
import mx.com.hp.hpl.jena.query.core.ElementGroup;
import mx.com.hp.hpl.jena.query.core.ElementNamedGraph;
import mx.com.hp.hpl.jena.query.core.ElementOptional;
import mx.com.hp.hpl.jena.query.core.ElementTriplePattern;
import mx.com.hp.hpl.jena.query.core.ElementUnion;
import mx.com.hp.hpl.jena.query.core.ElementUnsaid;
import mx.com.hp.hpl.jena.query.core.Template;
import mx.com.hp.hpl.jena.query.core.TemplateGroup;
import mx.com.hp.hpl.jena.query.core.TemplateTriple;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.serializer.FmtExprARQ;
import mx.com.hp.hpl.jena.query.serializer.FmtExprAbstract;
import mx.com.hp.hpl.jena.query.serializer.FormatterBase;
import mx.com.hp.hpl.jena.query.serializer.FormatterElement;
import mx.com.hp.hpl.jena.query.serializer.FormatterTemplate;
import mx.com.hp.hpl.jena.query.serializer.SerializationContext;
import mx.com.hp.hpl.jena.query.util.FmtUtils;
import mx.com.hp.hpl.jena.query.util.IndentedLineBuffer;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;

public class FormatterAbstract
extends FormatterBase
implements FormatterElement,
FormatterTemplate {
    static int INDENT = 2;
    static final boolean closingBracketOnSameLine = true;
    static final boolean allowDoubles = true;

    public FormatterAbstract(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Element el) {
        FormatterAbstract fmt = new FormatterAbstract(out, cxt);
        fmt.startVisit();
        el.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Element el) {
        SerializationContext cxt = new SerializationContext();
        IndentedLineBuffer b = new IndentedLineBuffer();
        FormatterAbstract.format(b.getIndentedWriter(), cxt, el);
        return b.toString();
    }

    public void visit(ElementTriplePattern el) {
        this.out.print("(triplepattern");
        this.out.print(" ");
        this.formatTriple(el.getTriple());
        this.printClose();
    }

    public void visit(ElementBlock el) {
        this.out.print("(block");
        this.out.incIndent(INDENT);
        this.out.newline();
        if (el.getDataset() != null) {
            this.out.print("dataset");
        }
        el.getPatternElement().visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementFilter el) {
        this.out.print("(filter");
        this.out.incIndent(INDENT);
        this.out.print(" ");
        if (el.getConstraint() instanceof Expr) {
            Expr expr = (Expr)el.getConstraint();
            FmtExprAbstract v = new FmtExprAbstract(this.out, this.context);
            expr.visit(v);
        } else {
            this.out.print(el.getConstraint().toString());
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementUnion el) {
        this.multiElement("union", el.getElements().iterator());
    }

    public void visit(ElementGroup el) {
        this.multiElement("group", el.getElements().iterator());
    }

    public void visit(ElementOptional el) {
        this.singleElement("optional", el.getElement());
    }

    public void visit(ElementNamedGraph el) {
        this.out.print("(graph ");
        this.out.print(this.slotToString(this.context, el.getGraphNameNode()));
        this.out.incIndent(INDENT);
        this.out.newline();
        el.getElement().visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(ElementUnsaid el) {
        this.singleElement("unsaid", el.getElement());
    }

    public void visit(ElementExtension el) {
        Expr expr;
        this.out.print("(ext ");
        String uri = el.getURI();
        String tmp = FmtUtils.stringForURI(uri, this.context.getPrefixMapping());
        this.out.print(tmp);
        this.out.print("(");
        int i = 1;
        while ((expr = el.getArg(i)) != null) {
            if (i != 1) {
                this.out.print(", ");
            }
            FmtExprARQ v = new FmtExprARQ(this.out, this.context);
            expr.visit(v);
            ++i;
        }
        this.out.print(")");
        this.out.println(" )");
    }

    private void singleElement(String name, Element element) {
        this.out.print("(");
        this.out.print(name);
        this.out.incIndent(INDENT);
        this.out.newline();
        element.visit(this);
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void multiElement(String name, Iterator iter) {
        this.out.print("(");
        this.out.print(name);
        this.out.incIndent(INDENT);
        while (iter.hasNext()) {
            this.out.newline();
            Element element = (Element)iter.next();
            element.visit(this);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    public void visit(TemplateTriple template) {
        this.out.print("(tripletemplate");
        this.out.print(" ");
        this.formatTriple(template.getTriple());
        this.printClose();
    }

    public void visit(TemplateGroup tGroup) {
        this.out.print("(templategroup");
        this.out.incIndent(INDENT);
        Iterator iter = tGroup.templates();
        while (iter.hasNext()) {
            this.out.newline();
            Template sub = (Template)iter.next();
            sub.visit(this);
        }
        this.out.decIndent(INDENT);
        this.printClose();
    }

    private void printClose() {
        this.out.print(")");
    }
}

