/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.test;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.query.QueryParseException;
import mx.com.hp.hpl.jena.query.lang.ParserBase;
import mx.com.hp.hpl.jena.query.util.Utils;

public class TestEsc
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestEsc.class);
        ts.setName(Utils.classShortName(TestEsc.class));
        return ts;
    }

    public void testEsc01() {
        this.execTest("x\\uabcd", "x\uabcd");
    }

    public void testEsc02() {
        this.execTest("\\uabcdx", "\uabcdx");
    }

    public void testEsc03() {
        this.execTest("1234\\uabcd1234", "1234\uabcd1234");
    }

    public void testEsc04() {
        this.execTestFail("\\uabck");
    }

    public void testEsc05() {
        this.execTestFail("\\uab");
    }

    public void testEsc06() {
        this.execTestFail("\\uabc");
    }

    public void testEsc07() {
        this.execTestFail("\\ua");
    }

    public void testEsc08() {
        this.execTestFail("\\u");
    }

    public void testEsc09() {
        this.execTestFail("\\");
    }

    public void testEsc10() {
        this.execTest("\\u0020", " ");
    }

    public void testEsc11() {
        this.execTest("\\uFFFF", "\uffff");
    }

    public void testEsc12() {
        this.execTest("\\u0000", "\u0000");
    }

    public void testEsc13() {
        this.execTestFail("\\U0000");
    }

    public void testEsc14() {
        this.execTest("\\U00000000", "\u0000");
    }

    public void testEsc15() {
        this.execTest("x\\tx\\n\\r", "x\tx\n\r");
    }

    private void execTestFail(String input) {
        try {
            String s = ParserBase.unescapeStr(input);
            TestEsc.fail((String)("Unescaping succeeded on " + input));
        }
        catch (QueryParseException ex) {
            return;
        }
    }

    private void execTest(String input, String outcome) {
        String result = ParserBase.unescapeStr(input);
        TestEsc.assertEquals((String)("Unescaped string does not match (" + input + ")"), (String)outcome, (String)result);
    }
}

