/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryFactory;
import mx.com.hp.hpl.jena.query.core.BindingMap;
import mx.com.hp.hpl.jena.query.junit.TestExprBoolean;
import mx.com.hp.hpl.jena.query.junit.TestExprNumeric;
import mx.com.hp.hpl.jena.query.junit.TestExprRDFTerm;
import mx.com.hp.hpl.jena.query.junit.TestExprString;
import mx.com.hp.hpl.jena.query.junit.TestExprSyntax;
import mx.com.hp.hpl.jena.query.junit.TestExprURI;
import mx.com.hp.hpl.jena.query.junit.TestVar;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class TestExpressionsARQ
extends TestSuite {
    static final String testSetName = "ARQ - Expressions";

    public static TestSuite suite() {
        TestExpressionsARQ ts = new TestExpressionsARQ(testSetName);
        ts.addStdTests(ts);
        return ts;
    }

    public TestExpressionsARQ(String name) {
        super(name);
    }

    public void addStdTests(TestSuite ts) {
        ts.addTest((Test)TestExpressionsARQ.variables());
        ts.addTest((Test)TestExpressionsARQ.numericValues());
        ts.addTest((Test)TestExpressionsARQ.numericExpr());
        ts.addTest((Test)TestExpressionsARQ.booleanValues());
        ts.addTest((Test)TestExpressionsARQ.booleanExpr());
        ts.addTest((Test)TestExpressionsARQ.DateTime());
        ts.addTest((Test)TestExpressionsARQ.rdfTermsURIs());
        ts.addTest((Test)TestExpressionsARQ.rdfTerms());
        ts.addTest((Test)TestExpressionsARQ.typedLiterals());
        ts.addTest((Test)TestExpressionsARQ.stringExpr());
        ts.addTest((Test)TestExpressionsARQ.builtinOps());
        ts.addTest((Test)TestExpressionsARQ.castExpr());
    }

    public static TestSuite variables() {
        TestSuite ts = new TestSuite("Variables");
        ts.addTest((Test)new TestVar("?x", "x"));
        ts.addTest((Test)new TestVar("$x", "x"));
        ts.addTest((Test)new TestVar("?name", "name"));
        ts.addTest((Test)new TestVar("$name", "name"));
        ts.addTest((Test)new TestExprSyntax("?x11"));
        ts.addTest((Test)new TestVar("?x_", "x_"));
        ts.addTest((Test)new TestVar("?x.", "x"));
        ts.addTest((Test)new TestVar("?x.x", "x"));
        ts.addTest((Test)new TestVar("?0", "0"));
        ts.addTest((Test)new TestVar("?0x", "0x"));
        ts.addTest((Test)new TestVar("?x0", "x0"));
        ts.addTest((Test)new TestVar("?_", "_"));
        ts.addTest((Test)new TestVar("?", 250));
        ts.addTest((Test)new TestExprSyntax("??", 250));
        ts.addTest((Test)new TestExprSyntax("?.", 250));
        return ts;
    }

    public static TestSuite numericValues() {
        TestSuite ts = new TestSuite("Numeric Values");
        ts.addTest((Test)new TestExprNumeric("7", 7L));
        ts.addTest((Test)new TestExprNumeric("-3", -3L));
        ts.addTest((Test)new TestExprNumeric("+2", 2L));
        return ts;
    }

    public static TestSuite numericExpr() {
        TestSuite ts = new TestSuite("Numeric Expressions");
        ts.addTest((Test)new TestExprNumeric("3+-4", -1L));
        ts.addTest((Test)new TestExprNumeric("3-+4", -1L));
        ts.addTest((Test)new TestExprNumeric("3+-4", -1L));
        ts.addTest((Test)new TestExprNumeric("3-(-4)", 7L));
        ts.addTest((Test)new TestExprNumeric("3+4+5", 12L));
        ts.addTest((Test)new TestExprNumeric("(3+4)+5", 12L));
        ts.addTest((Test)new TestExprNumeric("3+(4+5)", 12L));
        ts.addTest((Test)new TestExprNumeric("3*4+5", 17L));
        ts.addTest((Test)new TestExprNumeric("3*(4+5)", 27L));
        ts.addTest((Test)new TestExprNumeric("10-3-5", 2L));
        ts.addTest((Test)new TestExprNumeric("(10-3)-5", 2L));
        ts.addTest((Test)new TestExprNumeric("10-(3-5)", 12L));
        ts.addTest((Test)new TestExprNumeric("10-3+5", 12L));
        ts.addTest((Test)new TestExprNumeric("10-(3+5)", 2L));
        ts.addTest((Test)new TestExprNumeric("1.5 + 2.5", 4.0));
        ts.addTest((Test)new TestExprNumeric("1.5 + 2", 3.5));
        ts.addTest((Test)new TestExprNumeric("4111222333444", 4111222333444L));
        ts.addTest((Test)new TestExprNumeric("1234 + 4111222333444", 4111222334678L));
        ts.addTest((Test)new TestExprBoolean("4111222333444 > 1234", true));
        ts.addTest((Test)new TestExprBoolean("4111222333444 < 1234", false));
        ts.addTest((Test)new TestExprBoolean("1.5 < 2", true));
        ts.addTest((Test)new TestExprBoolean("1.5 > 2", false));
        ts.addTest((Test)new TestExprBoolean("1.5 < 2.3", true));
        ts.addTest((Test)new TestExprBoolean("1.5 > 2.3", false));
        return ts;
    }

    public static TestSuite booleanValues() {
        TestSuite ts = new TestSuite("Boolean Values");
        ts.addTest((Test)new TestExprBoolean("'true'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true));
        ts.addTest((Test)new TestExprBoolean("'1'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true));
        ts.addTest((Test)new TestExprBoolean("'false'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false));
        ts.addTest((Test)new TestExprBoolean("'0'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false));
        ts.addTest((Test)new TestExprBoolean("1", true));
        ts.addTest((Test)new TestExprBoolean("'foo'", true));
        ts.addTest((Test)new TestExprBoolean("0", false));
        ts.addTest((Test)new TestExprBoolean("''", false));
        ts.addTest((Test)new TestExprBoolean("!'junk'^^<urn:unknown>", 200));
        return ts;
    }

    public static TestSuite booleanExpr() {
        TestSuite ts = new TestSuite("Boolean Expressions");
        ts.addTest((Test)new TestExprBoolean("2 < 3", true));
        ts.addTest((Test)new TestExprBoolean("2 < 3", true));
        ts.addTest((Test)new TestExprBoolean("2 > 3", false));
        ts.addTest((Test)new TestExprBoolean("(2 < 3) && (3<4)", true));
        ts.addTest((Test)new TestExprBoolean("(2 < 3) && (3>=4)", false));
        ts.addTest((Test)new TestExprBoolean("(2 < 3) || (3>=4)", true));
        ts.addTest((Test)new TestExprBoolean("(2 < 3) || ?x > 2", true));
        ts.addTest((Test)new TestExprBoolean("(2 > 3) || ?x > 2", 200));
        ts.addTest((Test)new TestExprBoolean("(2 > 3) && ?x > 2", false));
        ts.addTest((Test)new TestExprBoolean("(2 < 3) && ?x > 2", 200));
        ts.addTest((Test)new TestExprBoolean("?x > 2 || (2 < 3)", true));
        ts.addTest((Test)new TestExprBoolean("?x > 2 || (2 > 3)", 200));
        ts.addTest((Test)new TestExprBoolean("?x > 2 && (2 < 3)", 200));
        ts.addTest((Test)new TestExprBoolean("?x > 2 && (2 > 3)", false));
        ts.addTest((Test)new TestExprBoolean("! ?x ", 200));
        ts.addTest((Test)new TestExprBoolean("! true ", false));
        ts.addTest((Test)new TestExprBoolean("! false ", true));
        ts.addTest((Test)new TestExprBoolean("2 = 3", false));
        ts.addTest((Test)new TestExprBoolean("!(2 = 3)", true));
        ts.addTest((Test)new TestExprBoolean("'2' = 2", true, 200));
        ts.addTest((Test)new TestExprBoolean("2 = '2'", true, 200));
        ts.addTest((Test)new TestExprBoolean("2 < '3'", true, 200));
        ts.addTest((Test)new TestExprBoolean("'2' < 3", true, 200));
        ts.addTest((Test)new TestExprBoolean("\"fred\" != \"joe\"", true));
        ts.addTest((Test)new TestExprBoolean("\"fred\" = \"joe\"", false));
        ts.addTest((Test)new TestExprBoolean("\"fred\" = \"fred\"", true));
        ts.addTest((Test)new TestExprBoolean("\"fred\" = 'fred'", true));
        ts.addTest((Test)new TestExprBoolean("true = true", true));
        ts.addTest((Test)new TestExprBoolean("false = false", true));
        ts.addTest((Test)new TestExprBoolean("true = false", false));
        ts.addTest((Test)new TestExprBoolean("true > true", 200));
        ts.addTest((Test)new TestExprBoolean("true >= false", 200));
        return ts;
    }

    public static TestSuite DateTime() {
        TestSuite ts = new TestSuite("DateTime Expressions");
        String dateTime1 = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String dateTime2 = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String dateTime3 = "'2005-01-01T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        String dateTime4 = "'2005-02-25T13:00:00Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        ts.addTest((Test)new TestExprBoolean(dateTime1 + " = " + dateTime2, true));
        ts.addTest((Test)new TestExprBoolean(dateTime1 + " <= " + dateTime2, true));
        ts.addTest((Test)new TestExprBoolean(dateTime1 + " >= " + dateTime2, true));
        ts.addTest((Test)new TestExprBoolean(dateTime3 + " < " + dateTime1, true));
        ts.addTest((Test)new TestExprBoolean(dateTime3 + " > " + dateTime1, false));
        ts.addTest((Test)new TestExprBoolean(dateTime4 + " < " + dateTime1, false));
        ts.addTest((Test)new TestExprBoolean(dateTime4 + " > " + dateTime1, true));
        return ts;
    }

    public static TestSuite rdfTermsURIs() {
        TestSuite ts = new TestSuite("RDF terms: QNames, URIs");
        Query query2 = QueryFactory.make();
        String exNS = "http://example.org/";
        String xNS = "http://example.org/dot#";
        String selNS = "http://select/";
        String dftNS = "http://default/";
        String baseNS = "http://base/";
        String rdfNS = RDF.getURI();
        query2.setBaseURI(baseNS);
        ts.addTest((Test)new TestExprURI("<a>", baseNS + "a", query2, null, 100));
        ts.addTest((Test)new TestExprURI("<a\\u00E9>", baseNS + "a\u00e9", query2, null, 100));
        query2.setPrefix("ex", exNS);
        query2.setPrefix("rdf", RDF.getURI());
        query2.setPrefix("x.", xNS);
        query2.setPrefix("", dftNS);
        query2.setPrefix("select", selNS);
        ts.addTest((Test)new TestExprURI("ex:b", exNS + "b", query2, null, 100));
        ts.addTest((Test)new TestExprURI("ex:b_", exNS + "b_", query2, null, 100));
        ts.addTest((Test)new TestExprURI("ex:a_b", exNS + "a_b", query2, null, 100));
        ts.addTest((Test)new TestExprURI("ex:", exNS, query2, null, 100));
        ts.addTest((Test)new TestExprURI("x.:", xNS, query2, null, 250));
        ts.addTest((Test)new TestExprURI("rdf:_2", rdfNS + "_2", query2, null, 100));
        ts.addTest((Test)new TestExprURI("rdf:__2", rdfNS + "__2", query2, null, 100));
        ts.addTest((Test)new TestExprURI(":b", dftNS + "b", query2, null, 100));
        ts.addTest((Test)new TestExprURI(":", dftNS, query2, null, 100));
        ts.addTest((Test)new TestExprURI(":\\u00E9", dftNS + "\u00e9", query2, null, 100));
        ts.addTest((Test)new TestExprURI("\\u0065\\u0078:", exNS, query2, null, 100));
        ts.addTest((Test)new TestExprURI("select:a", selNS + "a", query2, null, 100));
        ts.addTest((Test)new TestExprRDFTerm("_:", 250));
        ts.addTest((Test)new TestExprURI("ex:a.", exNS + "a", query2, null, 100));
        ts.addTest((Test)new TestExprURI("ex:a.a", exNS + "a.a", query2, null, 100));
        ts.addTest((Test)new TestExprURI("x.:a.a", xNS + "a.a", query2, null, 250));
        ts.addTest((Test)new TestExprNumeric("1:b", 1L));
        ts.addTest((Test)new TestExprURI("ex:2", exNS, query2, null, 100));
        return ts;
    }

    public static TestSuite rdfTerms() {
        TestSuite ts = new TestSuite("RDF terms: general");
        ts.addTest((Test)new TestExprBoolean("'fred'@en = 'fred'", false));
        ts.addTest((Test)new TestExprBoolean("'fred'@en = 'bert'", false));
        ts.addTest((Test)new TestExprBoolean("'fred'@en != 'fred'", true));
        ts.addTest((Test)new TestExprBoolean("'fred'@en != 'bert'", true));
        ts.addTest((Test)new TestExprBoolean("'chat'@en = 'chat'@fr", false));
        ts.addTest((Test)new TestExprBoolean("'chat'@en = 'maison'@fr", false));
        ts.addTest((Test)new TestExprBoolean("'chat'@en != 'chat'@fr", true));
        ts.addTest((Test)new TestExprBoolean("'chat'@en != 'maison'@fr", true));
        return ts;
    }

    public static TestSuite typedLiterals() {
        TestSuite ts = new TestSuite("Type Literals");
        ts.addTest((Test)new TestExprBoolean("'fred'^^<type1> = 'fred'^^<type1>", true));
        ts.addTest((Test)new TestExprBoolean("'fred'^^<type1> != 'joe'^^<type1>", false));
        ts.addTest((Test)new TestExprBoolean("'fred'^^<type1> = 'fred'^^<type2>", false));
        ts.addTest((Test)new TestExprBoolean("'fred'^^<type1> != 'fred'^^<type2>", false));
        ts.addTest((Test)new TestExprBoolean("'fred'^^<" + XSDDatatype.XSDstring.getURI() + "> = 'fred'", true));
        ts.addTest((Test)new TestExprBoolean("'fred'^^<type1> = 'fred'", false));
        ts.addTest((Test)new TestExprBoolean("'fred'^^<type1> != 'fred'", true));
        ts.addTest((Test)new TestExprNumeric("'21'^^<" + XSDDatatype.XSDinteger.getURI() + ">", 21L));
        ts.addTest((Test)new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 21", true));
        ts.addTest((Test)new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 22", false));
        ts.addTest((Test)new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> != 21", false));
        ts.addTest((Test)new TestExprBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> != 22", true));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1> = 'y'^^<type1>", false));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1> != 'y'^^<type1>", false));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1> != 'x'^^<type1>", false));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1> = 'y'^^<type2>", false));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1> != 'y'^^<type2>", false));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1> != 'y'^^<type2>", false));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1>  = 21", false, 200));
        ts.addTest((Test)new TestExprBoolean("'x'^^<type1> != 21", false));
        return ts;
    }

    public static TestSuite stringExpr() {
        TestSuite ts = new TestSuite("String Expressions");
        ts.addTest((Test)new TestExprString("'a\\nb'", "a\nb"));
        ts.addTest((Test)new TestExprString("'a\\n'", "a\n"));
        ts.addTest((Test)new TestExprString("'\\nb'", "\nb"));
        ts.addTest((Test)new TestExprString("'a\\tb'", "a\tb"));
        ts.addTest((Test)new TestExprString("'a\\bb'", "a\bb"));
        ts.addTest((Test)new TestExprString("'a\\rb'", "a\rb"));
        ts.addTest((Test)new TestExprString("'a\\fb'", "a\fb"));
        ts.addTest((Test)new TestExprString("'a\\\\b'", "a\\b"));
        ts.addTest((Test)new TestExprString("'a\\u0020a'", "a a"));
        ts.addTest((Test)new TestExprString("'a\\uF021'", "a\uf021"));
        ts.addTest((Test)new TestExprString("'a\\X'", "", 250));
        ts.addTest((Test)new TestExprString("'aaa\\'", "", 250));
        ts.addTest((Test)new TestExprString("'\\u'", "", 250));
        ts.addTest((Test)new TestExprString("'\\u111'", "", 250));
        ts.addTest((Test)new TestExprBoolean("'fred\\\\3' != \"fred3\"", true));
        ts.addTest((Test)new TestExprBoolean("'urn:fred' = <urn:fred>", false));
        ts.addTest((Test)new TestExprBoolean("'urn:fred' != <urn:fred>", true));
        ts.addTest((Test)new TestExprBoolean("REGEX('aabbcc', 'abbc')", true));
        ts.addTest((Test)new TestExprBoolean("REGEX('aabbcc' , 'a..c')", true));
        ts.addTest((Test)new TestExprBoolean("REGEX('aabbcc' , '^aabb')", true));
        ts.addTest((Test)new TestExprBoolean("REGEX('aabbcc' , 'cc$')", true));
        ts.addTest((Test)new TestExprBoolean("! REGEX('aabbcc' , 'abbc')", false));
        ts.addTest((Test)new TestExprBoolean("REGEX('aa\\\\cc', '\\\\\\\\')", true));
        ts.addTest((Test)new TestExprBoolean("REGEX('aab*bcc', 'ab\\\\*bc')", true));
        ts.addTest((Test)new TestExprBoolean("REGEX('aabbcc',  'ab\\\\\\\\*bc')", true));
        ts.addTest((Test)new TestExprBoolean("REGEX('aabbcc', 'B.*B', 'i')", true));
        ts.addTest((Test)new TestExprBoolean("2 < 'fred'", 200));
        return ts;
    }

    public static TestSuite builtinOps() {
        TestSuite ts = new TestSuite("Builtin Operators");
        BindingMap env = new BindingMap();
        env.add("a", Node.createLiteral((String)"A"));
        env.add("b", Node.createAnon());
        env.add("x", Node.createURI((String)"urn:x"));
        ts.addTest((Test)new TestExprString("datatype('fred')", 200));
        ts.addTest((Test)new TestExprBoolean("datatype('fred'^^<urn:foo>) = <urn:foo>", true));
        ts.addTest((Test)new TestExprBoolean("datatype('fred'^^<foo>) = <Foo>", false));
        ts.addTest((Test)new TestExprString("lang('fred'@en)", "en"));
        ts.addTest((Test)new TestExprString("lang('fred'@en-uk)", "en-uk"));
        ts.addTest((Test)new TestExprString("lang('fred')", ""));
        ts.addTest((Test)new TestExprBoolean("isURI(?x)", true, env));
        ts.addTest((Test)new TestExprBoolean("isURI(?a)", false, env));
        ts.addTest((Test)new TestExprBoolean("isURI(?b)", false, env));
        ts.addTest((Test)new TestExprBoolean("isURI(?y)", false, env, 200));
        ts.addTest((Test)new TestExprBoolean("isURI(<urn:foo>)", true, env));
        ts.addTest((Test)new TestExprBoolean("isURI('bar')", false, env));
        ts.addTest((Test)new TestExprBoolean("isLiteral(?x)", false, env));
        ts.addTest((Test)new TestExprBoolean("isLiteral(?a)", true, env));
        ts.addTest((Test)new TestExprBoolean("isLiteral(?b)", false, env));
        ts.addTest((Test)new TestExprBoolean("isLiteral(?y)", false, env, 200));
        ts.addTest((Test)new TestExprBoolean("isBlank(?x)", false, env));
        ts.addTest((Test)new TestExprBoolean("isBlank(?a)", false, env));
        ts.addTest((Test)new TestExprBoolean("isBlank(?b)", true, env));
        ts.addTest((Test)new TestExprBoolean("isBlank(?y)", false, env, 200));
        ts.addTest((Test)new TestExprBoolean("bound(?a)", true, env));
        ts.addTest((Test)new TestExprBoolean("bound(?b)", true, env));
        ts.addTest((Test)new TestExprBoolean("bound(?x)", true, env));
        ts.addTest((Test)new TestExprBoolean("bound(?y)", false, env));
        ts.addTest((Test)new TestExprString("str(<urn:x>)", "urn:x"));
        ts.addTest((Test)new TestExprString("str('')", ""));
        ts.addTest((Test)new TestExprString("str(15)", "15"));
        ts.addTest((Test)new TestExprString("str('15.20'^^<" + XSDDatatype.XSDdouble.getURI() + ">)", "15.20"));
        ts.addTest((Test)new TestExprString("str('lex'^^<x:unknown>)", "lex"));
        return ts;
    }

    public static TestSuite castExpr() {
        String xsd = "http://www.w3.org/2001/XMLSchema#";
        TestSuite ts = new TestSuite("XSD Casts");
        ts.addTest((Test)new TestExprNumeric("<" + xsd + "integer>('3')", 3L));
        ts.addTest((Test)new TestExprNumeric("<" + xsd + "byte>('3')", 3L));
        ts.addTest((Test)new TestExprNumeric("<" + xsd + "int>('3')", 3L));
        ts.addTest((Test)new TestExprBoolean("<" + xsd + "double>('3') = 3", true));
        ts.addTest((Test)new TestExprBoolean("<" + xsd + "float>('3') = 3", true));
        ts.addTest((Test)new TestExprBoolean("<" + xsd + "double>('3') = <" + xsd + "float>('3')", true));
        ts.addTest((Test)new TestExprBoolean("<" + xsd + "double>(str('3')) = 3", true));
        return ts;
    }
}

