/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.test;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.query.ARQ;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryExecution;
import mx.com.hp.hpl.jena.query.QueryExecutionFactory;
import mx.com.hp.hpl.jena.query.QueryFactory;
import mx.com.hp.hpl.jena.query.QuerySolution;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.ResultSetFormatter;
import mx.com.hp.hpl.jena.query.core.ResultBinding;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;

public class TestMisc
extends TestCase {
    private static final String ns = "http://example/ns#";
    Model m = null;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestMisc.class);
        ts.setName("MiscARQ");
        return ts;
    }

    public void setUp() {
        this.m = ModelFactory.createDefaultModel();
        Resource r1 = this.m.createResource();
        Property p1 = this.m.createProperty("http://example/ns#p1");
        Property p2 = this.m.createProperty("http://example/ns#p1");
        Property p3 = this.m.createProperty("http://example/ns#p1");
        this.m.add(r1, p1, "x1");
        this.m.add(r1, p2, "X2");
        this.m.add(r1, p3, "y1");
    }

    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_API1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        try {
            ResultSet rs = qExec.execSelect();
            TestMisc.assertTrue((String)"No results", (boolean)rs.hasNext());
            QuerySolution qs = rs.nextSolution();
            Resource qr = qs.getResource("s");
            TestMisc.assertSame((String)"Not the same model as queried", (Object)qr.getModel(), (Object)this.m);
        }
        finally {
            qExec.close();
        }
    }

    public void test_OptRegex1() {
        this.execRegexTest(1, "SELECT * {?s ?p ?o . FILTER regex(?o, '^x')}");
    }

    public void test_OptRegex2() {
        this.execRegexTest(2, "SELECT * {?s ?p ?o . FILTER regex(?o, '^x', 'i')}");
    }

    public void testInitialBindings1() {
        QueryExecution qExec = this.makeQExec("SELECT * {?s ?p ?o}");
        ResultBinding rb = new ResultBinding(this.m);
        rb.add("o", (RDFNode)this.m.createLiteral("y1"));
        qExec.setInitialBinding(rb);
        int count = this.queryAndCount(qExec);
        TestMisc.assertEquals((String)"Initial binding didn't restrict query properly", (int)1, (int)count);
    }

    private void execRegexTest(String queryString) {
        this.execRegexTest(-1, queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execRegexTest(int expected, String queryString) {
        Object b = ARQ.getContext().get(ARQ.enableRegexConstraintsOpt);
        try {
            ARQ.getContext().set(ARQ.enableRegexConstraintsOpt, "false");
            int count1 = this.queryAndCount(queryString);
            ARQ.getContext().set(ARQ.enableRegexConstraintsOpt, "true");
            int count2 = this.queryAndCount(queryString);
            TestMisc.assertEquals((String)"Different number of results", (int)count1, (int)count2);
            if (expected >= 0) {
                TestMisc.assertEquals((String)"Unexpected number of results", (int)expected, (int)count1);
            }
        }
        finally {
            ARQ.getContext().set(ARQ.enableRegexConstraintsOpt, b);
        }
    }

    private QueryExecution makeQExec(String queryString) {
        Query q = QueryFactory.create(queryString);
        QueryExecution qExec = QueryExecutionFactory.create(q, this.m);
        return qExec;
    }

    private int queryAndCount(String queryString) {
        QueryExecution qExec = this.makeQExec(queryString);
        return this.queryAndCount(qExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int queryAndCount(QueryExecution qExec) {
        try {
            ResultSet rs = qExec.execSelect();
            int n = ResultSetFormatter.consume(rs);
            return n;
        }
        finally {
            qExec.close();
        }
    }
}

