/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.test;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.util.Utils;

public class TestNodeValue
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestNodeValue.class);
        ts.setName(Utils.classShortName(TestNodeValue.class));
        return ts;
    }

    public void testNum1() {
        NodeValue v = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.isNode());
    }

    public void testNum2() {
        NodeValue v = NodeValue.makeDouble(5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.isNode());
    }

    public void testNum3() {
        NodeValue v = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
    }

    public void testNum4() {
        NodeValue v = NodeValue.makeNodeDouble(5.0);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
    }

    public void testNodeInt1() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
    }

    public void testNodeInt2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
    }

    public void testNodeInt3() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDinteger);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57", (String)actualStr);
    }

    public void testNodeInt4() {
        NodeValue v = NodeValue.makeNodeInteger(18L);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"18", (String)actualStr);
    }

    public void testNodeInt5() {
        NodeValue v = NodeValue.makeNodeInteger("018");
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not an integer: " + v), (boolean)v.isInteger());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"018", (String)actualStr);
    }

    public void testNodeDouble1() {
        NodeValue v = NodeValue.makeNode("57.0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"57.0", (String)actualStr);
    }

    public void testNodeDouble2() {
        NodeValue v = NodeValue.makeNode("57", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"57\"^^<" + XSDDatatype.XSDdouble.getURI() + ">"), (String)actualStr);
    }

    public void testNodeDouble3() {
        NodeValue v = NodeValue.makeNode("057.0", XSDDatatype.XSDdouble);
        TestNodeValue.assertTrue((String)("Not a number: " + v), (boolean)v.isNumber());
        TestNodeValue.assertTrue((String)("Not a double: " + v), (boolean)v.isDouble());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"057.0", (String)actualStr);
    }

    public void testNodeBool1() {
        NodeValue v = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        TestNodeValue.assertTrue((String)("Not satisfied: " + v), (boolean)v.isSatisfied(null, null));
    }

    public void testNodeBool2() {
        NodeValue v = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
        TestNodeValue.assertTrue((String)("Not a boolean: " + v), (boolean)v.isBoolean());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        TestNodeValue.assertFalse((String)("Satisfied: " + v), (boolean)v.isSatisfied(null, null));
    }

    public void testFloatDouble1() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.5");
        NodeValue v2 = NodeValue.makeNode("1.5", XSDDatatype.XSDfloat);
        TestNodeValue.assertTrue((String)"Should be equal: 1.5 float and 1.5 double", (boolean)NodeValue.sameValueAs(v1, v2));
    }

    public void testFloatDouble5() {
        NodeValue v1 = NodeValue.makeNodeDouble("1.3");
        NodeValue v2 = NodeValue.makeNode("1.3", XSDDatatype.XSDfloat);
        TestNodeValue.assertFalse((String)"Should not be equal: 1.3 float and 1.3 double", (boolean)NodeValue.sameValueAs(v1, v2));
    }

    public void testString1() {
        NodeValue v = NodeValue.makeString("string");
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertFalse((String)("Is a node: " + v), (boolean)v.isNode());
    }

    public void testNodeString1() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
    }

    public void testNodeString2() {
        NodeValue v = NodeValue.makeNode("string", null, (String)null);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)"\"string\"", (String)actualStr);
    }

    public void testNodeString3() {
        NodeValue v = NodeValue.makeNode("string", XSDDatatype.XSDstring);
        TestNodeValue.assertTrue((String)("Not a string: " + v), (boolean)v.isString());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        String actualStr = v.asQuotedString();
        TestNodeValue.assertEquals((String)"Print form mismatch", (String)("\"string\"^^<" + XSDDatatype.XSDstring.getURI() + ">"), (String)actualStr);
    }

    public void testDate1() {
        GregorianCalendar cal1 = new GregorianCalendar();
        ((Calendar)cal1).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal1.setTimeInMillis(0L);
        cal1.set(2005, 1, 18, 20, 39, 10);
        NodeValue v = NodeValue.makeNode("2005-02-18T20:39:10Z", XSDDatatype.XSDdateTime);
        TestNodeValue.assertTrue((String)("Not a date: " + v), (boolean)v.isDate());
        TestNodeValue.assertTrue((String)("Not a node: " + v), (boolean)v.isNode());
        Calendar cal2 = v.getDate();
        TestNodeValue.assertEquals((String)("Not equal: " + v), (Object)cal1, (Object)cal2);
    }

    public void testSameValueAsIntPlain() {
        NodeValue nv5a = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeInteger(7L);
        TestNodeValue.assertTrue((String)("Different values (" + nv5a + "," + nv7 + ")"), (!NodeValue.sameValueAs(nv5a, nv7) ? 1 : 0) != 0);
        NodeValue nv5b = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv5a + "," + nv5b + ")"), (boolean)NodeValue.sameValueAs(nv5a, nv5b));
    }

    public void testSameValueAsIntNodeInt() {
        NodeValue nv5a = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeNodeInteger(7L);
        TestNodeValue.assertTrue((String)("Different values (" + nv5a + "," + nv7 + ")"), (!NodeValue.sameValueAs(nv5a, nv7) ? 1 : 0) != 0);
        NodeValue nv5b = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Different values (" + nv5a + "," + nv5b + ")"), (boolean)NodeValue.sameValueAs(nv5a, nv5b));
    }

    public void testCompareAsInt() {
        NodeValue nv5a = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeInteger(7L);
        TestNodeValue.assertTrue((String)("Does not compare " + nv5a + " & " + nv7), (NodeValue.compare(nv5a, nv7) == -1 ? 1 : 0) != 0);
        NodeValue nv5b = NodeValue.makeInteger(5L);
        TestNodeValue.assertTrue((String)("Does not compare " + nv5a + " & " + nv5b), (NodeValue.compare(nv5a, nv5b) == 0 ? 1 : 0) != 0);
    }

    public void testCompareAsIntNodeInt() {
        NodeValue nv5a = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeNodeInteger(7L);
        TestNodeValue.assertTrue((String)("Does not compare " + nv5a + " & " + nv7), (NodeValue.compare(nv5a, nv7) == -1 ? 1 : 0) != 0);
        NodeValue nv5b = NodeValue.makeNodeInteger(5L);
        TestNodeValue.assertTrue((String)("Does not compare " + nv5a + " & " + nv5b), (NodeValue.compare(nv5a, nv5b) == 0 ? 1 : 0) != 0);
    }

    public void testEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals3() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeInteger(1L);
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testEquals4() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode(Node.createURI((String)"http://example"));
        TestNodeValue.assertEquals((String)"Not NodeValue.equals()", (Object)nv1, (Object)nv2);
    }

    public void testNotEquals1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }

    public void testNotEquals2() {
        NodeValue nv1 = NodeValue.makeNodeInteger(1L);
        NodeValue nv2 = NodeValue.makeNodeString("1");
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }

    public void testNotEquals3() {
        NodeValue nv1 = NodeValue.makeNode(Node.createURI((String)"http://example"));
        NodeValue nv2 = NodeValue.makeNode(Node.createLiteral((String)"http://example"));
        TestNodeValue.assertFalse((String)"NodeValue.equals()", (boolean)nv1.equals(nv2));
    }
}

