/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.test;

import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.ResultSetFactory;
import mx.com.hp.hpl.jena.query.core.BindingMap;
import mx.com.hp.hpl.jena.query.engine.ResultSetStream;
import mx.com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import mx.com.hp.hpl.jena.query.resultset.RSCompare;
import mx.com.hp.hpl.jena.query.resultset.ResultSetMem;
import mx.com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import mx.com.hp.hpl.jena.query.util.Utils;

public class TestResultSet
extends TestCase {
    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestResultSet.class);
        ts.setName(Utils.classShortName(TestResultSet.class));
        return ts;
    }

    public void test_RS_cmp_1() {
        ResultSetMem rs1 = new ResultSetMem();
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertTrue((boolean)RSCompare.sameOrdered(rs1, rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertTrue((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_2() {
        ResultSet rs1 = this.make("x", Node.createURI((String)"tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(rs1, rs2));
    }

    public void test_RS_cmp_3() {
        ResultSet rs1 = this.make("x", Node.createURI((String)"tag:local"));
        ResultSetMem rs2 = new ResultSetMem();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_4() {
        ResultSet rs1 = this.make("x", Node.createURI((String)"tag:local"));
        ResultSet rs2 = this.make("x", Node.createURI((String)"tag:local"));
        TestResultSet.assertTrue((boolean)RSCompare.sameOrdered(rs1, rs2));
        TestResultSet.assertTrue((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_5() {
        ResultSetRewindable rs1 = this.makeRewindable("x", Node.createURI((String)"tag:local:1"));
        ResultSetRewindable rs2 = this.makeRewindable("x", Node.createURI((String)"tag:local:2"));
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(rs1, rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    public void test_RS_cmp_6() {
        ResultSetRewindable rs1 = this.makeRewindable("x", Node.createURI((String)"tag:local"));
        ResultSetRewindable rs2 = this.makeRewindable("y", Node.createURI((String)"tag:local"));
        TestResultSet.assertFalse((boolean)RSCompare.sameOrdered(rs1, rs2));
        rs1.reset();
        rs2.reset();
        TestResultSet.assertFalse((boolean)RSCompare.sameUnordered(rs1, rs2));
    }

    private ResultSet make(String var, Node val) {
        BindingMap b = new BindingMap();
        b.add(var, val);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var);
        QueryIterSingleton qIter = new QueryIterSingleton(b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var, Node val) {
        ResultSet rs = this.make(var, val);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }

    private ResultSet make(String var1, Node val1, String var2, Node val2) {
        BindingMap b = new BindingMap();
        b.add(var1, val1);
        b.add(var2, val2);
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(var1);
        vars.add(var2);
        QueryIterSingleton qIter = new QueryIterSingleton(b, null);
        ResultSetStream rs = new ResultSetStream(vars, null, qIter);
        return rs;
    }

    private ResultSetRewindable makeRewindable(String var1, Node val1, String var2, Node val2) {
        ResultSet rs = this.make(var1, val1, var2, val2);
        ResultSetRewindable rsw = ResultSetFactory.makeRewindable(rs);
        return rsw;
    }
}

