/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import mx.com.hp.hpl.jena.query.util.ClosureTest;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Closure {
    private static Log logger = LogFactory.getLog((String)Closure.class.getName());

    public static Model closure(Statement stmt) {
        return Closure.closure(stmt, new ClosureBNode());
    }

    public static Model closure(Statement statement, ClosureTest test) {
        return Closure.closure(statement, test, ModelFactory.createDefaultModel());
    }

    public static Model closure(Statement statement, Model model) {
        return Closure.closure(statement, (ClosureTest)new ClosureBNode(), model);
    }

    public static Model closure(Statement statement, ClosureTest test, Model model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closure: " + statement));
        }
        ArrayList visited = new ArrayList();
        Closure.closure(statement, model, visited, test);
        return model;
    }

    public static Model closure(Resource resource, boolean testThisNode) {
        return Closure.closure(resource, (ClosureTest)new ClosureBNode(), testThisNode);
    }

    public static Model closure(Resource resource, ClosureTest test, boolean testThisNode) {
        return Closure.closure(resource, test, testThisNode, ModelFactory.createDefaultModel());
    }

    public static Model closure(Resource resource, boolean testThisNode, Model results) {
        return Closure.closure(resource, new ClosureBNode(), testThisNode, results);
    }

    public static Model closure(Resource resource, ClosureTest test, boolean testThisNode, Model results) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closure: " + resource));
        }
        ArrayList visited = new ArrayList();
        if (!testThisNode) {
            Closure.closureNoTest(resource, results, visited, test);
        } else {
            Closure.closure((RDFNode)resource, results, visited, test);
        }
        return results;
    }

    private static void closure(Statement stmt, Model closureBlob, Collection visited, ClosureTest test) {
        if (logger.isDebugEnabled()) {
            logger.trace((Object)stmt.toString());
        }
        if (test.includeStmt(stmt)) {
            closureBlob.add(stmt);
        }
        Closure.closure((RDFNode)stmt.getSubject(), closureBlob, visited, test);
        Closure.closure(stmt.getObject(), closureBlob, visited, test);
    }

    private static void closure(RDFNode n, Model closureBlob, Collection visited, ClosureTest test) {
        if (!(n instanceof Resource)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("  Not a resource: " + n));
            }
            return;
        }
        Resource r = (Resource)n;
        if (visited.contains(r)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("  Already visited: " + r));
            }
            return;
        }
        if (!test.traverse(r)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("  End traverse: " + r));
            }
            return;
        }
        Closure.closureNoTest(r, closureBlob, visited, test);
    }

    private static void closureNoTest(Resource r, Model closureBlob, Collection visited, ClosureTest test) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("@ " + r + " :: " + closureBlob.size() + " //" + Closure.dbg_string(visited)));
        }
        visited.add(r);
        StmtIterator sIter = r.listProperties();
        while (sIter.hasNext()) {
            Statement stmt = sIter.nextStatement();
            Closure.closure(stmt, closureBlob, visited, test);
        }
    }

    private static String dbg_string(Collection s) {
        String tmp = "";
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            tmp = tmp + " " + iter.next().toString();
        }
        return tmp;
    }

    public static class ClosureReachable
    implements ClosureTest {
        public boolean traverse(Resource r) {
            return true;
        }

        public boolean includeStmt(Statement s) {
            return true;
        }
    }

    public static class ClosureBNode
    implements ClosureTest {
        public boolean traverse(Resource r) {
            return r.isAnon();
        }

        public boolean includeStmt(Statement s) {
            return true;
        }
    }
}

