/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.query.util.Symbol;

public class Context {
    protected Map context = new HashMap();

    public Context() {
    }

    public Context(Context cxt) {
        this.context.putAll(cxt.context);
    }

    public Object get(Symbol property) {
        return this.context.get(property);
    }

    public Object get(Symbol property, Object defaultValue) {
        Object x = this.context.get(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public void put(Symbol property, Object value) {
        this.context.put(property, value);
    }

    public void set(Symbol property, Object value) {
        this.context.put(property, value);
    }

    public void setIfUndef(Symbol property, Object value) {
        Object x = this.context.get(property);
        if (x == null) {
            this.context.put(property, value);
        }
    }

    public void remove(Symbol property) {
        this.context.remove(property);
    }

    public void unset(Symbol property) {
        this.context.remove(property);
    }

    public boolean isDefined(Symbol property) {
        return this.context.containsKey(property);
    }

    public boolean isUndef(Symbol property) {
        return !this.isDefined(property);
    }

    public String getAsString(Symbol property) {
        Object x = this.context.get(property);
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public void setTrue(Symbol property) {
        this.set(property, Boolean.TRUE);
    }

    public void setFalse(Symbol property) {
        this.set(property, Boolean.FALSE);
    }

    public boolean isTrue(Symbol property) {
        return this.isTrue(property, false);
    }

    public boolean isTrueOrUndef(Symbol property) {
        return this.isTrue(property, true);
    }

    private boolean isTrue(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("true")) {
            return true;
        }
        return x.equals(Boolean.TRUE);
    }

    public boolean isFalse(Symbol property) {
        return this.isFalse(property, false);
    }

    public boolean isFalseOrUndef(Symbol property) {
        return this.isFalse(property, true);
    }

    private boolean isFalse(Symbol property, boolean dft) {
        String s;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s = (String)x).equalsIgnoreCase("false")) {
            return true;
        }
        return x.equals(Boolean.FALSE);
    }

    public boolean hasValue(Symbol property, Object value) {
        Object x = this.get(property);
        if (x == null && value == null) {
            return true;
        }
        if (x == null || value == null) {
            return false;
        }
        return x.equals(value);
    }

    public boolean hasValueAsString(Symbol property, String value) {
        return this.hasValueAsString(property, value, false);
    }

    public boolean hasValueAsString(Symbol property, String value, boolean ignoreCase) {
        String s = this.getAsString(property);
        if (s == null && value == null) {
            return true;
        }
        if (s == null || value == null) {
            return false;
        }
        if (ignoreCase) {
            return s.equalsIgnoreCase(value);
        }
        return s.equals(value);
    }

    public Set keys() {
        return this.context.keySet();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Context)) {
            return false;
        }
        Context cxt = (Context)other;
        return ((Object)this.context).equals(cxt.context);
    }

    public String toString() {
        return this.context.toString();
    }
}

