/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import java.util.List;
import java.util.ListIterator;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.NodeValue;

public class ExprUtils {
    public static String joinListEval(List args, Binding binding, ExecutionContext execCxt, String sep) {
        if (args == null) {
            return "<<Null list>>";
        }
        if (args.size() == 0) {
            return "<<Empty list>>";
        }
        StringBuffer s = new StringBuffer();
        boolean first = true;
        ListIterator iter = args.listIterator();
        while (iter.hasNext()) {
            NodeValue nv;
            Expr expr;
            if (!first) {
                s.append(sep);
            }
            if ((expr = (Expr)iter.next()).isVariable()) {
                s.append("?" + expr.getVarName());
                s.append(" = ");
                nv = expr.eval(binding, execCxt);
                s.append(nv.asUnquotedString());
            } else {
                nv = expr.eval(binding, execCxt);
                s.append(nv.asUnquotedString());
            }
            first = false;
        }
        return s.toString();
    }

    public static String joinList(List args, String sep) {
        if (args == null) {
            return "<<Null list>>";
        }
        if (args.size() == 0) {
            return "<<Empty list>>";
        }
        StringBuffer s = new StringBuffer();
        boolean first = true;
        ListIterator iter = args.listIterator();
        while (iter.hasNext()) {
            Expr ex;
            if (!first) {
                s.append(sep);
            }
            if ((ex = (Expr)iter.next()) instanceof NodeValue) {
                NodeValue nv = (NodeValue)ex;
                if (nv.isString()) {
                    s.append(nv.getString());
                } else {
                    s.append(nv.asQuotedString());
                }
            } else {
                s.append(ex.toString());
            }
            first = false;
        }
        return s.toString();
    }
}

