/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import java.math.BigInteger;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Node_Literal;
import mx.com.hp.hpl.jena.query.Constants;
import mx.com.hp.hpl.jena.query.core.ARQInternalErrorException;
import mx.com.hp.hpl.jena.query.serializer.SerializationContext;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.vocabulary.XSD;

public class FmtUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printOpName = true;
    static PrefixMapping prefixes = PrefixMapping.Factory.create().setNsPrefixes(PrefixMapping.Standard).setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    static boolean applyUnicodeEscapes = false;

    public static String stringForObject(Object obj) {
        if (obj == null) {
            return "<<null>>";
        }
        if (obj instanceof RDFNode) {
            return FmtUtils.stringForRDFNode((RDFNode)obj);
        }
        if (obj instanceof Node) {
            return FmtUtils.stringForNode((Node)obj);
        }
        return obj.toString();
    }

    public static String stringForRDFNode(RDFNode obj) {
        return FmtUtils.stringForRDFNode(obj, null);
    }

    public static String stringForRDFNode(RDFNode obj, SerializationContext context) {
        return FmtUtils.stringForNode(obj.asNode(), context);
    }

    public static String stringForLiteral(Node_Literal literal, SerializationContext context) {
        String datatype = literal.getLiteralDatatypeURI();
        String lang = literal.getLiteralLanguage();
        String s = literal.getLiteralLexicalForm();
        if (datatype != null) {
            if (datatype.equals(XSD.integer.getURI())) {
                try {
                    new BigInteger(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xdouble.getURI()) && (s.indexOf(46) >= 0 || s.indexOf(101) >= 0 || s.indexOf(69) >= 0)) {
                try {
                    Double.parseDouble(s);
                    return s;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (datatype.equals(XSD.xboolean.getURI())) {
                if (s.equalsIgnoreCase("true")) {
                    return s;
                }
                if (s.equalsIgnoreCase("false")) {
                    return s;
                }
            }
        }
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("\"");
        FmtUtils.stringEsc(sbuff, s, true);
        sbuff.append("\"");
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(FmtUtils.stringForURI(datatype, context));
        }
        return sbuff.toString();
    }

    public static String stringForString(String str) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("\"");
        FmtUtils.stringEsc(sbuff, str, true);
        sbuff.append("\"");
        return sbuff.toString();
    }

    public static String stringForResource(Resource r) {
        return FmtUtils.stringForResource(r, new SerializationContext(null, (PrefixMapping)r.getModel(), null));
    }

    public static String stringForResource(Resource r, SerializationContext context) {
        return FmtUtils.stringForNode(r.asNode(), context);
    }

    public static String stringForNode(Node n) {
        return FmtUtils.stringForNode(n, (SerializationContext)null);
    }

    public static String stringForNode(Node n, PrefixMapping prefixMap) {
        return FmtUtils.stringForNode(n, new SerializationContext(prefixMap));
    }

    public static String stringForNode(Node n, SerializationContext context) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            if (context == null) {
                return "[?]";
            }
            if (context.getBNodeMap() == null) {
                return "[??]";
            }
            return context.getBNodeMap().asString(n);
        }
        if (n.isLiteral()) {
            return FmtUtils.stringForLiteral((Node_Literal)n, context);
        }
        if (n.isURI()) {
            String uri = n.getURI();
            return FmtUtils.stringForURI(uri, context);
        }
        if (n.isVariable()) {
            if (n.getName().startsWith(Constants.anonVarMarker)) {
                return context.getBNodeMap().asString(n);
            }
            return "?" + n.getName();
        }
        return n.toString();
    }

    public static String stringForURI(String uri, SerializationContext context) {
        if (context == null) {
            return FmtUtils.stringForURI(uri, (PrefixMapping)null);
        }
        return FmtUtils.stringForURI(uri, context.getPrefixMapping());
    }

    public static String stringForURI(String uri, PrefixMapping mapping) {
        String tmp;
        if (mapping != null && (tmp = mapping.shortForm(uri)) != null && !tmp.equals(uri)) {
            int i = tmp.indexOf(58);
            if (i < 0) {
                throw new ARQInternalErrorException("Broken short form -- " + tmp);
            }
            String p = tmp.substring(0, i);
            String x = tmp.substring(i + 1);
            if (FmtUtils.checkValidPrefix(p) && FmtUtils.checkValidLocalname(x)) {
                return tmp;
            }
        }
        return "<" + FmtUtils.stringEsc(uri) + ">";
    }

    private static boolean checkValidPrefix(String prefixStr) {
        if (prefixStr.startsWith("_")) {
            return false;
        }
        return FmtUtils.checkValidLocalname(prefixStr);
    }

    private static boolean checkValidLocalname(String localname) {
        if (localname.length() == 0) {
            return true;
        }
        if (localname.endsWith(".")) {
            return false;
        }
        if (localname.startsWith(".")) {
            return false;
        }
        if (localname.startsWith(".")) {
            return false;
        }
        if (localname.indexOf(47) >= 0) {
            return false;
        }
        char ch = localname.charAt(0);
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        return ch == '_';
    }

    public static String stringEsc(String s) {
        return FmtUtils.stringEsc(s, true);
    }

    public static String stringEsc(String s, boolean singleLineString) {
        StringBuffer sb = new StringBuffer();
        FmtUtils.stringEsc(sb, s, singleLineString);
        return sb.toString();
    }

    public static void stringEsc(StringBuffer sbuff, String s) {
        FmtUtils.stringEsc(sbuff, s, true);
    }

    public static void stringEsc(StringBuffer sbuff, String s, boolean singleLineString) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                sbuff.append('\\');
                sbuff.append(c);
                continue;
            }
            if (singleLineString && (c == '\n' || c == '\r' || c == '\f')) {
                if (c == '\n') {
                    sbuff.append("\\n");
                }
                if (c == '\t') {
                    sbuff.append("\\t");
                }
                if (c == '\r') {
                    sbuff.append("\\r");
                }
                if (c != '\f') continue;
                sbuff.append("\\f");
                continue;
            }
            if (!applyUnicodeEscapes) {
                sbuff.append(c);
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                sbuff.append(c);
                continue;
            }
            String hexstr = Integer.toHexString(c).toUpperCase();
            sbuff.append("\\u");
            for (int pad = 4 - hexstr.length(); pad > 0; --pad) {
                sbuff.append("0");
            }
            sbuff.append(hexstr);
        }
    }
}

