/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GraphUtils {
    static Log log = LogFactory.getLog((Class)GraphUtils.class);
    static final Node CAR = RDF.first.asNode();
    static final Node CDR = RDF.rest.asNode();
    static final Node NIL = RDF.nil.asNode();
    static final Node BAG = RDF.Bag.asNode();
    static final Node ALT = RDF.Alt.asNode();
    static final Node SEQ = RDF.Seq.asNode();
    static final Node RDFtype = RDF.type.asNode();
    static final String membershipPattern = RDF.getURI() + "_\\d+";

    public static boolean isListMember(Graph graph, Node list2, Node member) {
        int i = GraphUtils.listIndex("listMember", graph, list2, member);
        return i >= 0;
    }

    public static int listIndex(Graph graph, Node list2, Node member) {
        return GraphUtils.listIndex("listMember", graph, list2, member);
    }

    public static int listIndex(String opName, Graph graph, Node list2, Node member) {
        if (graph == null) {
            log.warn((Object)(opName + " called with null graph"));
            return -1;
        }
        if (list2 == null) {
            log.warn((Object)(opName + " called with null list"));
            return -2;
        }
        if (member == null) {
            log.warn((Object)(opName + " called with null member"));
            return -3;
        }
        HashSet visited = new HashSet();
        int idx = GraphUtils.listIndex(graph, list2, member, visited, 0);
        return idx;
    }

    private static int listIndex(Graph graph, Node list2, Node member, Collection visited, int index) {
        if (list2.equals((Object)NIL)) {
            return -1;
        }
        if (graph.contains(list2, CAR, member)) {
            return index;
        }
        visited.add(list2);
        ExtendedIterator iter2 = graph.find(list2, CDR, Node.ANY);
        ++index;
        while (iter2.hasNext()) {
            Node x = ((Triple)iter2.next()).getObject();
            if (visited.contains(x)) {
                log.warn((Object)"Circular list detected");
                return -2;
            }
            int index2 = GraphUtils.listIndex(graph, x, member, visited, index);
            if (index2 <= 0) continue;
            return index2;
        }
        iter2.close();
        return -1;
    }

    public static List listMembers(Graph graph, Node list2) {
        if (graph == null) {
            log.warn((Object)"isListMember called with null graph");
            return null;
        }
        if (list2 == null) {
            log.warn((Object)"isListMember called with null list");
            return null;
        }
        ArrayList members = new ArrayList();
        HashSet visited = new HashSet();
        GraphUtils.findMembers(graph, list2, members, visited);
        return members;
    }

    private static void findMembers(Graph graph, Node n, List members, Set visited) {
        visited.add(n);
        ExtendedIterator iter = graph.find(n, CAR, Node.ANY);
        while (iter.hasNext()) {
            Node x = ((Triple)iter.next()).getObject();
            members.add(x);
        }
        iter.close();
        ExtendedIterator iter2 = graph.find(n, CDR, Node.ANY);
        while (iter2.hasNext()) {
            Node x = ((Triple)iter2.next()).getObject();
            if (visited.contains(x)) continue;
            GraphUtils.findMembers(graph, x, members, visited);
        }
        iter2.close();
    }

    public static Collection containerMembers(Graph graph, Node container2) {
        return GraphUtils.containerMembers(graph, container2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection containerMembers(Graph graph, Node container2, Node containerType) {
        if (!GraphUtils.isContainer(graph, container2, containerType)) {
            return null;
        }
        ExtendedIterator iter = graph.find(container2, Node.ANY, Node.ANY);
        ArrayList<Node> x = new ArrayList<Node>();
        try {
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                String p = t.getPredicate().getURI();
                if (!p.matches(membershipPattern)) continue;
                x.add(t.getObject());
            }
        }
        finally {
            iter.close();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContainerMember(Graph graph, Node container2, Node containerType, Node member) {
        if (graph == null) {
            log.warn((Object)"isListMember called with null graph");
            return false;
        }
        if (container2 == null) {
            log.warn((Object)"isListMember called with null list");
            return false;
        }
        if (member == null) {
            log.warn((Object)"isListMember called with null member");
            return false;
        }
        if (!GraphUtils.isContainer(graph, container2, containerType)) {
            return false;
        }
        ExtendedIterator iter = graph.find(container2, Node.ANY, member);
        try {
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                Node p = t.getPredicate();
                String u = p.getURI();
                if (!u.matches(membershipPattern)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            iter.close();
        }
        return false;
    }

    public static boolean isContainer(Graph graph, Node container2) {
        return GraphUtils.isContainer(graph, container2, null);
    }

    public static boolean isContainer(Graph graph, Node container2, Node containerType) {
        if (containerType == null) {
            containerType = Node.ANY;
        }
        return graph.contains(container2, RDFtype, containerType);
    }
}

