/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import mx.com.hp.hpl.jena.util.FileUtils;

public class IndentedWriter {
    PrintWriter out;
    int currentIndent = 0;
    int column = 0;
    int row = 1;
    boolean lineNumbers = false;
    boolean startingNewLine = true;
    private static int WidthLineNumber = 3;

    public IndentedWriter(OutputStream outStream) {
        this(outStream, false);
    }

    public IndentedWriter(OutputStream outStream, boolean withLineNumbers) {
        this(FileUtils.asPrintWriterUTF8((OutputStream)outStream), withLineNumbers);
    }

    IndentedWriter(Writer writer) {
        this(new PrintWriter(writer), false);
    }

    IndentedWriter(Writer writer, boolean withLineNumbers) {
        this(new PrintWriter(writer), withLineNumbers);
    }

    IndentedWriter(PrintWriter printWriter) {
        this(printWriter, false);
    }

    IndentedWriter(PrintWriter printWriter, boolean withLineNumbers) {
        this.out = printWriter;
        this.lineNumbers = withLineNumbers;
        this.startingNewLine = true;
    }

    public void print(String s) {
        this.lineStart();
        this.out.print(s);
        this.column += s.length();
    }

    public void print(char ch) {
        this.lineStart();
        this.out.print(ch);
        ++this.column;
    }

    public void println(String s) {
        this.print(s);
        this.newline();
    }

    public void println(char ch) {
        this.print(ch);
        this.newline();
    }

    public void println() {
        this.newline();
    }

    public void print(String s, int n) {
        for (int i = 0; i < n; ++i) {
            this.print(s);
        }
    }

    public void print(char ch, int n) {
        for (int i = 0; i < n; ++i) {
            this.print(ch);
        }
    }

    public void newline() {
        this.lineStart();
        this.out.println();
        this.startingNewLine = true;
        ++this.row;
        this.column = 0;
    }

    public void flush() {
        this.out.flush();
    }

    public void pad() {
        if (this.startingNewLine && this.currentIndent > 0) {
            this.lineStart();
        }
        this.padInt();
    }

    public void pad(int col) {
        this.pad(col, false);
    }

    public void pad(int col, boolean absoluteColumn) {
        if (!absoluteColumn) {
            col += this.currentIndent;
        }
        int spaces = col - this.column;
        for (int i = 0; i < spaces; ++i) {
            this.out.print(' ');
            ++this.column;
        }
    }

    private void padInt() {
        for (int i = this.column; i < this.currentIndent; ++i) {
            this.out.print(' ');
            ++this.column;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.column;
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public void incIndent(int x) {
        this.currentIndent += x;
    }

    public void decIndent(int x) {
        this.currentIndent -= x;
    }

    public void setIndent(int x) {
        this.currentIndent = x;
    }

    public boolean atLineStart() {
        return this.startingNewLine;
    }

    private void lineStart() {
        if (this.startingNewLine) {
            this.insertLineNumber();
        }
        this.padInt();
        this.startingNewLine = false;
    }

    private void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String s = Integer.toString(this.row);
        for (int i = 0; i < WidthLineNumber - s.length(); ++i) {
            this.out.print(' ');
        }
        this.out.print(s);
        this.out.print(' ');
    }
}

