/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import java.util.HashMap;
import java.util.Map;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.core.ARQInternalErrorException;
import org.apache.commons.logging.LogFactory;

public class NodeToLabelMap {
    int bNodeCounter = 0;
    Map bNodeStrings = new HashMap();
    boolean bNodesAsFakeURIs = false;
    String prefixString = "b";

    public NodeToLabelMap(String prefix, boolean bNodesAsFakeURIs) {
        this.bNodesAsFakeURIs = bNodesAsFakeURIs;
        this.prefixString = "_:" + prefix;
    }

    public String asString(Node n) {
        String s = (String)this.bNodeStrings.get(n);
        if (s != null) {
            return s;
        }
        if (this.bNodesAsFakeURIs && n.isBlank()) {
            s = "<_:" + n.getBlankNodeId().toString() + ">";
        } else {
            if (!n.isBlank() && !n.isVariable()) {
                LogFactory.getLog((Class)NodeToLabelMap.class).warn((Object)("Not a variable or bNode: " + n));
                return "";
            }
            s = this.prefixString + this.bNodeCounter++;
            this.bNodeStrings.put(n, s);
        }
        return s;
    }

    public boolean isBNodesAsFakeURIs() {
        return this.bNodesAsFakeURIs;
    }

    public void setBNodesAsFakeURIs(boolean nodesAsFakeURIs) {
        this.bNodesAsFakeURIs = nodesAsFakeURIs;
    }

    public String getPrefixString() {
        return this.prefixString;
    }

    public void setPrefixString(String prefix) {
        if (prefix == null) {
            LogFactory.getLog((Class)NodeToLabelMap.class).fatal((Object)"Prefix string is null");
            throw new ARQInternalErrorException("Prefix string is null");
        }
        if (prefix.equals("")) {
            LogFactory.getLog((Class)NodeToLabelMap.class).fatal((Object)"Prefix string is the empty string");
            throw new ARQInternalErrorException("Prefix string is the empty string");
        }
        this.prefixString = prefix;
    }
}

