/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util;

import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.core.ARQInternalErrorException;
import mx.com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.util.StringUtils;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import mx.com.hp.hpl.jena.rdf.model.impl.ModelCom;
import mx.com.hp.hpl.jena.rdf.model.impl.ResourceImpl;

public class NodeUtils {
    public static int compareNodesByValue(Node node1, Node node2) {
        int x = NodeUtils.compareNodesByKind(node1, node2);
        if (x != -15) {
            return x;
        }
        return NodeUtils.compareLiteralsByValue(node1, node2);
    }

    public static int compareNodesByKindTypeLexical(Node node1, Node node2) {
        int x = NodeUtils.compareNodesByKind(node1, node2);
        if (x != -15) {
            return x;
        }
        return NodeUtils.compareLiteralsLexical(node1, node2);
    }

    private static int compareNodesByKind(Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node1.isBlank()) {
            if (node2.isBlank()) {
                String s1 = node1.getBlankNodeId().toString();
                String s2 = node2.getBlankNodeId().toString();
                return StringUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node1.isURI()) {
            if (node2.isURI()) {
                String s1 = node1.getURI();
                String s2 = node2.getURI();
                return StringUtils.strCompare(s1, s2);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        if (node1.isLiteral() && node2.isLiteral()) {
            return -15;
        }
        throw new ARQInternalErrorException("Compare: " + node1 + "  " + node2);
    }

    private static int compareLiteralsByValue(Node node1, Node node2) {
        NodeValue nv1 = NodeValue.makeNode(node1);
        NodeValue nv2 = NodeValue.makeNode(node2);
        try {
            return NodeValue.compare(nv1, nv2);
        }
        catch (ExprEvalException ex) {
            String lex1 = nv1.asString();
            String lex2 = nv2.asString();
            return StringUtils.strCompare(lex1, lex2);
        }
    }

    private static int compareLiteralsLexical(Node node1, Node node2) {
        String lex1 = node1.getLiteralLexicalForm();
        String lex2 = node2.getLiteralLexicalForm();
        String dt1 = node1.getLiteralDatatypeURI();
        String dt2 = node2.getLiteralDatatypeURI();
        if (dt1 != null || dt2 == null) {
            // empty if block
        }
        if (dt1 != null && dt2 != null && dt1.equals(dt2)) {
            return StringUtils.strCompare(lex1, lex2);
        }
        if (dt1 == null || dt2 == null) {
            int x = StringUtils.strCompare(lex1, lex2);
            if (x != 0) {
                return x;
            }
            if (dt1 == null) {
                return -1;
            }
            if (dt2 == null) {
                return 1;
            }
            throw new QueryException("Bug: one plain literal: " + node1 + " and " + node2);
        }
        int x = StringUtils.strCompare(lex1, lex2);
        if (x != 0) {
            return x;
        }
        return StringUtils.strCompare(dt1, dt2);
    }

    public static RDFNode convertGraphNodeToRDFNode(Node n, Model model) {
        if (n.isLiteral()) {
            return new LiteralImpl(n, (ModelCom)model);
        }
        if (n.isURI() || n.isBlank()) {
            return new ResourceImpl(n, (ModelCom)model);
        }
        if (n.isVariable()) {
            throw new QueryException("Variable unbound: " + n);
        }
        QueryEngineUtils.log.warn((Object)("Unknown node type for node: " + n));
        return null;
    }
}

