/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.util.test;

import junit.framework.TestCase;
import mx.com.hp.hpl.jena.query.util.JenaURIException;
import mx.com.hp.hpl.jena.query.util.RelURI;
import mx.com.hp.hpl.jena.query.util.RelativeURIException;

public class TestURI
extends TestCase {
    public void testURI() {
        this.execTest("", "http://example.org/", "http://example.org/");
    }

    public void testURI_relX_1() {
        this.execTest("x", "http://example.org/ns", "http://example.org/x");
    }

    public void testURI_relX_2() {
        this.execTest("x", "http://example.org/", "http://example.org/x");
    }

    public void testURI2_relHashX_1() {
        this.execTest("#x", "http://example.org/ns", "http://example.org/ns#x");
    }

    public void testURI2_relHashX_2() {
        this.execTest("#x", "http://example.org/ns/", "http://example.org/ns/#x");
    }

    public void testURI_blank_1() {
        this.execTest("", "http://example.org/ns", "http://example.org/ns");
    }

    public void testURI_blank_2() {
        this.execTest("", "http://example.org/ns/", "http://example.org/ns/");
    }

    public void testURI_hash_1() {
        this.execTest("#", "http://example.org/ns", "http://example.org/ns#");
    }

    public void testURI_hash_2() {
        this.execTest("#", "http://example.org/ns/", "http://example.org/ns/#");
    }

    public void testBaseHash_1() {
        this.execTest("x", "http://example.org/ns#", "http://example.org/x");
    }

    public void testBaseHash_2() {
        this.execTest("x", "http://example.org#", "http://example.org/x");
    }

    public void testBaseHash_3() {
        this.execException("#", "base:x", RelativeURIException.class);
    }

    public void testBaseHash_4() {
        this.execException("#", "base:", JenaURIException.class);
    }

    public void testScheme_1() {
        this.execTest("x", "base:", "base:x");
    }

    public void testScheme_2() {
        this.execTest("/x", "base:", "base:/x");
    }

    public void testScheme_3() {
        this.execTestMatch("x", "file:", "^file:///.*/x$");
    }

    public void testScheme_4() {
        this.execTestMatch("file:x", null, "^file:///.*/x$");
    }

    public void testURI_file_1() {
        this.execTestMatch("file:x", "http://example.org/ns", "^file:///.*/x$");
    }

    public void testURI_file_2() {
        this.execTest("x", "file:///A/B/C", "file:///A/B/x");
    }

    public void testURI_file_3() {
        this.execTest("x", "file:///A/B/", "file:///A/B/x");
    }

    public void testURI_abs_1() {
        this.execTest("http://host/x", "http://example.org/ns", "http://host/x");
    }

    public void testURI_abs_2() {
        this.execTest("file:///x", "http://example.org/ns", "file:///x");
    }

    public void testURI_abs_3() {
        this.execTest("tag:foo", "http://example.org/ns", "tag:foo");
    }

    public void testURI_abs_4() {
        this.execTest("tag:/foo", "http://example.org/ns", "tag:/foo");
    }

    public void testURI_abs_5() {
        this.execTest("tag:/foo/", "http://example.org/ns", "tag:/foo/");
    }

    public void testURI_abs_6() {
        this.execTest("scheme99:/foo/", "http://example.org/ns", "scheme99:/foo/");
    }

    public void testURI_nullBase_1() {
        this.execTest("scheme99:/foo/", null, "scheme99:/foo/");
    }

    public void testURI_nullBase_2() {
        this.execException("foo", null, JenaURIException.class);
    }

    public void testHierURI_1() {
        this.execTest("../foo", "file:///dir/file", "file:///foo");
    }

    public void testHierURI_2() {
        this.execTest("../foo", "http://host/dir/file.html", "http://host/foo");
    }

    public void testHierURI_3() {
        this.execTest("../foo", "http://host/dir/", "http://host/foo");
    }

    public void testHierURI_4() {
        this.execTest("../foo", "http://host/", "http://host/../foo");
    }

    public void testHierURI_5() {
        this.execTest("../foo", "http://host/xyz", "http://host/../foo");
    }

    public void testFileURI_1() {
        this.execFileTest("file:///foo", "file:///foo");
    }

    public void testFileURI_2() {
        this.execFileTest("file://foo", "file://foo");
    }

    public void testFileURI_3() {
        this.execFileTest("file:/foo", "file:///foo");
    }

    public void testBaseEmpty() {
        this.execException("x", "", JenaURIException.class);
    }

    public void testBaseNull() {
        this.execException("x", null, JenaURIException.class);
    }

    public void testRelBase_1() {
        this.execException("x", "ns", RelativeURIException.class);
    }

    public void testRelBase_2() {
        this.execException("x", "/ns", RelativeURIException.class);
    }

    public void testURI_opaque_1() {
        this.execException("#x", "tag:A", RelativeURIException.class);
    }

    public void testURI_opaque_2() {
        this.execException("#x", "urn:x-jena:A", RelativeURIException.class);
    }

    public void testURI_opaque_3() {
        this.execException("#x", "urn:x-jena:A", RelativeURIException.class);
    }

    public void testURI_file_4() {
        this.execException("x", "file:A", RelativeURIException.class);
    }

    public void testURI_file_5() {
        this.execTest("#x", "file:A", "file:A#x");
    }

    public void testURI_file_6() {
        this.execTest("foo", "file:///xyz abc/", "file:///xyz abc/foo");
    }

    public void testURI_file_7() {
        this.execTestMatch("file:foo", "file:xyz", "^file:///.*foo$");
    }

    public void testURI_file_8() {
        this.execTestMatch("file:foo", "file:a b", "^file:///.*foo$");
    }

    public void testFileURI_rel_1() {
        this.execTestFileRelURI("file:foo");
    }

    public void testFileURI_rel_2() {
        this.execTestFileRelURI("file:foo/bar");
    }

    public void testFileURI_rel_3() {
        this.execTestFileRelURI("file:foo/");
    }

    public void testFileURI_rel_4() {
        this.execTestFileRelURI("file:foo/bar/");
    }

    public void testURI_global_null_1() {
        String tmp = RelURI.getBaseURI();
        try {
            RelURI.setBaseURI("rel");
            this.execTestGlobal("x", "rel1/rel2");
            TestURI.fail((String)"Didn't get RelativeURIException");
        }
        catch (JenaURIException jenaURIException) {
            // empty catch block
        }
        RelURI.setBaseURI(tmp);
    }

    public void testURI_global_null_2() {
        String tmp = RelURI.getBaseURI();
        RelURI.setBaseURI("file:///A/B/");
        this.execTestGlobal("x", "file:///A/B/x");
        RelURI.setBaseURI(tmp);
    }

    private void execTest(String u, String base, String result) {
        String res = RelURI.resolve(u, base);
        if (result == null) {
            TestURI.assertNull((String)("(" + u + "," + base + ") => <null> :: Got: " + res), (Object)res);
            return;
        }
        TestURI.assertNotNull((String)("(" + u + "," + base + ") => " + result + " :: Got: <null>"), (Object)res);
        TestURI.assertTrue((String)("(" + u + "," + base + ") => " + result + " :: Got: " + res), (boolean)res.equals(result));
    }

    private void execTestMatch(String u, String base, String resultPattern) {
        String res = RelURI.resolve(u, base);
        if (resultPattern == null) {
            TestURI.assertNull((String)("(" + u + "," + base + ") => <null> :: Got: " + res), (Object)res);
            return;
        }
        boolean r = res.matches(resultPattern);
        TestURI.assertTrue((String)("Does not match: " + res + " -- " + resultPattern), (boolean)r);
    }

    private void execFileTest(String fn1, String fn2) {
        String s = RelURI.resolveFileURL(fn1);
        TestURI.assertEquals((String)s, (String)fn2);
    }

    private void execTestFileRelURI(String fn) {
        String relName = fn.substring("file:".length());
        String s = RelURI.resolveFileURL(fn);
        TestURI.assertTrue((String)("Lost relative name: (" + fn + "=>" + s + ")"), (boolean)s.endsWith(relName));
        TestURI.assertTrue((String)("Not absolute: (" + fn + "=>" + s + ")"), (boolean)s.startsWith("file:///"));
    }

    private void execException(String u, String base, Class ex) {
        String s = ex.getName();
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        try {
            String res = RelURI.resolve(u, base);
            if (res == null) {
                TestURI.fail((String)("(" + u + "," + base + ") => <null> :: Expected exception: " + s));
            } else {
                TestURI.fail((String)("(" + u + "," + base + ") => " + res + " :: Expected exception: " + s));
            }
        }
        catch (Exception ex2) {
            TestURI.assertEquals((Object)ex, ex2.getClass());
        }
    }

    private void execTestGlobal(String u, String result) {
        String res = RelURI.resolve(u);
        if (result == null) {
            TestURI.assertNull((String)("(" + u + ") => <null> :: Got: " + res), (Object)res);
            return;
        }
        TestURI.assertNotNull((String)("(" + u + ") => " + result + " :: Got: <null>"), (Object)res);
        TestURI.assertTrue((String)("(" + u + ") => " + result + " :: Got: " + res), (boolean)res.equals(result));
    }
}

