/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.act.sodl.model.EngineTarget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class Console {
    private static int commandPort;
    private static int eventPort;
    private static boolean debugging;
    String[] arg = new String[]{"D:\\eclipse\\workspace\\XService BNF Runtime\\org.act.sodl.debug.test\\data\\HelloServiceSOAPRequest.xml", "D:\\eclipse\\workspace\\XService BNF Runtime\\org.act.sodl.debug.test\\data\\TestNamespace.xml", "D:\\eclipse\\workspace\\XService BNF Runtime\\org.act.sodl.debug.test\\data\\TestNamespace.txt"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findFreePort() {
        ServerSocket socket;
        block10: {
            int n;
            socket = null;
            try {
                socket = new ServerSocket(0);
                n = socket.getLocalPort();
                if (socket == null) return n;
            }
            catch (IOException iOException) {
                try {
                    break block10;
                }
                catch (Throwable throwable) {
                    if (socket == null) throw throwable;
                    try {
                        socket.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
            }
            try {
                socket.close();
                return n;
            }
            catch (IOException iOException) {}
            return n;
        }
        if (socket == null) return -1;
        try {
            socket.close();
            return -1;
        }
        catch (IOException iOException) {}
        return -1;
    }

    public static void main(String[] args) {
        commandPort = Console.findFreePort();
        eventPort = Console.findFreePort();
        System.out.println("Start listening on commandPort: " + commandPort + " and eventPort: " + eventPort);
        InputStreamReader ir = new InputStreamReader(System.in);
        BufferedReader in = new BufferedReader(ir);
        System.out.println("Whether the engine is in debug mode:");
        try {
            String s = in.readLine();
            debugging = s.equals("true");
            Console con = new Console();
            Server server = con.new Server();
            server.start();
            Client client = con.new Client();
            client.start();
            while (s != null) {
                s = in.readLine();
                if (s.equals("")) break;
                client.sendRequest(s);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Server
    extends Thread {
        Server() {
        }

        public void run() {
            EngineTarget eEngineTarget = new EngineTarget(Console.this.arg[0], Console.this.arg[1], Console.this.arg[2], null, commandPort, eventPort, debugging);
            eEngineTarget.scheduleCommandDispatchJob();
        }
    }

    class Client
    extends Thread {
        private Socket fRequestSocket;
        private PrintWriter fRequestWriter;
        private BufferedReader fRequestReader;
        private Socket fEventSocket;
        private BufferedReader fEventReader;
        private EventDispatchJob fEventDispatch;

        public Client() {
            try {
                this.fRequestSocket = new Socket("localhost", commandPort);
                this.fRequestWriter = new PrintWriter(this.fRequestSocket.getOutputStream());
                this.fRequestReader = new BufferedReader(new InputStreamReader(this.fRequestSocket.getInputStream()));
                this.fEventSocket = new Socket("localhost", eventPort);
                this.fEventReader = new BufferedReader(new InputStreamReader(this.fEventSocket.getInputStream()));
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("UnknownHostException");
            }
            catch (IOException iOException) {
                System.out.println("IOException");
            }
            this.fEventDispatch = new EventDispatchJob();
            this.fEventDispatch.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendRequest(String request) throws Exception {
            Socket socket = this.fRequestSocket;
            synchronized (socket) {
                System.out.println("CLIENT: send a command to the engine: " + request);
                this.fRequestWriter.println(request);
                this.fRequestWriter.flush();
            }
        }

        class EventDispatchJob
        extends Job {
            public EventDispatchJob() {
                super("CLIENT Event Dispatch");
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                System.out.println("CLIENT: EventDispatchJob is running!");
                String event = "";
                while (event != null) {
                    try {
                        if (!Client.this.fEventReader.ready()) {
                            Thread.sleep(1L);
                        } else {
                            String e = Client.this.fEventReader.readLine();
                            System.out.println(e);
                        }
                        event = Client.this.fRequestReader.readLine();
                        if (event.equals("")) continue;
                        System.out.println("CLIENT: Got a response from the engine: " + event);
                        if (event.equals("terminated")) break;
                        event = "";
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("CLIENT: EventDispatchJob has stopped!");
                return Status.OK_STATUS;
            }
        }
    }
}

