/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.act.metaset.Metaset;
import org.act.metaset.QName;
import org.act.sodl.engine.CodeFormatter;
import org.act.sodl.exception.HandlerProcessException;
import org.act.sodl.exception.SODLException;
import org.act.sodl.expression.OutputStreamDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextManager {
    private ArrayList<Map<QName, Object>> array = new ArrayList();
    private ContextManager parent = null;
    private ContextManager child = null;
    private String inElementName = null;
    private String outElementName = null;

    public void register(Map<QName, Object> context) {
        this.array.add(context);
    }

    public void register(QName key, Metaset value) {
        HashMap<QName, Metaset> context = new HashMap<QName, Metaset>();
        context.put(key, value);
        this.array.add(context);
    }

    public Map<QName, Object> top() {
        if (this.array.size() > 0) {
            return this.array.get(this.array.size() - 1);
        }
        return null;
    }

    public Object get(QName key) {
        int i = this.array.size() - 1;
        while (i >= 0) {
            Map<QName, Object> c = this.array.get(i);
            Object obj = c.get(key);
            if (obj != null) {
                return obj;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public void unregister() throws HandlerProcessException {
        if (this.array.size() > 0) {
            Map<QName, Object> toBeRemoved = this.array.get(this.array.size() - 1);
            for (Map.Entry<QName, Object> entry : toBeRemoved.entrySet()) {
                if (!(entry.getValue() instanceof OutputStreamDescriptor)) continue;
                try {
                    OutputStream output = ((OutputStreamDescriptor)entry.getValue()).getOutputStream();
                    File tmp = File.createTempFile("\\temp", ".tmp");
                    FileInputStream input = new FileInputStream(tmp);
                    CodeFormatter.format(input, output);
                    input.close();
                    output.flush();
                    output.close();
                }
                catch (IOException iOException) {
                    throw new HandlerProcessException("####", "File IO Error!");
                }
            }
            this.array.remove(toBeRemoved);
        }
    }

    public ContextManager getChild() {
        return this.child;
    }

    public void setChild(ContextManager child) {
        this.child = child;
    }

    public String getInElementName() {
        return this.inElementName;
    }

    public void setInElementName(String inElementName) {
        this.inElementName = inElementName;
    }

    public ContextManager getParent() {
        return this.parent;
    }

    public void setParent(ContextManager parent) {
        this.parent = parent;
    }

    public String getOutElementName() {
        return this.outElementName;
    }

    public void setOutElementName(String outElementName) {
        this.outElementName = outElementName;
    }

    public String getContextdata() {
        Map<QName, Object> currentMap = null;
        String key = null;
        StringBuffer content = new StringBuffer();
        int i = 0;
        while (i < this.array.size()) {
            currentMap = this.array.get(i);
            for (Map.Entry<QName, Object> entry : currentMap.entrySet()) {
                key = entry.getKey().toString();
                if (entry.getValue() instanceof Metaset) {
                    content.append(String.valueOf(key) + "|" + ((Metaset)entry.getValue()).toXML() + "|");
                    continue;
                }
                if (entry.getValue() instanceof String) {
                    content.append(String.valueOf(key) + "|" + (String)entry.getValue() + "|");
                    continue;
                }
                if (entry.getValue() instanceof SODLException) {
                    content.append(String.valueOf(key) + "|" + ((SODLException)entry.getValue()).toString() + "|");
                    continue;
                }
                if (!(entry.getValue() instanceof OutputStreamDescriptor)) continue;
                OutputStreamDescriptor value = (OutputStreamDescriptor)entry.getValue();
                content.append(String.valueOf(key) + "|" + value.getOutputStream().getClass().getSimpleName() + ": (" + value.getDescriptor() + ")" + "|");
            }
            ++i;
        }
        return content.toString();
    }
}

