/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.act.metaset.Metaset;
import org.act.metaset.MetasetParser;
import org.act.metaset.QName;
import org.act.sodl.engine.ContextManager;
import org.act.sodl.engine.SODLContext;
import org.act.sodl.exception.EngineExecutionException;
import org.act.sodl.handler.Handler;
import org.act.sodl.handler.HandlerRegistry;
import org.act.sodl.model.IEngineThread;
import org.act.sodl.model.NullEngineThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SODLEngine {
    private SODLContext context = null;
    private ContextManager cm = null;
    private Metaset sodlSS = null;

    public void execute(String wsdl, String sodl) throws EngineExecutionException {
        if (wsdl == null || sodl == null) {
            throw new EngineExecutionException("", "Input parameters should not be null!");
        }
        try {
            MetasetParser parser = new MetasetParser();
            Metaset wsdlSS = parser.parse((InputStream)new FileInputStream(wsdl));
            this.sodlSS = parser.parse((InputStream)new FileInputStream(sodl));
            if (!(String.valueOf(this.sodlSS.getNamespace().equals("") ? "" : String.valueOf(this.sodlSS.getNamespace()) + ":") + this.sodlSS.getName()).equals("sodl:description#0".substring(0, "sodl:description#0".indexOf("#")))) {
                throw new EngineExecutionException(String.valueOf(this.sodlSS.getNamespace().equals("") ? "" : String.valueOf(this.sodlSS.getNamespace()) + ":") + this.sodlSS.getName() + "#0", "Incorrect syntax in root element!");
            }
            File tmp = File.createTempFile(new File(sodl).getName(), ".tmp");
            Metaset c = new Metaset("", "");
            c.add(wsdlSS);
            HashMap<QName, Object> map = new HashMap<QName, Object>();
            map.put(new QName("_SODLPath"), wsdl);
            map.put(new QName("S"), c);
            this.execute(this.sodlSS, map, new FileOutputStream(tmp), new NullEngineThread());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EngineExecutionException("", "File Not Found Error.");
        }
        catch (IOException iOException) {
            throw new EngineExecutionException(String.valueOf(this.sodlSS.getNamespace().equals("") ? "" : String.valueOf(this.sodlSS.getNamespace()) + ":") + this.sodlSS.getName() + "#0", "File IO Error.");
        }
    }

    public void execute(Metaset sodl, Map<QName, Object> parameters, OutputStream os, IEngineThread eEngineThread) throws EngineExecutionException {
        SODLContext context = new SODLContext();
        context.setEngineThread(eEngineThread);
        context.setHandlerRegistry(eEngineThread.isDebugging() ? HandlerRegistry.newDebugHandlerRegistry() : HandlerRegistry.newHandlerRegistry());
        context.setOutput(os);
        context.setSourceSODL(sodl);
        context.setParameters(parameters);
        context.setExecueting(true);
        this.execute(context);
    }

    public void execute(SODLContext context) throws EngineExecutionException {
        this.context = context;
        this.cm = new ContextManager();
        this.cm.register(context.getParameters());
        this.cm.setInElementName("sodl:description#0");
        Metaset sodl = context.getSourceSODL();
        Handler handler = context.getHandlerRegistry().getHandler(String.valueOf(sodl.getNamespace().equals("") ? "" : String.valueOf(sodl.getNamespace()) + ":") + sodl.getName());
        handler.process(context, context.getSourceSODL(), this.cm);
        this.cm.unregister();
        this.realeaseContextResources();
    }

    public SODLContext getSODLContext() {
        return this.context;
    }

    private void realeaseContextResources() throws EngineExecutionException {
        while (this.cm != null) {
            this.cm.unregister();
            this.cm = this.cm.getChild();
        }
    }

    public void startExecution() {
        if (this.context != null) {
            this.context.setExecueting(true);
        }
    }

    public boolean isExecuting() {
        if (this.context != null) {
            return this.context.isExecueting();
        }
        return false;
    }

    public void stopExecution() {
        if (this.context != null) {
            this.context.setExecueting(false);
        }
    }
}

