/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.expression;

import java.util.HashMap;
import java.util.Map;
import org.act.sodl.exception.ExpressionParseException;
import org.act.sodl.expression.CharReaderIterator;
import org.act.sodl.expression.CompositeExpression;
import org.act.sodl.expression.DeriverExpression;
import org.act.sodl.expression.EmptyExpression;
import org.act.sodl.expression.FaultExpression;
import org.act.sodl.expression.FilterExpression;
import org.act.sodl.expression.GetElementValueExpression;
import org.act.sodl.expression.HeadExpression;
import org.act.sodl.expression.IExpression;
import org.act.sodl.expression.InputExpression;
import org.act.sodl.expression.InvokeExpression;
import org.act.sodl.expression.OutputExpression;
import org.act.sodl.expression.PopExpression;
import org.act.sodl.expression.PushExpression;
import org.act.sodl.expression.RemoveExpression;
import org.act.sodl.expression.SelectorExpression;
import org.act.sodl.expression.SetElementValueExpression;
import org.act.sodl.expression.StringExpression;
import org.act.sodl.expression.StringSeparateExpression;
import org.act.sodl.expression.TailExpression;
import org.act.sodl.expression.ValueExpression;

public final class ExpressionFactory {
    private static Map<Character, Class> char2classMap = new HashMap<Character, Class>();
    private static Map<Class, Character> class2charMap = new HashMap<Class, Character>();
    private static boolean comma = false;
    private static boolean quoted = false;

    static {
        ExpressionFactory.register('\u03bb', FilterExpression.class);
        ExpressionFactory.register('\u03c3', SelectorExpression.class);
        ExpressionFactory.register('\u03b4', HeadExpression.class);
        ExpressionFactory.register('\u03c0', TailExpression.class);
        ExpressionFactory.register('\u03b1', PushExpression.class);
        ExpressionFactory.register('\u03b2', PopExpression.class);
        ExpressionFactory.register('\u03c6', EmptyExpression.class);
        ExpressionFactory.register('\u03b5', GetElementValueExpression.class);
        ExpressionFactory.register('\u03bc', SetElementValueExpression.class);
        ExpressionFactory.register('\u03c8', DeriverExpression.class);
        ExpressionFactory.register('\u03b8', RemoveExpression.class);
        ExpressionFactory.register('\u03c1', InvokeExpression.class);
        ExpressionFactory.register('\u03b9', InputExpression.class);
        ExpressionFactory.register('\u03bf', OutputExpression.class);
        ExpressionFactory.register('\u03b6', FaultExpression.class);
        ExpressionFactory.register('\u03bd', ValueExpression.class);
        ExpressionFactory.register('\u03c9', StringSeparateExpression.class);
    }

    private ExpressionFactory() {
    }

    public static void register(char ch, Class c) {
        class2charMap.put(c, new Character(ch));
        char2classMap.put(new Character(ch), c);
    }

    public static void unregister(char ch) {
        Class value = char2classMap.get(new Character(ch));
        if (value != null) {
            char2classMap.remove(new Character(ch));
            class2charMap.remove(value);
        }
    }

    public static void unregister(Class c) {
        Character value = class2charMap.get(c);
        if (value != null) {
            class2charMap.remove(c);
            char2classMap.remove(value);
        }
    }

    public static CompositeExpression getExpression(char ch) throws ExpressionParseException {
        Class c = char2classMap.get(new Character(ch));
        if (c != null) {
            try {
                return (CompositeExpression)c.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExpressionParseException("Illegal Access Exception occurred!");
            }
            catch (InstantiationException instantiationException) {
                throw new ExpressionParseException("Instantiation Exception occurred!");
            }
        }
        return null;
    }

    public static char getChar(Class c) {
        Character ch = class2charMap.get(c);
        if (ch != null) {
            return ch.charValue();
        }
        return '\u0000';
    }

    public static IExpression create(String expr) throws ExpressionParseException {
        CharReaderIterator iter = new CharReaderIterator(expr);
        quoted = false;
        IExpression result = ExpressionFactory.create(iter);
        iter.skipWhiteSpace();
        if (iter.current() == '\u0000') {
            return result;
        }
        throw new ExpressionParseException("Extra character at the end of Expression: " + iter);
    }

    private static IExpression create(CharReaderIterator iter) throws ExpressionParseException {
        if (iter.current() != '\u0000') {
            if (comma && (iter.current() == '\"' || iter.current() == '\'')) {
                comma = false;
                quoted = true;
                char quotChar = iter.current();
                iter.next();
                IExpression result = ExpressionFactory.create(iter);
                if (iter.current() == quotChar) {
                    quoted = false;
                    iter.next();
                    iter.skipWhiteSpace();
                    return result;
                }
                throw new ExpressionParseException("Expression use " + quotChar + " to enclose the string, must end with " + quotChar + ".");
            }
            if (ExpressionFactory.isValidCharacter(iter.current())) {
                comma = false;
                StringBuffer sb = new StringBuffer();
                do {
                    sb.append(iter.current());
                    iter.next();
                } while (ExpressionFactory.reachEndCharacter(iter.current()));
                iter.skipWhiteSpace();
                return new StringExpression(sb.toString());
            }
            CompositeExpression result = ExpressionFactory.getExpression(iter.current());
            if (result != null) {
                quoted = false;
                char exprIdent = iter.current();
                iter.next();
                iter.skipWhiteSpace();
                if (iter.current() == '(') {
                    iter.next();
                    iter.skipWhiteSpace();
                    if (iter.current() != ')') {
                        IExpression param = ExpressionFactory.create(iter);
                        result.add(param);
                        while (iter.current() == ',') {
                            iter.next();
                            iter.skipWhiteSpace();
                            comma = true;
                            param = ExpressionFactory.create(iter);
                            result.add(param);
                        }
                    } else {
                        result.add(new EmptyExpression());
                    }
                    if (iter.current() == ')') {
                        iter.next();
                        iter.skipWhiteSpace();
                        return result;
                    }
                    throw new ExpressionParseException("\"" + iter + "\" must end with \")\".");
                }
                if (result instanceof EmptyExpression) {
                    return result;
                }
                throw new ExpressionParseException("Expression must provide '(' after " + exprIdent + ".");
            }
            throw new ExpressionParseException("Expression Parser can not recognise the char '" + iter.current() + "'.");
        }
        return null;
    }

    private static boolean reachEndCharacter(char c) {
        return c != ',' && c != ')' && c != '\u0000' && c != '\"';
    }

    private static boolean isValidCharacter(char ch) {
        return ch != '\'' && ch != '\"' && ch >= ' ' && ch <= '\u0080' && (quoted || ch != '(' && ch != ')' && ch != ',');
    }
}

