/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.expression;

import org.act.metaset.QName;
import org.act.sodl.engine.ContextManager;
import org.act.sodl.exception.ExpressionParseException;
import org.act.sodl.expression.CompositeExpression;
import org.act.sodl.expression.IExpression;

public class StringSeparateExpression
extends CompositeExpression {
    public Object evaluate(ContextManager cm) throws ExpressionParseException {
        if (this.parameter.size() == 2) {
            Object value = ((IExpression)this.parameter.get(0)).evaluate(cm);
            Object arg1 = ((IExpression)this.parameter.get(1)).evaluate(cm);
            if (value != null && value instanceof String) {
                String str = (String)value;
                Object target = cm.get(new QName("", (String)value));
                if (target != null && target instanceof String) {
                    str = (String)target;
                }
                if (!str.contains(":")) {
                    throw new ExpressionParseException("The first parameter should contain a \":\" character!");
                }
                String pattern = ((String)arg1).trim();
                if (!pattern.equalsIgnoreCase("true") && !pattern.equalsIgnoreCase("false")) {
                    throw new ExpressionParseException("The second parameter in StringSeparating expression should either be \"true\" or \"false\", but \"" + arg1 + " encountered!");
                }
                String[] tokens = str.split(":");
                if (tokens.length != 2) {
                    throw new ExpressionParseException("The first parameter should contain one and only one \":\"!");
                }
                if (pattern.equalsIgnoreCase("true")) {
                    return tokens[0];
                }
                return tokens[1];
            }
            throw new ExpressionParseException("Wrong parameters in " + this.getClass().getSimpleName() + "!");
        }
        throw new ExpressionParseException("Incorrect number of parameters contained in " + this.getClass().getSimpleName() + "!");
    }
}

