/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.handler;

import org.act.metaset.Metaset;
import org.act.sodl.engine.ContextManager;
import org.act.sodl.engine.SODLContext;
import org.act.sodl.exception.HandlerProcessException;
import org.act.sodl.exception.SODLException;
import org.act.sodl.handler.Handler;
import org.act.sodl.model.IEngineThread;

public class DebugHandler
extends Handler {
    private Handler handler = null;

    public DebugHandler(Handler handler) {
        this.handler = handler;
    }

    protected void handle(SODLContext context, Metaset element, ContextManager cm) throws HandlerProcessException, SODLException {
        this.enableDebugControl(element, cm, context.getEngineThread());
        this.handler.handle(context, element, cm);
    }

    private void enableDebugControl(Metaset element, ContextManager cm, IEngineThread eEngineThread) {
        if (eEngineThread.isDebugging()) {
            if (eEngineThread.isStepping()) {
                String path = this.getAbsolutePath(element);
                eEngineThread.suspend("step " + path, element, cm);
            } else if (this.isBreakpointHit(element, eEngineThread)) {
                String path = this.getAbsolutePath(element);
                eEngineThread.suspend("breakpoint " + path, element, cm);
            }
        }
    }
}

