/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.act.metaset.Attribute;
import org.act.metaset.Metaset;
import org.act.metaset.QName;
import org.act.sodl.engine.ContextManager;
import org.act.sodl.engine.SODLContext;
import org.act.sodl.exception.ExpressionParseException;
import org.act.sodl.exception.HandlerProcessException;
import org.act.sodl.exception.SODLException;
import org.act.sodl.expression.ExpressionFactory;
import org.act.sodl.expression.IExpression;
import org.act.sodl.model.IEngineThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Handler {
    static final int space = 32;
    private static String[] strAttrIgnored = new String[]{"sodl:choice", "sodl:case", "sodl:condition", "sodl:target", "sodl:input", "sodl:exception"};
    private static ArrayList attrIgnored = new ArrayList();
    private static String[] strCMIgnored = new String[]{"sodl:func"};
    protected static ArrayList cmIgnored = new ArrayList();

    static {
        int i = 0;
        while (i < strAttrIgnored.length) {
            attrIgnored.add(strAttrIgnored[i]);
            ++i;
        }
        i = 0;
        while (i < strCMIgnored.length) {
            cmIgnored.add(strCMIgnored[i]);
            ++i;
        }
    }

    public void process(SODLContext context, Metaset element, ContextManager cm) throws HandlerProcessException, SODLException {
        if (context.isExecueting() && !cmIgnored.contains((String.valueOf(element.getNamespace().equals("") ? "" : String.valueOf(element.getNamespace()) + ":") + element.getName()).trim())) {
            Map<QName, Object> map = this.getContext(element, cm);
            cm.register(map);
        }
        this.handle(context, element, cm);
        if (context.isExecueting() && !cmIgnored.contains((String.valueOf(element.getNamespace().equals("") ? "" : String.valueOf(element.getNamespace()) + ":") + element.getName()).trim())) {
            cm.unregister();
        }
    }

    protected abstract void handle(SODLContext var1, Metaset var2, ContextManager var3) throws HandlerProcessException, SODLException;

    protected Map<QName, Object> getContext(Metaset element, ContextManager cm) throws HandlerProcessException {
        HashMap<QName, Object> map = new HashMap<QName, Object>();
        int i = 0;
        while (i < element.getAttributes().size()) {
            Attribute attr = (Attribute)element.getAttributes().get(i);
            if (!attrIgnored.contains((String.valueOf(attr.getNameSpace().equals("") ? "" : String.valueOf(attr.getNameSpace()) + ":") + attr.getName()).trim())) {
                Object obj = cm.get(new QName(attr.getValue()));
                if (obj != null) {
                    map.put(new QName(attr.getNameSpace(), attr.getName()), obj);
                } else {
                    IExpression expr = null;
                    try {
                        expr = ExpressionFactory.create(attr.getValue());
                        obj = expr.evaluate(cm);
                    }
                    catch (ExpressionParseException e) {
                        String location = e.getExceptionLocation();
                        throw new ExpressionParseException(location == null ? this.getAbsolutePath(element) : location, e.getExceptionDescription());
                    }
                    if (obj == null) {
                        throw new HandlerProcessException(this.getAbsolutePath(element), "Null value encountered in attribute " + (attr.getNameSpace().equals("") ? "" : String.valueOf(attr.getNameSpace()) + ":") + attr.getName());
                    }
                    map.put(new QName(attr.getNameSpace(), attr.getName()), obj);
                }
            }
            ++i;
        }
        return map;
    }

    public static ArrayList getAttrIgnored() {
        return attrIgnored;
    }

    public String getAbsolutePath(Metaset element) {
        int index = 0;
        StringBuffer path = new StringBuffer();
        Metaset father = element.getFather();
        if (father == null) {
            path = path.insert(0, String.valueOf(element.getNamespace().equals("") ? "" : String.valueOf(element.getNamespace()) + ":") + element.getName() + "#" + index);
            return new String(path);
        }
        path = path.insert(0, String.valueOf(element.getNamespace().equals("") ? "" : String.valueOf(element.getNamespace()) + ":") + element.getName() + "#" + father.getServicesSetPosition(element));
        element = father;
        father = father.getFather();
        while (father != null) {
            index = father.getServicesSetPosition(element);
            path = path.insert(0, String.valueOf(element.getNamespace().equals("") ? "" : String.valueOf(element.getNamespace()) + ":") + element.getName() + "#" + index + "\\");
            element = father;
            father = father.getFather();
        }
        path = path.insert(0, String.valueOf(element.getNamespace().equals("") ? "" : String.valueOf(element.getNamespace()) + ":") + element.getName() + "#0" + "\\");
        return new String(path);
    }

    public boolean isBreakpointHit(Metaset element, IEngineThread eEngineThread) {
        return eEngineThread.isBreakpointHit(this.getAbsolutePath(element));
    }
}

