/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.handler;

import java.util.HashMap;
import java.util.Map;
import org.act.sodl.handler.CatchHandler;
import org.act.sodl.handler.DebugHandler;
import org.act.sodl.handler.DefaultHandler;
import org.act.sodl.handler.DescriptionHandler;
import org.act.sodl.handler.FuncHandler;
import org.act.sodl.handler.Handler;
import org.act.sodl.handler.IfHandler;
import org.act.sodl.handler.InvokerHanlder;
import org.act.sodl.handler.MainHandler;
import org.act.sodl.handler.OutputHandler;
import org.act.sodl.handler.SwitchHandler;
import org.act.sodl.handler.ThrowHandler;
import org.act.sodl.handler.TryHandler;
import org.act.sodl.handler.WhileHandler;

public class HandlerRegistry {
    public static final String HANDLER_SWITCH = "sodl:switch";
    public static final String HANDLER_WHILE = "sodl:while";
    public static final String HANDLER_IF = "sodl:if";
    public static final String HANDLER_FUNC = "sodl:func";
    public static final String HANDLER_DEFINITION = "sodl:description";
    public static final String HANDLER_MAIN = "sodl:main";
    public static final String HANDLER_OUTPUT = "sodl:output";
    public static final String HANDLER_INVOKE = "sodl:invoke";
    public static final String HANDLER_TRY = "sodl:try";
    public static final String HANDLER_THROW = "sodl:throw";
    public static final String HANDLER_CATCH = "sodl:catch";
    private Map<String, Handler> map = new HashMap<String, Handler>();
    private Handler defaultHandler = null;

    public void registerDefaultHandler(Handler handler) {
        this.defaultHandler = handler;
    }

    public void register(String name, Handler handler) {
        this.map.put(name, handler);
    }

    public void unregister(String name) {
        this.map.remove(name);
    }

    public Handler getHandler(String name) {
        if (name == null) {
            return this.defaultHandler;
        }
        Handler result = this.map.get(name);
        if (result != null) {
            return result;
        }
        return this.defaultHandler;
    }

    public static HandlerRegistry newHandlerRegistry() {
        HandlerRegistry regitstry = new HandlerRegistry();
        regitstry.initHandlerRegistry();
        return regitstry;
    }

    private void initHandlerRegistry() {
        this.registerDefaultHandler(new DefaultHandler());
        this.register(HANDLER_SWITCH, new SwitchHandler());
        this.register(HANDLER_WHILE, new WhileHandler());
        this.register(HANDLER_IF, new IfHandler());
        this.register(HANDLER_FUNC, new FuncHandler());
        this.register(HANDLER_DEFINITION, new DescriptionHandler());
        this.register(HANDLER_MAIN, new MainHandler());
        this.register(HANDLER_OUTPUT, new OutputHandler());
        this.register(HANDLER_INVOKE, new InvokerHanlder());
        this.register(HANDLER_TRY, new TryHandler());
        this.register(HANDLER_THROW, new ThrowHandler());
        this.register(HANDLER_CATCH, new CatchHandler());
    }

    public static HandlerRegistry newDebugHandlerRegistry() {
        HandlerRegistry regitstry = new HandlerRegistry();
        regitstry.initDebugHandlerRegistry();
        return regitstry;
    }

    private void initDebugHandlerRegistry() {
        this.registerDefaultHandler(new DebugHandler(new DefaultHandler()));
        this.register(HANDLER_SWITCH, new DebugHandler(new SwitchHandler()));
        this.register(HANDLER_WHILE, new DebugHandler(new WhileHandler()));
        this.register(HANDLER_IF, new DebugHandler(new IfHandler()));
        this.register(HANDLER_FUNC, new DebugHandler(new FuncHandler()));
        this.register(HANDLER_DEFINITION, new DebugHandler(new DescriptionHandler()));
        this.register(HANDLER_MAIN, new DebugHandler(new MainHandler()));
        this.register(HANDLER_OUTPUT, new DebugHandler(new OutputHandler()));
        this.register(HANDLER_INVOKE, new DebugHandler(new InvokerHanlder()));
        this.register(HANDLER_TRY, new DebugHandler(new TryHandler()));
        this.register(HANDLER_THROW, new DebugHandler(new ThrowHandler()));
        this.register(HANDLER_CATCH, new DebugHandler(new CatchHandler()));
    }
}

