/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.handler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.act.metaset.Metaset;
import org.act.metaset.QName;
import org.act.sodl.engine.ContextManager;
import org.act.sodl.engine.SODLContext;
import org.act.sodl.exception.ExpressionParseException;
import org.act.sodl.exception.HandlerProcessException;
import org.act.sodl.exception.SODLException;
import org.act.sodl.expression.ExpressionFactory;
import org.act.sodl.expression.IExpression;
import org.act.sodl.expression.OutputStreamDescriptor;
import org.act.sodl.handler.Handler;

public class OutputHandler
extends Handler {
    protected void handle(SODLContext context, Metaset element, ContextManager cm) throws HandlerProcessException, SODLException {
        block21: {
            OutputStream output = null;
            String attrTarget = element.selector(".@sodl:target");
            if (attrTarget == null) {
                throw new HandlerProcessException(this.getAbsolutePath(element), "Attribute \"sodl:target\" was not found in sodl:output element!");
            }
            QName temp = new QName(attrTarget);
            Object targetOutputStream = cm.get(temp);
            try {
                if (targetOutputStream != null && targetOutputStream instanceof OutputStreamDescriptor) {
                    output = ((OutputStreamDescriptor)targetOutputStream).getOutputStream();
                    if (element.getChilds().size() != 0) {
                        int i = 0;
                        while (i < element.getChilds().size()) {
                            if (((Metaset)element.getChilds().get(i)).getName().equals("func")) {
                                String value = ((Metaset)element.getChilds().get(i)).getValue().replace("\n", "").replace("\r", "").replace("\t", "").trim();
                                IExpression expr = ExpressionFactory.create(value);
                                Object obj = expr.evaluate(cm);
                                if (obj != null) {
                                    if (obj instanceof Metaset) {
                                        output.write(((Metaset)obj).toXML().getBytes());
                                        output.write(32);
                                    } else {
                                        String str = obj.toString();
                                        output.write(str.getBytes());
                                        output.write(32);
                                    }
                                }
                            } else {
                                Metaset current = (Metaset)element.getChilds().get(i);
                                Handler handler = context.getHandlerRegistry().getHandler((String.valueOf(current.getNamespace().equals("") ? "" : String.valueOf(current.getNamespace()) + ":") + current.getName()).trim());
                                handler.process(context, (Metaset)element.getChilds().get(i), cm);
                            }
                            ++i;
                        }
                        return;
                    }
                    String value = element.getValue().replace("\n", "").replace("\r", "").replace("\t", "").trim();
                    QName key = new QName(value);
                    Object obj = cm.get(key);
                    if (obj != null) {
                        if (obj instanceof Metaset) {
                            output.write(((Metaset)obj).toXML().getBytes());
                            output.write(32);
                        } else {
                            String str = obj.toString();
                            output.write(str.getBytes());
                            output.write(32);
                        }
                    } else {
                        StringBuffer sb = new StringBuffer(value);
                        int i = 0;
                        while (i < value.length()) {
                            if (sb.charAt(i) == '\u03b1') {
                                sb.setCharAt(i, '<');
                            } else if (sb.charAt(i) == '\u03b2') {
                                sb.setCharAt(i, '>');
                                sb.insert(i + 1, '\r');
                            }
                            ++i;
                        }
                        output.write(sb.toString().getBytes());
                        output.write(32);
                    }
                    break block21;
                }
                throw new HandlerProcessException(this.getAbsolutePath(element), "Output target inexistent or unavailable!");
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new HandlerProcessException(this.getAbsolutePath(element), "File Not found!");
            }
            catch (IOException iOException) {
                throw new HandlerProcessException(this.getAbsolutePath(element), "File IO Error!");
            }
            catch (ExpressionParseException e) {
                String location = e.getExceptionLocation();
                throw new ExpressionParseException(location == null ? this.getAbsolutePath(element) : location, e.getExceptionDescription());
            }
        }
    }
}

