/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.handler;

import java.util.HashMap;
import java.util.Map;
import org.act.metaset.Attribute;
import org.act.metaset.Metaset;
import org.act.metaset.QName;
import org.act.sodl.engine.ContextManager;
import org.act.sodl.engine.SODLContext;
import org.act.sodl.exception.HandlerProcessException;
import org.act.sodl.exception.SODLException;
import org.act.sodl.handler.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryHandler
extends Handler {
    private Map<QName, Metaset> catchElements = new HashMap<QName, Metaset>();

    @Override
    protected void handle(SODLContext context, Metaset element, ContextManager cm) throws HandlerProcessException, SODLException {
        if (element.getChilds().size() > 0) {
            this.catchElements = this.initializeCatch(element);
            int i = 0;
            while (i < element.getChilds().size()) {
                Metaset current = (Metaset)element.getChilds().get(i);
                String childName = (String.valueOf(current.getNamespace().equals("") ? "" : String.valueOf(current.getNamespace()) + ":") + current.getName()).trim();
                if (!childName.equals("sodl:catch")) {
                    try {
                        Handler handler = context.getHandlerRegistry().getHandler(childName);
                        handler.process(context, (Metaset)element.getChilds().get(i), cm);
                    }
                    catch (SODLException exception) {
                        cm.setChild(null);
                        cm.setOutElementName(null);
                        this.handleExeptions(exception, context, cm);
                        break;
                    }
                }
                ++i;
            }
        } else {
            throw new HandlerProcessException(this.getAbsolutePath(element), "\"sodl:catch\" clause not found!");
        }
    }

    private void handleExeptions(SODLException exception, SODLContext context, ContextManager cm) throws HandlerProcessException, SODLException {
        QName exceptionName = new QName(exception.getExceptionName());
        Metaset catchClause = this.catchElements.get(exceptionName);
        if (catchClause != null) {
            if (catchClause.getChilds().size() > 0) {
                HashMap map = (HashMap)cm.top();
                map.put(exceptionName, exception.getExceptionTarget());
                Handler handler = context.getHandlerRegistry().getHandler("sodl:catch");
                handler.process(context, catchClause, cm);
                map.remove(exceptionName);
            }
        } else {
            throw exception;
        }
    }

    private Map<QName, Metaset> initializeCatch(Metaset element) throws HandlerProcessException {
        HashMap<QName, Metaset> map = new HashMap<QName, Metaset>();
        int i = 0;
        while (i < element.getChilds().size()) {
            Metaset current = (Metaset)element.getChilds().get(i);
            String childName = (String.valueOf(current.getNamespace().equals("") ? "" : String.valueOf(current.getNamespace()) + ":") + current.getName()).trim();
            if (childName.equals("sodl:catch") && current.getAttributes().size() == 1) {
                Attribute attr = (Attribute)current.getAttributes().get(0);
                if ((String.valueOf(attr.getNameSpace().equals("") ? "" : String.valueOf(attr.getNameSpace()) + ":") + attr.getName()).trim().equals("sodl:exception") && !attr.getValue().equals("")) {
                    map.put(new QName(attr.getValue()), current);
                } else {
                    throw new HandlerProcessException(this.getAbsolutePath(element), "Attribute \"sodl:exception\" was not found or invalid in \"sodl:catch\" clause!");
                }
            }
            ++i;
        }
        if (map.size() == 0) {
            throw new HandlerProcessException(this.getAbsolutePath(element), "\"sodl:catch\" clause not found!");
        }
        return map;
    }
}

