/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.act.sodl.model.EngineElement;
import org.act.sodl.model.EngineThread;
import org.act.sodl.model.IEngineThread;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineTarget
extends EngineElement {
    private ServerSocket eCommandSocket;
    private Socket ecommandCom;
    private PrintWriter eResponseWriter;
    private BufferedReader eCommandReader;
    private ServerSocket eEventSocket;
    private Socket eEventCom;
    private PrintWriter eEventWriter;
    private IEngineThread[] eThreads;
    private EngineThread eThread;
    private Thread t;
    private CommandDispatchJob eCommandDispatch;

    public EngineTarget(String wsdl, String sodl, String java, Map<String, String> parameterMap, int commandPort, int eventPort, boolean debugging) {
        super(null);
        try {
            this.eCommandSocket = new ServerSocket(commandPort);
            this.ecommandCom = this.eCommandSocket.accept();
            this.eCommandReader = new BufferedReader(new InputStreamReader(this.ecommandCom.getInputStream()));
            this.eResponseWriter = new PrintWriter(this.ecommandCom.getOutputStream());
            this.eEventSocket = new ServerSocket(eventPort);
            this.eEventCom = this.eEventSocket.accept();
            this.eEventWriter = new PrintWriter(this.eEventCom.getOutputStream());
        }
        catch (UnknownHostException e) {
            this.sendResponse("exception " + e.getClass().getSimpleName() + " #### Unable to connect to debug model!");
        }
        catch (IOException e) {
            this.sendResponse("exception " + e.getClass().getSimpleName() + " #### IO Exception occurred!");
        }
        this.eThread = new EngineThread(this, wsdl, sodl, java, parameterMap, debugging);
        this.eThreads = new IEngineThread[]{this.eThread};
        this.t = new Thread(this.eThread);
        this.eCommandDispatch = new CommandDispatchJob();
    }

    public void scheduleCommandDispatchJob() {
        this.eCommandDispatch.schedule();
    }

    private void autoTerminated() {
        this.sendResponse("terminated auto");
    }

    private void userTerminated() {
        this.sendResponse("terminated user");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(String event) {
        ServerSocket serverSocket = this.eEventSocket;
        synchronized (serverSocket) {
            this.eEventWriter.println(event);
            this.eEventWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(String event) {
        ServerSocket serverSocket = this.eCommandSocket;
        synchronized (serverSocket) {
            this.eResponseWriter.println(event);
            this.eResponseWriter.flush();
        }
    }

    class CommandDispatchJob
    extends Job {
        public CommandDispatchJob() {
            super("Engine Command Dispatcher");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            EngineTarget.this.sendResponse("started");
            String command = "";
            while (!EngineTarget.this.eThread.isTerminated() && command != null) {
                try {
                    if (!EngineTarget.this.eCommandReader.ready()) {
                        Thread.sleep(1L);
                    } else {
                        command = EngineTarget.this.eCommandReader.readLine();
                    }
                    if (command == null) continue;
                    if ((command = command.trim()).toLowerCase().startsWith("resume")) {
                        if (!EngineTarget.this.t.isAlive()) {
                            EngineTarget.this.t.start();
                        }
                        EngineTarget.this.eThread.resume();
                    } else if (command.toLowerCase().equals("step")) {
                        EngineTarget.this.eThread.step();
                    } else if (command.toLowerCase().startsWith("var")) {
                        EngineTarget.this.eThread.getVariable(command);
                    } else if (command.toLowerCase().startsWith("set")) {
                        EngineTarget.this.eThread.setBreakpoints(command);
                    } else if (command.toLowerCase().startsWith("clear")) {
                        EngineTarget.this.eThread.clearBreakpoints(command);
                    } else if (command.toLowerCase().equals("stack")) {
                        EngineTarget.this.eThread.getStack();
                    } else if (command.toLowerCase().startsWith("context")) {
                        EngineTarget.this.eThread.getContextData(command);
                    } else if (command.toLowerCase().equals("exit")) {
                        EngineTarget.this.eThread.exit();
                    } else if (command.toLowerCase().startsWith("validate")) {
                        EngineTarget.this.eThread.validateBreakpoints(command);
                    } else if (!command.equals("")) {
                        EngineTarget.this.sendResponse("exception UnsupportedCommandException #### Unsupported Command or Incorrent Parameters: " + command);
                    }
                    command = "";
                }
                catch (IOException e) {
                    EngineTarget.this.sendResponse("exception " + e.getClass().getSimpleName() + " #### Some internal IO exceptions encountered!");
                    break;
                }
                catch (InterruptedException e) {
                    EngineTarget.this.sendResponse("exception " + e.getClass().getSimpleName() + " #### Some internal IO exceptions encountered!");
                    break;
                }
            }
            if (EngineTarget.this.eThread.isUserTerminated()) {
                EngineTarget.this.userTerminated();
            } else {
                EngineTarget.this.autoTerminated();
            }
            try {
                EngineTarget.this.eCommandSocket.close();
                EngineTarget.this.eEventSocket.close();
                if (EngineTarget.this.t.isAlive()) {
                    EngineTarget.this.t.interrupt();
                }
            }
            catch (IOException e) {
                EngineTarget.this.sendResponse("exception " + e.getClass().getSimpleName() + " #### Some internal IO Exception encountered!");
            }
            return Status.OK_STATUS;
        }
    }
}

