/*
 * Decompiled with CFR 0.152.
 */
package org.act.sodl.model;

import java.util.HashMap;
import java.util.Map;
import org.act.metaset.Metaset;
import org.act.sodl.engine.ContextManager;
import org.act.sodl.engine.SODLEngine;
import org.act.sodl.exception.EngineExecutionException;
import org.act.sodl.model.EngineBreakpoint;
import org.act.sodl.model.EngineElement;
import org.act.sodl.model.EngineStackFrame;
import org.act.sodl.model.EngineTarget;
import org.act.sodl.model.IEngineThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineThread
extends EngineElement
implements Runnable,
IEngineThread {
    private Map map = new HashMap();
    private String wsdl = null;
    private String sodl = null;
    private String java = null;
    private Map<String, String> parameterMap = null;
    private boolean eStepping = false;
    private boolean eSuspended = true;
    private boolean eTerminated = false;
    private boolean debugging = true;
    private boolean userTerminated = false;
    private Boolean waitFlag = new Boolean(true);
    private EngineStackFrame currentFrame = null;
    private ContextManager contextManager = null;
    private SODLEngine engine = null;

    public EngineThread(EngineTarget etarget, String wsdl, String sodl, String java, Map<String, String> parameterMap, boolean debugging) {
        super(etarget);
        this.wsdl = wsdl;
        this.sodl = sodl;
        this.java = java;
        this.parameterMap = parameterMap;
        this.debugging = debugging;
    }

    @Override
    public void clearBreakpoints(String command) {
        String[] parameters = null;
        parameters = command.split(" +");
        if (parameters.length == 2) {
            if (parameters[1] != null) {
                boolean successful = this.unregister(parameters[1]);
                if (!successful) {
                    this.getEngineTarget().sendResponse("breakpoint null");
                } else {
                    this.getEngineTarget().sendResponse("breakpoint cleared");
                }
            }
        } else {
            this.getEngineTarget().sendResponse("exception IncorrectParametersException #### Incorrect command parameters!");
        }
    }

    @Override
    public void setBreakpoints(String command) {
        String[] parameters = null;
        EngineBreakpoint eEngineBreakpoint = null;
        parameters = command.split(" +");
        if (parameters.length == 2) {
            if (parameters[1] != null) {
                eEngineBreakpoint = new EngineBreakpoint(this.getEngineTarget(), parameters[1], true);
                boolean successful = this.register(parameters[1], eEngineBreakpoint);
                if (!successful) {
                    this.getEngineTarget().sendResponse("breakpoint existed");
                } else {
                    this.getEngineTarget().sendResponse("breakpoint set");
                }
            }
        } else {
            this.getEngineTarget().sendResponse("exception IncorrectParametersException #### Incorrect command parameters!");
        }
    }

    @Override
    public void validateBreakpoints(String command) {
        String[] parameters = null;
        EngineBreakpoint eEngineBreakpoint = null;
        parameters = command.split(" +");
        if (parameters.length == 3) {
            if (parameters[1] != null && parameters[2] != null) {
                if (this.containsKey(parameters[1])) {
                    eEngineBreakpoint = (EngineBreakpoint)this.get(parameters[1]);
                    if (parameters[2].toLowerCase().equals("true")) {
                        eEngineBreakpoint.setBreakpointEnabled(true);
                        this.getEngineTarget().sendResponse("breakpoint valid");
                    } else if (parameters[2].toLowerCase().equals("false")) {
                        eEngineBreakpoint.setBreakpointEnabled(false);
                        this.getEngineTarget().sendResponse("breakpoint invalid");
                    } else {
                        this.getEngineTarget().sendResponse("exception IncorrectParametersException #### Incorrect third parameter!");
                    }
                } else {
                    this.getEngineTarget().sendResponse("exception NullBreakpointException #### There is no such a breakpoint!");
                }
            }
        } else {
            this.getEngineTarget().sendResponse("exception IncorrectParametersException #### Incorrect command parameters!");
        }
    }

    private Object get(Object path) {
        return this.map.get(path);
    }

    private boolean containsKey(String path) {
        return this.map.containsKey(path);
    }

    private boolean register(String path, EngineBreakpoint eEngineBreakpoint) {
        if (!this.map.containsKey(path)) {
            this.map.put(path, eEngineBreakpoint);
            return true;
        }
        return false;
    }

    private boolean unregister(String path) {
        if (this.map.containsKey(path)) {
            this.map.remove(path);
            return true;
        }
        return false;
    }

    @Override
    public void getVariable(String command) {
        String[] parameters = command.split(" +");
        if (parameters.length == 2) {
            String result = this.getSpecificVariable(parameters[1]);
            if (result != null) {
                this.getEngineTarget().sendData(String.valueOf(parameters[1]) + " " + result.replace("\n", "").replace("\r", "").replace("\t", ""));
            } else {
                this.getEngineTarget().sendData(null);
            }
        } else {
            this.getEngineTarget().sendData("incorrect parameters");
        }
    }

    private String getSpecificVariable(String path) {
        EngineStackFrame specificFrame = new EngineStackFrame(this, this.engine.getSODLContext().getSourceSODL(), this.contextManager);
        return specificFrame.calAttributes(path);
    }

    @Override
    public void getStack() {
        if (this.contextManager != null) {
            this.getEngineTarget().sendData(this.getDebugTrace(this.contextManager).replace("\n", "").replace("\r", "").replace("\t", ""));
        } else {
            this.getEngineTarget().sendData(null);
        }
    }

    private String getDebugTrace(ContextManager contextManager) {
        StringBuffer results = new StringBuffer();
        results.append(contextManager.getInElementName());
        while (contextManager.getParent() != null) {
            contextManager = contextManager.getParent();
            results.insert(0, String.valueOf(contextManager.getInElementName()) + " " + contextManager.getOutElementName() + " ");
        }
        return new String(results);
    }

    public void getContextData(String command) {
        String[] parameters = command.split(" +");
        if (parameters.length == 2 && this.contextManager != null) {
            ContextManager currentCM = this.getSpecificManager(parameters[1]);
            this.getEngineTarget().sendData(currentCM.getContextdata().replace("\n", "").replace("\r", "").replace("\t", ""));
        } else {
            this.getEngineTarget().sendData(null);
        }
    }

    private ContextManager getSpecificManager(String path) {
        ContextManager currentCM = this.contextManager;
        while (currentCM != null && !path.equals(currentCM.getInElementName())) {
            currentCM = currentCM.getParent();
        }
        return currentCM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void step() {
        this.getEngineTarget().sendResponse("resumed step");
        this.setStepping(true);
        Boolean bl = this.waitFlag;
        synchronized (bl) {
            this.waitFlag.notify();
        }
    }

    @Override
    public void exit() {
        this.setTerminated(true);
        this.setUserTerminated(true);
        if (this.engine != null && this.engine.isExecuting()) {
            this.engine.stopExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.getEngineTarget().sendResponse("resumed client");
        this.setStepping(false);
        this.setSuspended(false);
        Boolean bl = this.waitFlag;
        synchronized (bl) {
            this.waitFlag.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(String event, Metaset element, ContextManager cm) {
        if (event.equals("startsup")) {
            this.getEngineTarget().sendResponse("suspended startsup");
        } else if (event.startsWith("breakpoint")) {
            this.getEngineTarget().sendResponse("suspended " + event);
        } else if (event.startsWith("step")) {
            this.getEngineTarget().sendResponse("suspended " + event);
        }
        this.contextManager = cm;
        this.currentFrame = new EngineStackFrame(this, element, this.contextManager);
        this.setSuspended(true);
        Boolean bl = this.waitFlag;
        synchronized (bl) {
            try {
                this.waitFlag.wait();
            }
            catch (InterruptedException e) {
                this.getEngineTarget().sendResponse("exception " + e.getClass().getSimpleName() + " #### Some internal IO exceptions encountered!");
            }
        }
    }

    @Override
    public boolean isStepping() {
        return this.eStepping;
    }

    @Override
    public void setStepping(boolean stepping) {
        this.eStepping = stepping;
    }

    @Override
    public boolean isBreakpointHit(String path) {
        EngineBreakpoint breakpoint = (EngineBreakpoint)this.map.get(path);
        return breakpoint != null && breakpoint.IsEnabled() != false;
    }

    @Override
    public boolean isDebugging() {
        return this.debugging;
    }

    @Override
    public void setDebugging(boolean debugging) {
    }

    @Override
    public boolean isSuspended() {
        return this.eSuspended;
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.eSuspended = suspended;
    }

    @Override
    public boolean isTerminated() {
        return this.eTerminated;
    }

    @Override
    public void setTerminated(boolean terminated) {
        this.eTerminated = terminated;
    }

    @Override
    public boolean isUserTerminated() {
        return this.userTerminated;
    }

    @Override
    public void setUserTerminated(boolean userTerminated) {
        this.userTerminated = userTerminated;
    }

    @Override
    public EngineStackFrame getCurrentFrame() {
        return this.currentFrame;
    }

    @Override
    public void setCurrentFrame(EngineStackFrame currentFrame) {
        this.currentFrame = currentFrame;
    }

    @Override
    public void run() {
        this.setSuspended(false);
        this.setTerminated(false);
        this.engine = new SODLEngine();
        this.engine.startExecution();
        try {
            try {
                this.engine.execute(this.wsdl, this.sodl);
            }
            catch (EngineExecutionException e) {
                this.getEngineTarget().sendResponse("exception " + e.getExceptionName() + " " + e.toString().replace("\n", "").replace("\r", "").replace("\t", ""));
            }
        }
        finally {
            this.engine.stopExecution();
            this.setTerminated(true);
        }
    }
}

