/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.test;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import edu.unika.aifb.rdf.api.syntax.RDFParser;
import gnu.getopt.Getopt;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestParser;
import uk.ac.man.cs.img.owl.test.OWLTestVocabularyAdapter;

public class OWLTestExtracter2
implements RDFConsumer {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$test$OWLTestExtracter2 == null ? (class$uk$ac$man$cs$img$owl$test$OWLTestExtracter2 = OWLTestExtracter2.class$("uk.ac.man.cs.img.owl.test.OWLTestExtracter2")) : class$uk$ac$man$cs$img$owl$test$OWLTestExtracter2));
    static final int LITE = 1;
    static final int DL = 2;
    static final int FULL = 3;
    static final String converter = "http://phoebus.cs.man.ac.uk:9999/OWL/Converter";
    static final String validater = "http://phoebus.cs.man.ac.uk:9999/OWL/Validator";
    static final String testURL = "http://www.w3.org/2002/03owlt/";
    static final String xsd = "http://www.w3.org/2001/XMLSchema#";
    Set tests = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareTo((String)o2);
            }
            return -1;
        }
    });
    Map testTypes = new HashMap();
    Map testLevels = new HashMap();
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$test$OWLTestExtracter2;

    public Set getTests() {
        return this.tests;
    }

    public Map getTestTypes() {
        return this.testTypes;
    }

    public Map getTestLevels() {
        return this.testLevels;
    }

    public void parseTests(URI uri) throws Exception {
        RDFParser parser = new RDFParser();
        InputSource source = new InputSource(new InputStreamReader(uri.toURL().openStream()));
        source.setSystemId(uri.toString());
        parser.parse(source, (RDFConsumer)this);
    }

    public void startModel(String arg0) throws SAXException {
    }

    public void endModel() throws SAXException {
    }

    public void statementWithResourceValue(String subj, String pred, String obj) throws SAXException {
        if (pred.equals(OWLTestVocabularyAdapter.INSTANCE.getRDFType()) && OWLTestVocabularyAdapter.INSTANCE.getTestTypes().contains(obj)) {
            this.tests.add(subj);
            this.testTypes.put(subj, obj);
        }
        if (pred.equals(OWLTestVocabularyAdapter.INSTANCE.getLevel())) {
            HashSet<String> levelSet = (HashSet<String>)this.testLevels.get(subj);
            if (levelSet == null) {
                levelSet = new HashSet<String>();
                this.testLevels.put(subj, levelSet);
            }
            levelSet.add(obj);
        }
    }

    public void statementWithLiteralValue(String subject, String predicate, String object, String parseType, String language) throws SAXException {
    }

    public void logicalURI(String arg0) throws SAXException {
    }

    public void includeModel(String arg0, String arg1) throws SAXException {
    }

    public void addModelAttribte(String arg0, String arg1) throws SAXException {
    }

    public static void usage() {
        System.out.println("Usage: OWLTestExtracter2 options* url");
        System.out.println("  -h HTML output");
        System.out.println("  -d Include tests with datatypes");
        System.out.println("  -o Include obsoleted tests");
        System.out.println("  -l (lite|dl|full)");
        System.out.println("  -t (positive|negative|consistent|inconsistent|all)");
        System.out.println("  -z url is URL of a zip file containing test manifests.");
        System.out.println("  -? help");
        System.exit(0);
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            int c;
            boolean html = false;
            int requiredLevel = 3;
            String requiredType = null;
            boolean datatypes = false;
            boolean obsolete = false;
            boolean zip = false;
            String arg = null;
            Getopt g = new Getopt("OWLTestExtracter2", args, "?dhl:t:oz");
            while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 63: {
                        OWLTestExtracter2.usage();
                    }
                    case 100: {
                        datatypes = true;
                        break;
                    }
                    case 104: {
                        html = true;
                        break;
                    }
                    case 111: {
                        obsolete = true;
                        break;
                    }
                    case 108: {
                        arg = g.getOptarg();
                        if (arg.equals("lite")) {
                            requiredLevel = 1;
                            break;
                        }
                        if (arg.equals("dl")) {
                            requiredLevel = 2;
                            break;
                        }
                        if (arg.equals("full")) {
                            requiredLevel = 3;
                            break;
                        }
                        OWLTestExtracter2.usage();
                        break;
                    }
                    case 116: {
                        arg = g.getOptarg();
                        if (arg.equals("positive")) {
                            requiredType = OWLTestVocabularyAdapter.INSTANCE.getPositiveEntailmentTest();
                            break;
                        }
                        if (arg.equals("negative")) {
                            requiredType = OWLTestVocabularyAdapter.INSTANCE.getNegativeEntailmentTest();
                            break;
                        }
                        if (arg.equals("consistent")) {
                            requiredType = OWLTestVocabularyAdapter.INSTANCE.getConsistencyTest();
                            break;
                        }
                        if (arg.equals("inconsistent")) {
                            requiredType = OWLTestVocabularyAdapter.INSTANCE.getInconsistencyTest();
                            break;
                        }
                        if (arg.equals("all")) {
                            requiredType = null;
                            break;
                        }
                        OWLTestExtracter2.usage();
                        break;
                    }
                    case 122: {
                        zip = true;
                    }
                }
            }
            int i = g.getOptind();
            if (html) {
                System.out.println("<html>");
                System.out.println("<head>");
                System.out.println("<style>");
                System.out.println("body {");
                System.out.println(" font-family: helvetica;");
                System.out.println("}");
                System.out.println("a {");
                System.out.println(" text-decoration:none;");
                System.out.println(" font-weight:bold;");
                System.out.println(" color:#ooc;");
                System.out.println("}");
                System.out.println("</style>");
                System.out.println("</head>");
                System.out.println("<body>");
                System.out.println("<h1>Tests</h1>");
                System.out.println("<table border='1'>");
                System.out.println("<tr><th>Name</th><th>Level/Type</th><th>Type/Name</th><th></th><th>Status</th><th>Comment</th></tr>");
            }
            OWLTestExtracter2 extracter = new OWLTestExtracter2();
            OWLTestParser otp = new OWLTestParser();
            while (i < args.length) {
                if (zip) {
                    URL url = new URL(args[i]);
                    ZipInputStream zis = new ZipInputStream(url.openStream());
                    ZipEntry ze = null;
                    while ((ze = zis.getNextEntry()) != null) {
                        String name = ze.getName();
                        if (!name.matches(".*Manifest.*rdf")) continue;
                        URI manifestURI = new URI(testURL + name);
                        extracter.parseTests(manifestURI);
                    }
                    ++i;
                    continue;
                }
                URI manifestURI = new URI(args[i]);
                extracter.parseTests(manifestURI);
                ++i;
            }
            int positiveTests = 0;
            int negativeTests = 0;
            int consistencyTests = 0;
            int inconsistencyTests = 0;
            Iterator it = extracter.getTests().iterator();
            while (it.hasNext()) {
                String test = (String)it.next();
                HashSet levels = (HashSet)extracter.getTestLevels().get(test);
                if (levels == null) {
                    levels = new HashSet();
                }
                int testLevel = 3;
                if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLLite())) {
                    testLevel = 1;
                } else if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLDL())) {
                    testLevel = 2;
                } else if (((Object)levels).equals(OWLTestVocabularyAdapter.INSTANCE.getOWLFull())) {
                    testLevel = 3;
                }
                String type = (String)extracter.getTestTypes().get(test);
                if (requiredType != null && !type.equals(requiredType) || testLevel > requiredLevel) continue;
                URI turi = new URI(test);
                OWLTest otest = otp.parseTest(turi);
                if (!obsolete && otest.getStatus().equals("OBSOLETED") || !datatypes && !otest.getDatatypes().isEmpty()) continue;
                if (type.equals(OWLTestVocabularyAdapter.INSTANCE.getPositiveEntailmentTest())) {
                    ++positiveTests;
                } else if (type.equals(OWLTestVocabularyAdapter.INSTANCE.getNegativeEntailmentTest())) {
                    ++negativeTests;
                } else if (type.equals(OWLTestVocabularyAdapter.INSTANCE.getConsistencyTest())) {
                    ++consistencyTests;
                } else if (type.equals(OWLTestVocabularyAdapter.INSTANCE.getInconsistencyTest())) {
                    ++inconsistencyTests;
                }
                OWLTestExtracter2.printTest(otest, html);
            }
            if (html) {
                System.out.println("</table>");
                System.out.println("<h2>Summary</h2>");
                System.out.println("<table>");
                System.out.println("<tr><td>Positive:</td><td>" + positiveTests + "</td></tr>");
                System.out.println("<tr><td>Negative:</td><td>" + negativeTests + "</td></tr>");
                System.out.println("<tr><td>Consistency:</td><td>" + consistencyTests + "</td></tr>");
                System.out.println("<tr><td>Inconsistency:</td><td>" + inconsistencyTests + "</td></tr>");
                System.out.println("</table>");
                System.out.println("</body>");
                System.out.println("</html>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String shorten(String str) {
        if (str.startsWith("http://www.w3.org/2002/03owlt/testOntology#")) {
            return "otest:" + str.substring("http://www.w3.org/2002/03owlt/testOntology#".length());
        }
        if (str.startsWith("http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#")) {
            return "rtest:" + str.substring("http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#".length());
        }
        if (str.startsWith(xsd)) {
            return "xsd:" + str.substring(xsd.length());
        }
        if (str.startsWith(testURL)) {
            return str.substring(testURL.length());
        }
        return str;
    }

    public static void printTest(OWLTest test, boolean html) {
        if (!html) {
            System.out.println(test.getURI());
        } else {
            System.out.println("<tr>");
            System.out.println("<td valign='top'><a href='" + test.getURI() + "'>" + OWLTestExtracter2.shorten(test.getURI()) + "</a>");
            System.out.println("</td>");
            String type = test.getType();
            if (type.startsWith("http://www.w3.org/2002/03owlt/testOntology#")) {
                type = "otest:" + type.substring("http://www.w3.org/2002/03owlt/testOntology#".length());
            }
            Set testLevelSet = (Set)test.getDocumentLevels().get(test.getURI());
            String testLevel = null;
            if (testLevelSet.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLLite())) {
                testLevel = OWLTestVocabularyAdapter.INSTANCE.getOWLLite();
            } else if (testLevelSet.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLDL())) {
                testLevel = OWLTestVocabularyAdapter.INSTANCE.getOWLDL();
            } else if (testLevelSet.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLFull())) {
                testLevel = OWLTestVocabularyAdapter.INSTANCE.getOWLFull();
            }
            if (testLevel == null) {
                testLevel = "none";
            }
            if (testLevel.startsWith("http://www.w3.org/2002/03owlt/testOntology#")) {
                testLevel = "otest:" + testLevel.substring("http://www.w3.org/2002/03owlt/testOntology#".length());
            }
            String status = test.getStatus();
            System.out.println("<td valign='top'>" + testLevel + "</td>");
            System.out.println("<td valign='top'>" + type + "</td>");
            String col = "white";
            String txt = "black";
            if (status.equals("APPROVED")) {
                col = "green";
                txt = "white";
            } else if (status.equals("PROPOSED")) {
                col = "yellow";
            } else if (status.equals("OBSOLETED")) {
                col = "red";
                txt = "white";
            }
            System.out.println("<td  colspan='3'>");
            Iterator it = test.getDatatypes().iterator();
            while (it.hasNext()) {
                String doc = (String)it.next();
                System.out.println(OWLTestExtracter2.shorten(doc));
            }
            System.out.println("</td>");
            System.out.println("<td style='color:" + txt + ";background-color:" + col + "' valign='top'>" + status + "</td>");
            String description = "";
            try {
                description = (String)test.getDescriptions().get(test.getURI());
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
            System.out.println("<td>" + description + "</td>");
            System.out.println("</tr>");
            Iterator it2 = test.getDocuments().iterator();
            while (it2.hasNext()) {
                String doc = (String)it2.next();
                System.out.println("<tr><td></td>");
                Set levels = (Set)test.getDocumentLevels().get(doc);
                String level = "";
                Iterator lit = levels.iterator();
                level = (String)lit.next();
                String role = (String)test.getDocumentRoles().get(doc);
                String vl = "Full";
                if (level.startsWith("http://www.w3.org/2002/03owlt/testOntology#")) {
                    if (level.equals(OWLTestVocabularyAdapter.INSTANCE.getOWLLite())) {
                        vl = "Lite";
                    } else if (level.equals(OWLTestVocabularyAdapter.INSTANCE.getOWLDL())) {
                        vl = "DL";
                    }
                    level = "otest:" + level.substring("http://www.w3.org/2002/03owlt/testOntology#".length());
                }
                if (role.startsWith("http://www.w3.org/2002/03owlt/testOntology#")) {
                    role = "otest:" + role.substring("http://www.w3.org/2002/03owlt/testOntology#".length());
                }
                if (role.startsWith("http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#")) {
                    role = "rtest:" + role.substring("http://www.w3.org/2000/10/rdf-tests/rdfcore/testSchema#".length());
                }
                System.out.println("<td valign='top'>" + role + "</td>");
                System.out.println("<td valign='top'><a href='" + doc + "'>" + OWLTestExtracter2.shorten(doc) + "</a></td>");
                System.out.println("<td valign='top'>" + level + "</td>");
                System.out.println("<td><a href='http://phoebus.cs.man.ac.uk:9999/OWL/Validator?url=" + doc + "&level=" + vl + "'>validate</a></td>");
                System.out.println("<td><a href='http://phoebus.cs.man.ac.uk:9999/OWL/Converter?url=" + doc + "&format=abstract'>abstract</a></td>");
                System.out.println("<td><a href='http://phoebus.cs.man.ac.uk:9999/OWL/Converter?url=" + doc + "&format=tptp'>tptp</a></td>");
                System.out.println("</tr>");
            }
            System.out.println("</tr>");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

