/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashSet;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.IndividualBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class DisjunctionBranch
extends IndividualBranch {
    ATermAppl disjunction;
    private ATermAppl[] disj;
    DependencySet[] prevDS;
    int[] order;

    public DisjunctionBranch(ABox abox, CompletionStrategy completion, Individual x, ATermAppl disjunction, DependencySet ds, ATermAppl[] disj) {
        super(abox, completion, x, ds, disj.length);
        this.disjunction = disjunction;
        this.setDisj(disj);
        this.prevDS = new DependencySet[disj.length];
        this.order = new int[disj.length];
        for (int i = 0; i < disj.length; ++i) {
            this.order[i] = i;
        }
    }

    protected String getDebugMsg() {
        return "DISJ: Branch (" + this.getBranch() + ") try (" + (this.getTryNext() + 1) + "/" + this.getTryCount() + ") " + this.ind + " " + ATermUtils.toString(this.disj[this.getTryNext()]) + " " + ATermUtils.toString(this.disjunction);
    }

    public IndividualBranch copyTo(ABox abox) {
        Individual x = abox.getIndividual((ATerm)this.ind.getName());
        DisjunctionBranch b = new DisjunctionBranch(abox, null, x, this.disjunction, this.getTermDepends(), this.disj);
        b.setAnonCount(this.anonCount);
        b.setNodeCount(this.nodeCount);
        b.setBranch(this.branch);
        b.setStrategy(this.strategy);
        b.setTryNext(this.tryNext);
        b.prevDS = new DependencySet[this.disj.length];
        System.arraycopy(this.prevDS, 0, b.prevDS, 0, this.disj.length);
        b.order = new int[this.disj.length];
        System.arraycopy(this.order, 0, b.order, 0, this.disj.length);
        return b;
    }

    private int preferredDisjunct() {
        if (this.disj.length != 2) {
            return -1;
        }
        if (ATermUtils.isPrimitive(this.disj[0]) && ATermUtils.isAllValues(this.disj[1]) && ATermUtils.isNot((ATermAppl)this.disj[1].getArgument(1))) {
            return 1;
        }
        if (ATermUtils.isPrimitive(this.disj[1]) && ATermUtils.isAllValues(this.disj[0]) && ATermUtils.isNot((ATermAppl)this.disj[0].getArgument(1))) {
            return 0;
        }
        return -1;
    }

    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.getTryNext() >= 0) {
            this.prevDS[this.getTryNext()] = ds;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void tryBranch() {
        this.abox.incrementBranch();
        int[] stats = null;
        if (PelletOptions.USE_DISJUNCT_SORTING) {
            stats = this.abox.getDisjBranchStats().get(this.disjunction);
            if (stats == null) {
                int preference = this.preferredDisjunct();
                stats = new int[this.disj.length];
                for (int i = 0; i < this.disj.length; ++i) {
                    stats[i] = i != preference ? 0 : Integer.MIN_VALUE;
                }
                this.abox.getDisjBranchStats().put(this.disjunction, stats);
            }
            if (this.getTryNext() > 0) {
                int n = this.order[this.getTryNext() - 1];
                stats[n] = stats[n] + 1;
            }
            if (stats != null) {
                int minIndex = this.getTryNext();
                int minValue = stats[this.getTryNext()];
                for (int i = this.getTryNext() + 1; i < stats.length; ++i) {
                    boolean tryEarlier;
                    boolean bl = tryEarlier = stats[i] < minValue;
                    if (!tryEarlier) continue;
                    minIndex = i;
                    minValue = stats[i];
                }
                if (minIndex != this.getTryNext()) {
                    ATermAppl selDisj = this.disj[minIndex];
                    this.disj[minIndex] = this.disj[this.getTryNext()];
                    this.disj[this.getTryNext()] = selDisj;
                    this.order[minIndex] = this.getTryNext();
                    this.order[this.getTryNext()] = minIndex;
                }
            }
        }
        while (this.getTryNext() < this.getTryCount()) {
            DependencySet clashDepends;
            ATermAppl d = this.disj[this.getTryNext()];
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.getTryNext(); ++m) {
                    this.strategy.addType(this.ind, ATermUtils.negate(this.disj[m]), this.prevDS[m]);
                }
            }
            DependencySet ds = null;
            if (this.getTryNext() == this.getTryCount() - 1 && !PelletOptions.SATURATE_TABLEAU) {
                ds = this.getTermDepends();
                for (int m = 0; m < this.getTryNext(); ++m) {
                    ds = ds.union(this.prevDS[m], this.abox.doExplanation());
                }
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    ds.setExplain(this.getTermDepends().getExplain());
                } else {
                    ds.remove(this.getBranch());
                }
            } else if (PelletOptions.USE_INCREMENTAL_DELETION) {
                ds = this.getTermDepends().union(new DependencySet(this.getBranch()), this.abox.doExplanation());
            } else {
                ds = new DependencySet(this.getBranch());
                HashSet<ATermAppl> explain = new HashSet<ATermAppl>();
                explain.addAll(this.getTermDepends().getExplain());
                ds.setExplain(explain);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getDebugMsg());
            }
            ATermAppl notD = ATermUtils.negate(d);
            DependencySet dependencySet = clashDepends = PelletOptions.SATURATE_TABLEAU ? null : this.ind.getDepends((ATerm)notD);
            if (clashDepends == null) {
                this.strategy.addType(this.ind, d, ds);
                if (this.abox.isClosed()) {
                    clashDepends = this.abox.getClash().getDepends();
                }
            } else {
                clashDepends = clashDepends.union(ds, this.abox.doExplanation());
            }
            if (clashDepends == null) return;
            if (log.isLoggable(Level.FINE)) {
                Clash clash = this.abox.isClosed() ? this.abox.getClash() : Clash.atomic(this.ind, clashDepends, d);
                log.fine("CLASH: Branch " + this.getBranch() + " " + clash + "!" + " " + clashDepends.getExplain());
            }
            if (PelletOptions.USE_DISJUNCT_SORTING) {
                if (stats == null) {
                    stats = new int[this.disj.length];
                    for (int i = 0; i < this.disj.length; ++i) {
                        stats[i] = 0;
                    }
                    this.abox.getDisjBranchStats().put(this.disjunction, stats);
                }
                int n = this.order[this.getTryNext()];
                stats[n] = stats[n] + 1;
            }
            if (this.getTryNext() < this.getTryCount() - 1 && clashDepends.contains(this.getBranch())) {
                if (this.abox.isClosed()) {
                    this.strategy.restoreLocal(this.ind, this);
                    this.abox.incrementBranch();
                }
            } else {
                if (this.abox.doExplanation()) {
                    ATermAppl positive = ATermUtils.isNot(notD) ? d : notD;
                    this.abox.setClash(Clash.atomic(this.ind, clashDepends.union(ds, this.abox.doExplanation()), positive));
                } else {
                    this.abox.setClash(Clash.atomic(this.ind, clashDepends.union(ds, this.abox.doExplanation())));
                }
                if (!PelletOptions.USE_INCREMENTAL_DELETION) return;
                this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this.abox.getClash().getDepends());
                return;
            }
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    public void shiftTryNext(int openIndex) {
        ATermAppl dis = this.disj[openIndex];
        if (PelletOptions.USE_SEMANTIC_BRANCHING) {
            // empty if block
        }
        for (int i = openIndex; i < this.disj.length - 1; ++i) {
            this.disj[i] = this.disj[i + 1];
            this.prevDS[i] = this.prevDS[i + 1];
            this.order[i] = this.order[i];
        }
        this.disj[this.disj.length - 1] = dis;
        this.prevDS[this.disj.length - 1] = null;
        this.order[this.disj.length - 1] = this.disj.length - 1;
        this.setTryNext(this.getTryNext() - 1);
    }

    public void printLong() {
        for (int i = 0; i < this.disj.length; ++i) {
            System.out.println("Disj[" + i + "] " + this.disj[i]);
            System.out.println("prevDS[" + i + "] " + this.prevDS[i]);
            System.out.println("order[" + i + "] " + this.order[i]);
        }
        System.out.println("trynext: " + this.getTryNext());
    }

    public void setDisj(ATermAppl[] disj) {
        this.disj = disj;
    }

    public ATermAppl getDisjunct(int i) {
        return this.disj[i];
    }
}

