/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.blocking.OptimizedDoubleBlocking;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class SHOIQStrategy
extends SROIQStrategy {
    public SHOIQStrategy(ABox abox) {
        super(abox, new OptimizedDoubleBlocking());
    }

    void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        Role s = this.abox.getRole(av.getArgument(0));
        ATermAppl c = (ATermAppl)av.getArgument(1);
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edgeToY = edges.edgeAt(e);
            Node y = edgeToY.getNeighbor(x);
            DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation());
            if (this.abox.doExplanation()) {
                Role edgeRole = edgeToY.getRole();
                DependencySet subDS = s.getExplainSubOrInv(edgeRole);
                finalDS = finalDS.union(subDS.getExplain(), true);
            }
            this.applyAllValues(x, s, y, c, finalDS);
            if (!x.isMerged()) continue;
            return;
        }
        if (!s.isSimple()) {
            for (Role r : s.getTransitiveSubRoles()) {
                ATermAppl allRC = ATermUtils.makeAllValues((ATerm)r.getName(), (ATerm)c);
                edges = x.getRNeighborEdges(r);
                for (int e = 0; e < edges.size(); ++e) {
                    Edge edgeToY = edges.edgeAt(e);
                    Node y = edgeToY.getNeighbor(x);
                    DependencySet finalDS = ds.union(edgeToY.getDepends(), this.abox.doExplanation());
                    if (this.abox.doExplanation()) {
                        finalDS = finalDS.union(r.getExplainTransitive().getExplain(), true);
                        finalDS = finalDS.union(s.getExplainSubOrInv(edgeToY.getRole()), true);
                    }
                    this.applyAllValues(x, r, y, allRC, finalDS);
                    if (!x.isMerged()) continue;
                    return;
                }
            }
        }
    }

    void applyAllValues(Individual subj, Role pred, Node obj, DependencySet ds) {
        List<ATermAppl> allValues = subj.getTypes(3);
        int size = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = i.next();
            Role s = this.abox.getRole(av.getArgument(0));
            if (pred.isSubRoleOf(s)) {
                ATermAppl c = (ATermAppl)av.getArgument(1);
                DependencySet finalDS = ds.union(subj.getDepends((ATerm)av), this.abox.doExplanation());
                if (this.abox.doExplanation()) {
                    finalDS = finalDS.union(s.getExplainSubOrInv(pred).getExplain(), true);
                }
                this.applyAllValues(subj, s, obj, c, finalDS);
                if (s.isTransitive()) {
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)s.getName(), (ATerm)c);
                    finalDS = ds.union(subj.getDepends((ATerm)av), this.abox.doExplanation());
                    if (this.abox.doExplanation()) {
                        finalDS = finalDS.union(s.getExplainTransitive().getExplain(), true);
                    }
                    this.applyAllValues(subj, s, obj, allRC, finalDS);
                }
            }
            if (size == allValues.size()) continue;
            i = allValues.iterator();
            size = allValues.size();
        }
    }
}

