/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategy;
import com.clarkparsia.pellet.rules.BindingGeneratorStrategyImpl;
import com.clarkparsia.pellet.rules.ContinuousReteTransformer;
import com.clarkparsia.pellet.rules.RuleAtomAsserter;
import com.clarkparsia.pellet.rules.RulesToATermTranslator;
import com.clarkparsia.pellet.rules.RulesToReteTranslator;
import com.clarkparsia.pellet.rules.TrivialSatisfactionHelpers;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.blocking.OptimizedDoubleBlocking;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.RuleBranch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.SROIQStrategy;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.Timer;

public class ContinuousRulesStrategy
extends SROIQStrategy {
    private BindingGeneratorStrategy bindingStrategy;
    private ContinuousReteTransformer continuousTransformer;
    private Interpreter interpreter;
    private boolean merging;
    private Map<Fact, Integer> partialBindings;
    private Map<Pair<Rule, VariableBinding>, Integer> rulesApplied;
    private RulesToReteTranslator ruleTranslator;
    private RulesToATermTranslator atermTranslator;
    private RuleAtomAsserter ruleAtomAsserter;
    private TrivialSatisfactionHelpers atomTester;
    boolean runRules;

    public ContinuousRulesStrategy(ABox abox) {
        super(abox);
        this.bindingStrategy = new BindingGeneratorStrategyImpl(abox);
        this.continuousTransformer = new ContinuousReteTransformer(abox);
        this.partialBindings = new HashMap<Fact, Integer>();
        this.rulesApplied = new HashMap<Pair<Rule, VariableBinding>, Integer>();
        this.ruleTranslator = new RulesToReteTranslator(abox);
        this.atermTranslator = new RulesToATermTranslator();
        this.ruleAtomAsserter = new RuleAtomAsserter(abox, (CompletionStrategy)this);
        this.atomTester = new TrivialSatisfactionHelpers(abox);
        this.runRules = true;
        if (!abox.getKB().getExpressivity().hasComplexSubRoles()) {
            this.blocking = new OptimizedDoubleBlocking();
        }
    }

    public void addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        super.addEdge(subj, pred, obj, ds);
        if (!this.merging && !this.abox.isClosed() && subj.isRootNominal() && obj.isRootNominal() && this.interpreter != null) {
            EdgeList edges = subj.getRNeighborEdges(pred, obj);
            for (Edge edge : edges) {
                if (!edge.getFrom().isRootNominal() || !edge.getTo().isRootNominal()) continue;
                this.runRules |= this.interpreter.rete.addFact(edge);
            }
            this.runRules |= this.interpreter.rete.addDifferents(subj);
            if (obj.isIndividual()) {
                this.runRules |= this.interpreter.rete.addDifferents((Individual)obj);
            }
        }
    }

    public void addType(Node node, ATermAppl c, DependencySet ds) {
        super.addType(node, c, ds);
        if (!this.merging && !this.abox.isClosed() && node.isRootNominal() && this.interpreter != null && node.isIndividual()) {
            Individual ind = (Individual)node;
            this.runRules |= this.interpreter.rete.addFact(ind, c, ind.getDepends((ATerm)c));
            this.runRules |= this.interpreter.rete.addDifferents((Individual)node);
        }
    }

    private void applyFact(Fact fact) {
        if (fact.getElements().size() == 0) {
            this.abox.setClash(Clash.unexplained(null, (DependencySet)fact.getDependencySet()));
            log.log(Level.WARNING, "Fact with no elements, create clash");
            return;
        }
        if (fact.getElements().size() == 3) {
            DependencySet ds = fact.getDependencySet();
            if (log.isLoggable(Level.FINE)) {
                log.fine("RULE: " + fact + " " + ds);
            }
            ATermAppl pred = (ATermAppl)fact.getElements().get(0);
            Individual subj = this.abox.getIndividual((ATerm)fact.getElements().get(1));
            if (subj.isMerged()) {
                ds = ds.union(subj.getMergeDependency(true), this.abox.doExplanation());
                subj = subj.getSame();
            }
            ATermAppl objTerm = (ATermAppl)fact.getElements().get(2);
            if (pred.equals(Compiler.TYPE)) {
                ATermAppl type = objTerm;
                this.addType((Node)subj, type, fact.getDependencySet());
            } else {
                Node obj = this.abox.getNode((ATerm)objTerm);
                if (obj != null && obj.isMerged()) {
                    ds = ds.union(ds, this.abox.doExplanation());
                    obj = obj.getSame();
                }
                if (pred.equals(Compiler.SAME_AS)) {
                    Individual ind2 = (Individual)obj;
                    this.mergeTo((Node)ind2, (Node)subj, fact.getDependencySet());
                } else if (pred.equals(Compiler.DIFF_FROM)) {
                    Individual ind2 = (Individual)obj;
                    subj.setDifferent((Node)ind2, fact.getDependencySet());
                } else {
                    Role r = this.abox.getRole((ATerm)pred);
                    if (obj == null && r.isDatatypeRole()) {
                        obj = this.abox.addLiteral(objTerm);
                    }
                    this.addEdge(subj, r, obj, fact.getDependencySet());
                }
            }
        }
    }

    public void applyRete() {
        Timer t;
        if (PelletOptions.ALWAYS_REBUILD_RETE) {
            t = this.timers.startTimer("rule-rebuildRete");
            this.interpreter.reset();
            this.interpreter.rete.compileFacts(this.abox);
            this.partialBindings.clear();
            t.stop();
        }
        if (!this.interpreter.isDirty()) {
            return;
        }
        t = this.timers.startTimer("rule-reteRun");
        Set<Fact> inferred = this.interpreter.run();
        t.stop();
        t = this.timers.startTimer("rule-reteFacts");
        for (Fact fact : inferred) {
            assert (fact.getDependencySet().getBranch() == this.abox.getBranch());
            assert (fact.getDependencySet().max() <= this.abox.getBranch());
            this.applyFact(fact);
            if (this.abox.isClosed()) {
                t.stop();
                return;
            }
            if (fact.getElements().size() <= 3 || !((ATermAppl)fact.getElements().get(0)).equals(ContinuousReteTransformer.VARBINDING) || this.partialBindings.containsKey(fact)) continue;
            this.partialBindings.put(fact, this.abox.getBranch());
        }
        t.stop();
    }

    public void applyRuleBindings() {
        int total = 0;
        for (Fact ruleBinding : this.partialBindings.keySet()) {
            Pair<Rule, VariableBinding> pair = this.continuousTransformer.translateFact(ruleBinding);
            Rule rule = (Rule)pair.first;
            VariableBinding initial = (VariableBinding)pair.second;
            for (VariableBinding binding : this.bindingStrategy.createGenerator(rule, initial)) {
                int branch;
                Pair ruleKey = new Pair((Object)rule, (Object)binding);
                if (this.rulesApplied.containsKey(ruleKey)) continue;
                ++total;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Binding: " + binding);
                    log.fine("total:" + total);
                }
                if ((branch = this.createDisjunctionsFromBinding(binding, rule, ruleBinding.getDependencySet())) >= 0) {
                    this.rulesApplied.put((Pair<Rule, VariableBinding>)ruleKey, branch);
                }
                if (!this.abox.isClosed()) continue;
                return;
            }
        }
    }

    public void applyRULERule() {
        this.applyRete();
        if (!this.abox.isClosed()) {
            this.applyRuleBindings();
        }
    }

    public void complete(Expressivity expr) {
        Expressivity expressivity = this.abox.getKB().getExpressivity();
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        this.initialize();
        this.merging = false;
        this.interpreter = new Interpreter(this.abox);
        for (Rule rule : this.abox.getKB().getRules()) {
            ATermAppl explain = this.abox.doExplanation() ? this.atermTranslator.translate(rule) : null;
            com.clarkparsia.pellet.rules.rete.Rule reteRule = this.ruleTranslator.translateRule(rule);
            if (reteRule != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("SWRL Rule: " + rule);
                    log.finer("Rete Rule: " + reteRule);
                    log.finer("Term Rule: " + explain);
                    log.finer("===");
                }
                this.interpreter.rete.compile(reteRule, explain);
            }
            if ((reteRule = this.continuousTransformer.transformRule(rule)) == null) continue;
            this.interpreter.rete.compile(reteRule, explain);
        }
        this.partialBindings.clear();
        this.rulesApplied.clear();
        if (log.isLoggable(Level.FINER)) {
            log.finer("AlphaStore: " + this.interpreter.rete);
        }
        this.interpreter.rete.compileFacts(this.abox);
        while (this.interpreter.isDirty() && !this.abox.isClosed()) {
            this.applyRete();
        }
        while (!this.abox.isComplete()) {
            while (this.abox.isChanged() && !this.abox.isClosed()) {
                this.completionTimer.check();
                this.abox.setChanged(false);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.abox.printTree();
                }
                IndividualIterator i = this.abox.getIndIterator();
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    this.applyNominalRule(i);
                    if (this.abox.isClosed()) break;
                }
                this.applyGuessingRule(i);
                if (this.abox.isClosed()) break;
                this.applyChooseRule(i);
                if (this.abox.isClosed()) break;
                this.applyMaxRule(i);
                if (this.abox.isClosed()) break;
                if (fullDatatypeReasoning) {
                    this.checkDatatypeCount(i);
                    if (this.abox.isClosed()) break;
                    this.applyLiteralRule();
                    if (this.abox.isClosed()) break;
                }
                this.applyUnfoldingRule(i);
                if (this.abox.isClosed()) break;
                this.applyDisjunctionRule(i);
                if (this.abox.isClosed()) break;
                this.applySomeValuesRule(i);
                if (this.abox.isClosed()) break;
                this.applyMinRule(i);
                if (this.abox.isClosed()) break;
                if (!this.abox.isChanged()) {
                    while (this.interpreter.isDirty() && !this.abox.isClosed()) {
                        this.applyRete();
                    }
                    if (this.abox.isClosed()) break;
                }
                if (this.abox.isChanged() || !this.runRules) continue;
                this.runRules = false;
                this.applyRuleBindings();
                if (!this.abox.isClosed()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            if (PelletOptions.SATURATE_TABLEAU) {
                Branch unexploredBranch = null;
                for (int i = this.abox.getBranches().size() - 1; i >= 0; --i) {
                    unexploredBranch = (Branch)this.abox.getBranches().get(i);
                    unexploredBranch.setTryNext(unexploredBranch.getTryNext() + 1);
                    if (unexploredBranch.getTryNext() < unexploredBranch.getTryCount()) {
                        this.restore(unexploredBranch);
                        System.out.println("restoring branch " + unexploredBranch.getBranch() + " tryNext = " + unexploredBranch.getTryNext() + " tryCount = " + unexploredBranch.getTryCount());
                        unexploredBranch.tryNext();
                        break;
                    }
                    System.out.println("removing branch " + unexploredBranch.getBranch());
                    this.abox.getBranches().remove(i);
                    unexploredBranch = null;
                }
                if (unexploredBranch != null) continue;
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
    }

    private int createDisjunctionsFromBinding(VariableBinding binding, Rule rule, DependencySet ds) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            DependencySet dependencySet = this.atomTester.isAtomTrue(ruleAtom, binding);
            if (dependencySet != null) {
                ds = ds.union(dependencySet, this.abox.doExplanation());
                continue;
            }
            atoms.add(ruleAtom);
        }
        if (atoms.isEmpty()) {
            if (rule.getHead().isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Empty head for rule " + rule);
                }
                this.abox.setClash(Clash.unexplained(null, (DependencySet)ds));
            } else {
                for (RuleAtom ruleAtom : rule.getHead()) {
                    this.ruleAtomAsserter.assertAtom(ruleAtom, binding, ds, false);
                }
            }
            return -1;
        }
        int bodyAtomCount = atoms.size();
        for (RuleAtom ruleAtom : rule.getHead()) {
            DependencySet atomDS = this.atomTester.isAtomTrue(ruleAtom, binding);
            if (atomDS != null) continue;
            atoms.add(ruleAtom);
        }
        if (atoms.size() == bodyAtomCount && !rule.getHead().isEmpty()) {
            return -1;
        }
        if (atoms.size() == 1) {
            this.ruleAtomAsserter.assertAtom((RuleAtom)atoms.get(0), binding, ds, true);
            return -1;
        }
        RuleBranch ruleBranch = new RuleBranch(this.abox, (CompletionStrategy)this, this.ruleAtomAsserter, atoms, binding, bodyAtomCount, ds);
        this.addBranch((Branch)ruleBranch);
        ruleBranch.tryNext();
        return ruleBranch.getBranch();
    }

    public void mergeTo(Node y, Node z, DependencySet ds) {
        this.merging = true;
        super.mergeTo(y, z, ds);
        if (!this.abox.isClosed() && this.interpreter != null && (y.isRootNominal() || z.isRootNominal())) {
            if (y.isRootNominal()) {
                this.runRules |= this.interpreter.removeMentions(y.getTerm());
            }
            if (z.isIndividual()) {
                this.runRules |= this.interpreter.rete.processIndividual((Individual)z);
            }
        }
        this.merging = false;
    }

    public void restore(Branch branch) {
        super.restore(branch);
        this.restoreRules(branch);
    }

    public void restoreLocal(Individual ind, Branch branch) {
        super.restoreLocal(ind, branch);
        this.restoreRules(branch);
    }

    private void restoreRules(Branch branch) {
        int total = 0;
        Iterator<Map.Entry<Pair<Rule, VariableBinding>, Integer>> ruleAppIter = this.rulesApplied.entrySet().iterator();
        while (ruleAppIter.hasNext()) {
            Map.Entry<Pair<Rule, VariableBinding>, Integer> ruleBranchEntry = ruleAppIter.next();
            if (ruleBranchEntry.getValue() <= branch.getBranch()) continue;
            ruleAppIter.remove();
            this.runRules = true;
            ++total;
        }
        Iterator<Map.Entry<Fact, Integer>> iter = this.partialBindings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Fact, Integer> entry = iter.next();
            if (entry.getValue() <= branch.getBranch()) continue;
            iter.remove();
            this.runRules = true;
        }
        this.runRules |= this.interpreter.restore(branch.getBranch());
    }
}

