/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import java.util.Collection;
import java.util.Collections;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRangeBindingHelper
implements BindingHelper {
    private DataRangeAtom atom;
    private boolean hasNext;

    public DataRangeBindingHelper(DataRangeAtom atom) {
        this.atom = atom;
        this.hasNext = false;
    }

    public Collection<AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
        return Collections.emptySet();
    }

    public Collection<AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
        return VariableUtils.getVars(this.atom);
    }

    @Override
    public void rebind(VariableBinding newBinding) {
        Literal dValue = newBinding.get((AtomDObject)this.atom.getArgument());
        if (dValue == null) {
            throw new InternalReasonerException("DataRangeBindingHelper cannot generate bindings for " + this.atom);
        }
        this.hasNext = ((Datatype)this.atom.getPredicate()).contains(dValue.getValue());
    }

    @Override
    public boolean selectNextBinding() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void setCurrentBinding(VariableBinding currentBinding) {
    }

    public String toString() {
        return this.atom.toString();
    }
}

