/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.utils.ATermUtils;

public class RuleAtomAsserter
implements RuleAtomVisitor {
    private ABox abox;
    private CompletionStrategy strategy;
    private VariableBinding binding;
    private DependencySet ds;
    private boolean negated;
    private boolean asserted;

    public RuleAtomAsserter(ABox abox, CompletionStrategy strategy) {
        this.strategy = strategy;
        this.abox = abox;
    }

    public boolean assertAtom(RuleAtom atom, VariableBinding binding, DependencySet ds, boolean negated) {
        this.asserted = true;
        this.binding = binding;
        this.ds = ds;
        this.negated = negated;
        atom.accept(this);
        return this.asserted;
    }

    public void visit(BuiltInAtom atom) {
        this.asserted = false;
    }

    public void visit(ClassAtom atom) {
        ATermAppl cls = (ATermAppl)atom.getPredicate();
        ATermAppl ind = this.binding.get((AtomIObject)atom.getArgument()).getName();
        this.addType(ind, cls);
    }

    private void addType(ATermAppl ind, ATermAppl cls) {
        Individual node = this.abox.getIndividual((ATerm)ind).getSame();
        if (this.negated) {
            cls = ATermUtils.negate((ATermAppl)cls);
        }
        this.strategy.addType((Node)node, cls, this.ds);
    }

    private void addEdge(ATermAppl p, ATermAppl s, ATermAppl o) {
        Individual node1 = this.abox.getIndividual((ATerm)s).getSame();
        if (this.negated) {
            ATermAppl cls = TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.value((ATermAppl)o)));
            this.strategy.addType((Node)node1, cls, this.ds);
        } else {
            Node node2 = this.abox.getNode((ATerm)o).getSame();
            this.strategy.addEdge(node1, this.abox.getRole((ATerm)p), node2, this.ds);
        }
    }

    public void visit(DataRangeAtom atom) {
        this.asserted = false;
    }

    public void visit(DatavaluedPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl o = this.binding.get((AtomDObject)atom.getArgument2()).getName();
        this.addEdge(p, s, o);
    }

    public void visit(DifferentIndividualsAtom atom) {
        ATermAppl ind1 = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl ind2 = this.binding.get((AtomIObject)atom.getArgument2()).getName();
        ATermAppl cls = TermFactory.value((ATermAppl)ind2);
        this.addType(ind1, cls);
    }

    public void visit(IndividualPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl o = this.binding.get((AtomIObject)atom.getArgument2()).getName();
        this.addEdge(p, s, o);
    }

    public void visit(SameIndividualAtom atom) {
        ATermAppl ind1 = this.binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl ind2 = this.binding.get((AtomIObject)atom.getArgument2()).getName();
        ATermAppl cls = TermFactory.not((ATermAppl)TermFactory.value((ATermAppl)ind2));
        this.addType(ind1, cls);
    }
}

