/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.builtins.BinaryTester;
import com.clarkparsia.pellet.rules.builtins.NumericComparisonVisitor;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import com.clarkparsia.pellet.rules.builtins.Tester;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.utils.ATermUtils;

public class ComparisonTesters {
    public static final Tester equal = new EqualityTester(false);
    public static final Tester greaterThan = new OrderingTester(false, false);
    public static final Tester greaterThanOrEqual = new OrderingTester(false, true);
    public static final Tester lessThan = new OrderingTester(true, false);
    public static final Tester lessThanOrEqual = new OrderingTester(true, true);
    public static final Tester notEqual = new EqualityTester(true);

    public static Literal expectedIfEquals(Literal expected, Literal result) {
        if (expected == null) {
            return result;
        }
        if (equal.test(new Literal[]{expected, result})) {
            return expected;
        }
        return null;
    }

    private static class OrderingTester
    extends BinaryTester {
        private boolean lt;
        private boolean inclusive;

        private OrderingTester(boolean flip, boolean inclusive) {
            this.lt = flip;
            this.inclusive = inclusive;
        }

        private boolean comparesWell(int comparison) {
            if (this.lt && comparison < 0) {
                return true;
            }
            if (!this.lt && comparison > 0) {
                return true;
            }
            return this.inclusive && comparison == 0;
        }

        public boolean test(Literal l1, Literal l2) {
            BaseXSDAtomicType l2atomic;
            Object l1val = l1.getValue();
            Object l2val = l2.getValue();
            if (l1val instanceof ATermAppl && l2val instanceof ATermAppl) {
                ATermAppl l1term = (ATermAppl)l1val;
                ATermAppl l2term = (ATermAppl)l2val;
                String l1str = ATermUtils.getLiteralValue((ATermAppl)l1term);
                String l2str = ATermUtils.getLiteralValue((ATermAppl)l2term);
                String l1lang = ATermUtils.getLiteralLang((ATermAppl)l1term);
                String l2lang = ATermUtils.getLiteralLang((ATermAppl)l2term);
                String l1data = ATermUtils.getLiteralDatatype((ATermAppl)l1term);
                String l2data = ATermUtils.getLiteralDatatype((ATermAppl)l2term);
                if (l1lang.equals(l2lang) && l1data.equals(l2data)) {
                    return this.comparesWell(l1str.compareTo(l2str));
                }
                return false;
            }
            if (l1val instanceof Number && l2val instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number l1num = (Number)l1val;
                Number l2num = (Number)l2val;
                promoter.promote(l1num, l2num);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                promoter.accept(visitor);
                return this.comparesWell(visitor.getComparison());
            }
            Datatype l2type = l2.getABox().getDatatypeReasoner().getDatatype(l2.getDatatypeURI());
            if (l2type instanceof BaseXSDAtomicType && (l2atomic = (BaseXSDAtomicType)l2type).getPrimitiveType().contains(l1.getValue())) {
                ValueSpace space = l2atomic.getValueSpace();
                int comp = space.compare(l1.getValue(), l2.getValue());
                return this.comparesWell(comp);
            }
            return false;
        }
    }

    private static class EqualityTester
    extends BinaryTester {
        private boolean flip;

        private EqualityTester(boolean flip) {
            this.flip = flip;
        }

        protected boolean test(Literal a, Literal b) {
            Object aval = a.getValue();
            Object bval = b.getValue();
            if (aval instanceof Number && bval instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number anum = (Number)aval;
                Number bnum = (Number)bval;
                promoter.promote(anum, bnum);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                promoter.accept(visitor);
                if (visitor.getComparison() == 0) {
                    return true ^ this.flip;
                }
                return false ^ this.flip;
            }
            if (a.getValue() != null && b.getValue() != null) {
                return (aval.getClass().equals(bval.getClass()) && aval.equals(bval)) ^ this.flip;
            }
            return false;
        }
    }
}

