/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.rules.builtins.StringFunctionAdapter;
import com.clarkparsia.pellet.rules.builtins.StringToStringFunction;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.TimeZone;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;
import org.relaxng.datatype.DatatypeException;

public class DateTimeOperators {
    public static final GeneralFunction date = new Date();
    public static final GeneralFunction dateTime = new DateTime();
    public static final Function dayTimeDuration = new StringFunctionAdapter(new Duration(Duration.DURATIONTYPE.DAYTIME), "http://www.w3.org/2001/XMLSchema#duration");
    public static final GeneralFunction time = new Time();
    public static final Function yearMonthDuration = new StringFunctionAdapter(new Duration(Duration.DURATIONTYPE.YEARMONTH), "http://www.w3.org/2001/XMLSchema#duration");

    private static boolean applicability(int minargs, int maxargs, boolean[] boundPositions) {
        if (boundPositions.length < minargs || boundPositions.length > maxargs) {
            return false;
        }
        if (boundPositions[0]) {
            return true;
        }
        for (int i = 1; i < boundPositions.length; ++i) {
            if (boundPositions[i]) continue;
            return false;
        }
        return true;
    }

    private static Literal[] argList(Literal[] literals) {
        Literal[] args = new Literal[literals.length - 1];
        for (int i = 1; i < literals.length; ++i) {
            args[i - 1] = literals[i];
        }
        return args;
    }

    private static boolean checkValue(String val, String name) {
        try {
            XSDatatype dt = DatatypeFactory.getTypeByName((String)name);
            dt.checkValid(val, null);
        }
        catch (DatatypeException e) {
            ABox.log.info("Failed to create time: " + (Object)((Object)e));
            return false;
        }
        return true;
    }

    private static Literal createDecimal(ABox abox, Number val) {
        ATermAppl term = ATermUtils.makeTypedLiteral((String)val.toString(), (String)"http://www.w3.org/2001/XMLSchema#decimal");
        return abox.addLiteral(term);
    }

    private static Literal createInteger(ABox abox, Number val) {
        ATermAppl term = ATermUtils.makeTypedLiteral((String)val.toString(), (String)"http://www.w3.org/2001/XMLSchema#integer");
        return abox.addLiteral(term);
    }

    private static boolean mergeResults(Literal[] args1, Literal[] args2) {
        for (int i = 0; i < args1.length; ++i) {
            if (args1[i] == null) {
                if (args2[i] == null) {
                    return false;
                }
                args1[i] = args2[i];
                continue;
            }
            if (args2[i] == null || ComparisonTesters.equal.test(new Literal[]{args1[i], args2[i]})) continue;
            return false;
        }
        return true;
    }

    private static String pad(int p, String s) {
        while (s.length() < p) {
            s = "0" + s;
        }
        return s;
    }

    private static boolean restBound(Literal[] args) {
        for (int i = 1; i < args.length; ++i) {
            if (args[i] != null) continue;
            return false;
        }
        return true;
    }

    private static String toDate(String year, String month, String day) {
        return DateTimeOperators.pad(4, year) + "-" + DateTimeOperators.pad(2, month) + "-" + DateTimeOperators.pad(2, day);
    }

    private static String toTime(String hour, String minute, String second) {
        String millis = "";
        int point = second.indexOf(46);
        if (point >= 0) {
            millis = second.substring(point);
            second = second.substring(0, point);
        }
        return DateTimeOperators.pad(2, hour) + ":" + DateTimeOperators.pad(2, minute) + ":" + DateTimeOperators.pad(2, second) + millis;
    }

    private static String toTZ(TimeZone tz) {
        if (tz.minutes == 0) {
            return "Z";
        }
        String prefix = tz.minutes < 0 ? "-" : "+";
        int hours = Math.abs(tz.minutes) / 60;
        int minutes = Math.abs(tz.minutes) % 60;
        return prefix + DateTimeOperators.pad(2, "" + hours) + ":" + DateTimeOperators.pad(2, "" + minutes);
    }

    private static class Time
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#time");

        private Time() {
        }

        public boolean apply(ABox abox, Literal[] args) {
            if (DateTimeOperators.restBound(args)) {
                Literal result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args));
                if (result != null) {
                    if (args[0] == null) {
                        args[0] = result;
                    }
                    return true;
                }
                return false;
            }
            if (args[0].getValue() instanceof IDateTimeValueType) {
                BigDateTimeValueType value = ((IDateTimeValueType)args[0].getValue()).getBigValue();
                Literal[] results = new Literal[5];
                results[0] = args[0];
                results[1] = DateTimeOperators.createInteger(abox, value.getHour());
                results[2] = DateTimeOperators.createInteger(abox, value.getMinute());
                results[3] = DateTimeOperators.createDecimal(abox, value.getSecond());
                if (value.getTimeZone() != null) {
                    results[4] = abox.addLiteral(ATermUtils.makePlainLiteral((String)DateTimeOperators.toTZ(value.getTimeZone())));
                }
                if (DateTimeOperators.mergeResults(args, results)) {
                    return true;
                }
            }
            return false;
        }

        public String apply(String ... args) {
            String timeString;
            if (args.length < 3 || args.length > 4) {
                return null;
            }
            String tz = "";
            if (args.length == 4) {
                tz = args[3];
            }
            if (!DateTimeOperators.checkValue(timeString = DateTimeOperators.toTime(args[0], args[1], args[2]) + tz, "time")) {
                return null;
            }
            return timeString;
        }

        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(4, 5, boundPositions);
        }
    }

    private static class Duration
    implements GeneralFunction,
    StringToStringFunction {
        private static final BigTimeDurationValueType DURATION_ZERO = BigTimeDurationValueType.fromMinutes((int)0);
        private static final char[] SEP = new char[]{'Y', 'M', 'D', 'H', 'M', 'S'};
        private static final BigDateTimeValueType TIME_ZERO = new BigDateTimeValueType(new BigInteger("1970"), 0, 0, 0, 0, new BigDecimal(0), TimeZone.GMT);
        private StringFunctionAdapter allBound;
        private DURATIONTYPE granularity;

        public Duration(DURATIONTYPE dur) {
            this.granularity = dur;
            this.allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#duration");
        }

        public boolean apply(ABox abox, Literal[] args) {
            if (DateTimeOperators.restBound(args)) {
                Literal result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args));
                if (result != null) {
                    if (args[0] == null) {
                        args[0] = result;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        public String apply(String ... args) {
            StringBuffer result;
            if (args.length > SEP.length + this.granularity.start) {
                return null;
            }
            if (args[0].charAt(0) != '-') {
                result = new StringBuffer("P");
            } else {
                result = new StringBuffer("-P");
                args[0] = args[0].substring(1);
            }
            boolean seenTime = false;
            int i = this.granularity.start;
            for (String arg : args) {
                if (arg.length() > 0) {
                    if (i > 2 && !seenTime) {
                        seenTime = true;
                        result.append('T');
                    }
                    result.append(arg);
                    result.append(SEP[i]);
                }
                ++i;
            }
            return result.toString();
        }

        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(4, 5, boundPositions);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DURATIONTYPE {
            FULL(0, 5),
            YEARMONTH(0, 2),
            DAYTIME(2, 5);

            private int start;
            private int end;

            private DURATIONTYPE(int start, int end) {
                this.start = start;
                this.end = end;
            }
        }
    }

    private static class DateTime
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#dateTime");

        private DateTime() {
        }

        public boolean apply(ABox abox, Literal[] args) {
            if (DateTimeOperators.restBound(args)) {
                Literal result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args));
                if (result != null) {
                    if (args[0] == null) {
                        args[0] = result;
                    }
                    return true;
                }
                return false;
            }
            if (args[0].getValue() instanceof IDateTimeValueType) {
                BigDateTimeValueType value = ((IDateTimeValueType)args[0].getValue()).getBigValue();
                Literal[] results = new Literal[8];
                results[0] = args[0];
                results[1] = DateTimeOperators.createInteger(abox, value.getYear());
                results[2] = DateTimeOperators.createInteger(abox, value.getMonth() + 1);
                results[3] = DateTimeOperators.createInteger(abox, value.getDay() + 1);
                results[4] = DateTimeOperators.createInteger(abox, value.getHour());
                results[5] = DateTimeOperators.createInteger(abox, value.getMinute());
                results[6] = DateTimeOperators.createDecimal(abox, value.getSecond());
                if (value.getTimeZone() != null) {
                    results[7] = abox.addLiteral(ATermUtils.makePlainLiteral((String)DateTimeOperators.toTZ(value.getTimeZone())));
                }
                if (DateTimeOperators.mergeResults(args, results)) {
                    return true;
                }
            }
            return false;
        }

        public String apply(String ... args) {
            String dateTimeString;
            if (args.length < 6 || args.length > 7) {
                return null;
            }
            String tz = "";
            if (args.length == 7) {
                tz = args[6];
            }
            if (!DateTimeOperators.checkValue(dateTimeString = DateTimeOperators.toDate(args[0], args[1], args[2]) + "T" + DateTimeOperators.toTime(args[3], args[4], args[5]) + tz, "dateTime")) {
                return null;
            }
            return dateTimeString;
        }

        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(7, 8, boundPositions);
        }
    }

    private static class Date
    implements GeneralFunction,
    StringToStringFunction {
        StringFunctionAdapter allBound = new StringFunctionAdapter(this, "http://www.w3.org/2001/XMLSchema#date");

        private Date() {
        }

        public boolean apply(ABox abox, Literal[] args) {
            Literal result;
            if (args[0] != null && args[0].getValue() instanceof IDateTimeValueType) {
                BigDateTimeValueType value = ((IDateTimeValueType)args[0].getValue()).getBigValue();
                Literal[] results = new Literal[]{args[0], DateTimeOperators.createInteger(abox, value.getYear()), DateTimeOperators.createInteger(abox, value.getMonth() + 1), DateTimeOperators.createInteger(abox, value.getDay() + 1), value.getTimeZone() != null ? abox.addLiteral(ATermUtils.makePlainLiteral((String)DateTimeOperators.toTZ(value.getTimeZone()))) : abox.addLiteral(ATermUtils.makePlainLiteral((String)""))};
                if (DateTimeOperators.mergeResults(args, results)) {
                    return true;
                }
            } else if (DateTimeOperators.restBound(args) && (result = this.allBound.apply(abox, args[0], DateTimeOperators.argList(args))) != null) {
                if (args[0] == null) {
                    args[0] = result;
                }
                return true;
            }
            return false;
        }

        public String apply(String ... args) {
            String dateString;
            if (args.length < 3 || args.length > 4) {
                return null;
            }
            String tz = "";
            if (args.length == 4) {
                tz = args[3];
            }
            if (!DateTimeOperators.checkValue(dateString = DateTimeOperators.toDate(args[0], args[1], args[2]) + tz, "date")) {
                return null;
            }
            return dateString;
        }

        public boolean isApplicable(boolean[] boundPositions) {
            return DateTimeOperators.applicability(4, 5, boundPositions);
        }
    }
}

