/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.abstract_syntax;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.ShortFormProvider;
import org.semanticweb.owl.io.abstract_syntax.RenderingVisitor;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;

public class Renderer
implements org.semanticweb.owl.io.Renderer,
ShortFormProvider {
    private PrintWriter pw;
    private Set allURIs;
    private List shortNames;
    private Map known;
    private int reservedNames;
    private RenderingVisitor visitor;
    private String[] names = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public void setOptions(Map map) {
    }

    public Map getOptions() {
        return null;
    }

    public void renderOntology(OWLOntology ontology, Writer writer) throws RendererException {
        try {
            this.pw = new PrintWriter(writer);
            this.allURIs = OntologyHelper.allURIs((OWLOntology)ontology);
            this.visitor = new RenderingVisitor(this, ontology);
            this.generateShortNames();
            this.writeShortNames();
            this.pw.println();
            this.pw.println("Ontology( " + this.shortForm(ontology.getURI()));
            this.pw.println();
            boolean done = false;
            Iterator it = ontology.getIncludedOntologies().iterator();
            while (it.hasNext()) {
                this.pw.println(" Annotation( owl:imports " + ((OWLOntology)it.next()).getPhysicalURI() + ")");
                done = true;
            }
            if (done) {
                this.pw.println();
            }
            if (!ontology.getAnnotations(ontology).isEmpty()) {
                it = ontology.getAnnotations(ontology).iterator();
                while (it.hasNext()) {
                    OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                    this.pw.print(" Annotation(" + this.shortForm(oai.getProperty().getURI()) + " ");
                    this.renderAnnotationContent(oai.getContent());
                    this.pw.println(")");
                    this.visitor.reset();
                    oai.accept((OWLObjectVisitor)this.visitor);
                }
                done = true;
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getObjectProperties()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderObjectProperty(ontology, (OWLObjectProperty)it.next());
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getDataProperties()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderDataProperty(ontology, (OWLDataProperty)it.next());
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getClasses()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderClass(ontology, (OWLClass)it.next());
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getAnnotationProperties()).iterator();
            while (it.hasNext()) {
                OWLAnnotationProperty prop = (OWLAnnotationProperty)it.next();
                done = true;
                this.renderAnnotationProperty(ontology, prop);
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getIndividuals()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderIndividual(ontology, (OWLIndividual)it.next());
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getDatatypes()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderDataType(ontology, (OWLDataType)it.next());
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getClassAxioms()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderClassAxiom((OWLClassAxiom)it.next());
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getPropertyAxioms()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderPropertyAxiom((OWLPropertyAxiom)it.next());
            }
            if (done) {
                this.pw.println();
            }
            done = false;
            it = this.orderedEntities(ontology.getIndividualAxioms()).iterator();
            while (it.hasNext()) {
                done = true;
                this.renderIndividualAxiom((OWLIndividualAxiom)it.next());
            }
            if (done) {
                this.pw.println();
            }
            this.pw.println(")");
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    private void renderClass(OWLOntology ontology, OWLClass clazz) throws OWLException {
        OWLDescription eq;
        boolean done = false;
        Iterator it = clazz.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.println(" Class(" + this.shortForm(clazz.getURI()) + (clazz.isDeprecated(ontology) ? " Deprecated" : "") + " complete ");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  " + this.visitor.result() + ")");
            done = true;
        }
        if (!clazz.getSuperClasses(ontology).isEmpty()) {
            this.pw.println(" Class(" + this.shortForm(clazz.getURI()) + (clazz.isDeprecated(ontology) ? " Deprecated" : "") + " partial ");
            it = clazz.getSuperClasses(ontology).iterator();
            while (it.hasNext()) {
                eq = (OWLDescription)it.next();
                this.visitor.reset();
                eq.accept((OWLObjectVisitor)this.visitor);
                this.pw.print("  " + this.visitor.result());
                if (it.hasNext()) {
                    this.pw.println();
                }
                done = true;
            }
            this.pw.println(")");
        }
        it = clazz.getEnumerations(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.print(" EnumeratedClass(" + this.shortForm(clazz.getURI()) + (clazz.isDeprecated(ontology) ? " Deprecated" : ""));
            try {
                OWLEnumeration enumeration = (OWLEnumeration)eq;
                Iterator iit = enumeration.getIndividuals().iterator();
                while (iit.hasNext()) {
                    OWLIndividual desc = (OWLIndividual)iit.next();
                    this.visitor.reset();
                    desc.accept((OWLObjectVisitor)this.visitor);
                    this.pw.print(" " + this.visitor.result());
                }
                this.pw.println(")");
                done = true;
            }
            catch (ClassCastException ex) {
                throw new RendererException(ex.getMessage());
            }
        }
        if (!clazz.getAnnotations(ontology).isEmpty()) {
            this.pw.println(" Class(" + this.shortForm(clazz.getURI()) + " partial ");
            it = clazz.getAnnotations(ontology).iterator();
            while (it.hasNext()) {
                OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                this.pw.print("  annotation(" + this.shortForm(oai.getProperty().getURI()) + " ");
                this.renderAnnotationContent(oai.getContent());
                this.pw.println(")");
                this.visitor.reset();
                oai.accept((OWLObjectVisitor)this.visitor);
            }
            this.pw.println(")");
            done = true;
        }
        if (!done) {
            this.pw.println(" Class(" + this.shortForm(clazz.getURI()) + (clazz.isDeprecated(ontology) ? " Deprecated" : "") + " partial" + ")");
        }
    }

    private void renderIndividual(OWLOntology ontology, OWLIndividual ind) throws OWLException {
        Map m;
        if (ind.isAnonymous() && !(m = ind.getIncomingObjectPropertyValues(ontology)).isEmpty()) {
            return;
        }
        this.pw.print(" Individual(" + this.shortForm(ind.getURI()));
        if (ind.getAnnotations(ontology).isEmpty() && ind.getTypes(ontology).isEmpty() && ind.getObjectPropertyValues(ontology).keySet().isEmpty() && ind.getDataPropertyValues(ontology).keySet().isEmpty()) {
            this.pw.println(")");
        } else {
            Iterator it = ind.getAnnotations(ontology).iterator();
            while (it.hasNext()) {
                this.pw.println();
                OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                this.pw.print("  annotation(" + this.shortForm(oai.getProperty().getURI()) + " ");
                this.renderAnnotationContent(oai.getContent());
                this.pw.println(")");
                this.visitor.reset();
                oai.accept((OWLObjectVisitor)this.visitor);
            }
            it = ind.getTypes(ontology).iterator();
            while (it.hasNext()) {
                this.pw.println();
                OWLDescription eq = (OWLDescription)it.next();
                this.visitor.reset();
                eq.accept((OWLObjectVisitor)this.visitor);
                this.pw.print("  type(" + this.visitor.result() + ")");
            }
            Map propertyValues = ind.getObjectPropertyValues(ontology);
            Iterator it2 = propertyValues.keySet().iterator();
            while (it2.hasNext()) {
                this.pw.println();
                OWLObjectProperty prop = (OWLObjectProperty)it2.next();
                Set vals = (Set)propertyValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLIndividual oi = (OWLIndividual)valIt.next();
                    this.visitor.reset();
                    oi.accept((OWLObjectVisitor)this.visitor);
                    this.pw.print("  value(" + this.shortForm(prop.getURI()) + " " + this.visitor.result() + ")");
                    if (!valIt.hasNext()) continue;
                    this.pw.println();
                }
            }
            Map dataValues = ind.getDataPropertyValues(ontology);
            Iterator it3 = dataValues.keySet().iterator();
            while (it3.hasNext()) {
                this.pw.println();
                OWLDataProperty prop = (OWLDataProperty)it3.next();
                Set vals = (Set)dataValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLDataValue dtv = (OWLDataValue)valIt.next();
                    this.visitor.reset();
                    dtv.accept((OWLObjectVisitor)this.visitor);
                    this.pw.print("  value(" + this.shortForm(prop.getURI()) + " " + this.visitor.result() + ")");
                    if (!valIt.hasNext()) continue;
                    this.pw.println();
                }
            }
            this.pw.println(")");
        }
    }

    private void renderAnnotationProperty(OWLOntology ontology, OWLAnnotationProperty prop) throws OWLException {
        this.pw.println(" AnnotationProperty(" + this.shortForm(prop.getURI()) + ")");
    }

    private void renderObjectProperty(OWLOntology ontology, OWLObjectProperty prop) throws OWLException {
        this.pw.print(" ObjectProperty(" + this.shortForm(prop.getURI()));
        if (prop.isTransitive(ontology)) {
            this.pw.print(" Transitive");
        }
        if (prop.isFunctional(ontology)) {
            this.pw.print(" Functional");
        }
        if (prop.isInverseFunctional(ontology)) {
            this.pw.print(" InverseFunctional");
        }
        if (prop.isSymmetric(ontology)) {
            this.pw.print(" Symmetric");
        }
        Iterator it = prop.getInverses(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            OWLObjectProperty inv = (OWLObjectProperty)it.next();
            this.visitor.reset();
            inv.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  inverseOf(" + this.visitor.result() + ")");
        }
        it = prop.getSuperProperties(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            OWLObjectProperty sup = (OWLObjectProperty)it.next();
            this.visitor.reset();
            sup.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  super(" + this.visitor.result() + ")");
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            OWLDescription dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  domain(" + this.visitor.result() + ")");
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            OWLDescription ran = (OWLDescription)it.next();
            this.visitor.reset();
            ran.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  range(" + this.visitor.result() + ")");
        }
        this.pw.println(")");
    }

    private void renderDataProperty(OWLOntology ontology, OWLDataProperty prop) throws OWLException {
        this.pw.print(" DatatypeProperty(" + this.shortForm(prop.getURI()));
        if (prop.isFunctional(ontology)) {
            this.pw.print(" Functional");
        }
        Iterator it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            OWLDescription dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  domain(" + this.visitor.result() + ")");
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println();
            OWLDataRange ran = (OWLDataRange)it.next();
            this.visitor.reset();
            ran.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  range(" + this.visitor.result() + ")");
        }
        this.pw.println(")");
    }

    private void renderDataType(OWLOntology ontology, OWLDataType datatype) throws OWLException {
        this.pw.println(" Datatype(" + this.shortForm(datatype.getURI()) + ")");
    }

    private void renderClassAxiom(OWLClassAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(" " + this.visitor.result());
    }

    private void renderPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(" " + this.visitor.result());
    }

    private void renderIndividualAxiom(OWLIndividualAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(" " + this.visitor.result());
    }

    private void renderAnnotationContent(Object o) throws OWLException {
        if (o instanceof URI) {
            this.pw.print(o.toString());
        } else if (o instanceof OWLIndividual) {
            this.pw.print(((OWLIndividual)o).getURI().toString());
        } else if (o instanceof OWLDataValue) {
            OWLDataValue dv = (OWLDataValue)o;
            this.pw.print("\"" + Renderer.escape(dv.getValue()) + "\"");
            URI dvdt = dv.getURI();
            String dvlang = dv.getLang();
            if (dvdt != null) {
                this.pw.print("^^" + dvdt);
            } else if (dvlang != null) {
                this.pw.print("@" + dvlang);
            }
        } else {
            this.pw.print(o.toString());
        }
    }

    public static String escape(Object o) {
        StringBuffer sw = new StringBuffer();
        String str = o.toString();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\"' && c != '\\') {
                sw.append(c);
                continue;
            }
            sw.append('\\');
            sw.append(c);
        }
        return sw.toString();
    }

    private void generateShortNames() {
        this.shortNames = new ArrayList();
        this.known = new HashMap();
        this.known.put("http://www.w3.org/2002/07/owl#", "owl");
        this.known.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.known.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        this.known.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        Iterator it = this.allURIs.iterator();
        while (it.hasNext()) {
            try {
                URI uri = (URI)it.next();
                if (uri.getFragment() == null) continue;
                String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
                if (!ssp.endsWith("#")) {
                    ssp = ssp + "#";
                }
                if (this.known.keySet().contains(ssp) || this.shortNames.contains(ssp)) continue;
                this.shortNames.add(ssp);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    private void writeShortNames() {
        String ns;
        Iterator it = this.known.keySet().iterator();
        while (it.hasNext()) {
            ns = (String)it.next();
            String shrt = (String)this.known.get(ns);
            this.pw.println("Namespace(" + shrt + "\t= <" + ns + ">)");
        }
        for (int i = 0; i < this.shortNames.size(); ++i) {
            if (i >= this.names.length) continue;
            ns = (String)this.shortNames.get(i);
            this.pw.println("Namespace(" + this.names[i] + "\t= <" + ns + ">)");
        }
    }

    public String shortForm(URI uri) {
        if (uri == null) {
            return "_";
        }
        try {
            if (uri.getFragment() == null || uri.getFragment().equals("")) {
                return "<" + uri.toString() + ">";
            }
            String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
            if (!ssp.endsWith("#")) {
                ssp = ssp + "#";
            }
            if (this.known.keySet().contains(ssp)) {
                return (String)this.known.get(ssp) + ":" + uri.getFragment();
            }
            if (this.shortNames.contains(ssp)) {
                String frag = uri.getFragment();
                boolean fragOk = true;
                for (int i = 0; i < frag.length(); ++i) {
                    fragOk = fragOk && (Character.isLetter(frag.charAt(i)) || Character.isDigit(frag.charAt(i)) || frag.charAt(i) == '_');
                }
                if (fragOk && this.shortNames.indexOf(ssp) < this.names.length) {
                    return this.names[this.shortNames.indexOf(ssp)] + ":" + frag;
                }
                return "<" + uri.toString() + ">";
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return "<" + uri.toString() + ">";
    }

    private SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[0]);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            Renderer renderer = new Renderer();
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, writer);
            System.out.println(((Object)writer).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

