/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.dig1_0;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.Iterator;
import org.semanticweb.owl.io.vocabulary.XMLSchemaSimpleDatatypeVocabulary;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;

public class RenderingVisitor
extends OWLObjectVisitorAdapter {
    StringWriter sw;
    PrintWriter pw;
    int level;

    public RenderingVisitor() {
        this.reset();
    }

    public String result() {
        return this.sw.toString();
    }

    public void reset() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void visit(OWLClass clazz) throws OWLException {
        this.pw.print("<catom name=\"" + clazz.getURI() + "\"/>");
    }

    public void visit(OWLIndividual ind) throws OWLException {
        if (ind.isAnonymous()) {
            this.pw.println("<individual name=\"anon-" + ind.hashCode() + "\"/>");
        } else {
            this.pw.println("<individual name=\"" + ind.getURI() + "\"/>");
        }
    }

    public void visit(OWLObjectProperty prop) throws OWLException {
        this.pw.print("<ratom name=\"" + prop.getURI() + "\"/>");
    }

    public void visit(OWLDataProperty prop) throws OWLException {
        this.pw.print("<attribute name=\"" + prop.getURI() + "\"/>");
    }

    public void visit(OWLDataValue cd) throws OWLException {
        this.pw.print(cd.getValue());
    }

    public void visit(OWLAnd and) throws OWLException {
        this.pw.print("<and>");
        Iterator it = and.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
        }
        this.pw.print("</and>");
    }

    public void visit(OWLOr or) throws OWLException {
        this.pw.print("<or>");
        Iterator it = or.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
        }
        this.pw.print("</or>");
    }

    public void visit(OWLNot not) throws OWLException {
        this.pw.print("<not>");
        OWLDescription desc = not.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.pw.print("</not>");
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        this.pw.print("<iset>");
        Iterator it = enumeration.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
        }
        this.pw.print("</iset>");
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        this.pw.print("<some>");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.print("</some>");
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        this.pw.print("<all>");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.print("</all>");
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        this.pw.print("<some>");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.print("<iset>");
        restriction.getIndividual().accept((OWLObjectVisitor)this);
        this.pw.print("</iset>");
        this.pw.print("</some>");
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        if (restriction.isExactly()) {
            this.pw.print("<and>");
            this.pw.print("<atmost num=\"" + restriction.getAtLeast() + "\">");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print("<top/>");
            this.pw.println("</atmost>");
            this.pw.print("<atleast num=\"" + restriction.getAtLeast() + "\">");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print("<top/>");
            this.pw.println("</atleast>");
            this.pw.print("</and>");
        } else if (restriction.isAtMost()) {
            this.pw.print("<atmost num=\"" + restriction.getAtMost() + "\">");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print("<top/>");
            this.pw.println("</atmost>");
        } else if (restriction.isAtLeast()) {
            this.pw.print("<atleast num=\"" + restriction.getAtLeast() + "\">");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.print("<top/>");
            this.pw.println("</atleast>");
        }
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws OWLException {
        throw new OWLException(" Data cardinality restriction. ");
    }

    public void visit(OWLDataAllRestriction node) throws OWLException {
        throw new OWLException(" Can't handle DataAll restriction\n\t" + node.getDataProperty().getURI() + " " + node.getDataType());
    }

    public void visit(OWLDataSomeRestriction node) throws OWLException {
        throw new OWLException(" Can't handle DataSome restriction\n\t" + node.getDataProperty().getURI() + " " + node.getDataType());
    }

    public void visit(OWLDataValueRestriction node) throws OWLException {
        OWLDataValue dv = node.getValue();
        URI type = dv.getURI();
        if (type == null) {
            OWLDataValue val = node.getValue();
            this.pw.print("<stringequals val=\"");
            val.accept((OWLObjectVisitor)this);
            this.pw.print("\">");
            node.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.print("</stringequals>");
        } else if (type.toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getString())) {
            OWLDataValue val = node.getValue();
            this.pw.print("<stringequals val=\"");
            val.accept((OWLObjectVisitor)this);
            this.pw.print("\">");
            node.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.print("</stringequals>");
        } else if (type.toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInteger()) || type.toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInt())) {
            OWLDataValue val = node.getValue();
            this.pw.print("<intequals val=\"");
            val.accept((OWLObjectVisitor)this);
            this.pw.print("\">");
            node.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.print("</intequals>");
        } else {
            throw new OWLException(" Can't handle DataValue restriction\n\t" + node.getDataProperty().getURI() + " " + node.getValue());
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        Object[] eqs = axiom.getEquivalentClasses().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                OWLDescription desc1 = (OWLDescription)eqs[i];
                OWLDescription desc2 = (OWLDescription)eqs[j];
                this.pw.println("<equalc>");
                desc1.accept((OWLObjectVisitor)this);
                this.pw.println();
                desc2.accept((OWLObjectVisitor)this);
                this.pw.println();
                this.pw.println("</equalc>");
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        Object[] disjs = axiom.getDisjointClasses().toArray();
        for (int i = 0; i < disjs.length; ++i) {
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLDescription desc1 = (OWLDescription)disjs[i];
                OWLDescription desc2 = (OWLDescription)disjs[j];
                this.pw.println("<disjoint>");
                desc1.accept((OWLObjectVisitor)this);
                this.pw.println();
                desc2.accept((OWLObjectVisitor)this);
                this.pw.println();
                this.pw.println("</disjoint>");
            }
        }
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        this.pw.println("<impliesc>");
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.pw.println();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</impliesc>");
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        Object[] eqs = axiom.getProperties().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                OWLProperty prop1 = (OWLProperty)eqs[i];
                OWLProperty prop2 = (OWLProperty)eqs[j];
                this.pw.println("<equalr>");
                prop1.accept((OWLObjectVisitor)this);
                this.pw.println();
                prop2.accept((OWLObjectVisitor)this);
                this.pw.println();
                this.pw.println("</equalr>");
            }
        }
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        this.pw.print("<impliesr>");
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</impliesr>");
    }

    public void visit(OWLDifferentIndividualsAxiom ax) throws OWLException {
    }

    public void visit(OWLSameIndividualsAxiom ax) throws OWLException {
    }

    public void visit(OWLDataType ocdt) throws OWLException {
    }
}

