/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.dig1_1;

import java.math.BigInteger;
import java.net.URI;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kr.dl.dig.v1_1.Concept;
import org.kr.dl.dig.v1_1.Concepts;
import org.kr.dl.dig.v1_1.Individuals;
import org.kr.dl.dig.v1_1.IntequalsDocument;
import org.kr.dl.dig.v1_1.Named;
import org.kr.dl.dig.v1_1.NumRoleConceptPair;
import org.kr.dl.dig.v1_1.RoleConceptPair;
import org.kr.dl.dig.v1_1.StringequalsDocument;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.XMLSchemaSimpleDatatypeVocabulary;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFrame;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOr;
import uk.ac.man.cs.img.owl.io.dig1_1.ConceptRenderingVisitor;
import uk.ac.man.cs.img.owl.io.dig1_1.ConceptsRenderingVisitor;
import uk.ac.man.cs.img.owl.io.dig1_1.NotExpressableInDIGException;
import uk.ac.man.cs.img.owl.io.dig1_1.RoleConceptPairRenderingVisitor;

public abstract class AbstractDescriptionRenderingVisitor
implements OWLDescriptionVisitor {
    public static final Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$io$dig1_1$AbstractDescriptionRenderingVisitor == null ? (class$uk$ac$man$cs$img$owl$io$dig1_1$AbstractDescriptionRenderingVisitor = AbstractDescriptionRenderingVisitor.class$("uk.ac.man.cs.img.owl.io.dig1_1.AbstractDescriptionRenderingVisitor")) : class$uk$ac$man$cs$img$owl$io$dig1_1$AbstractDescriptionRenderingVisitor));
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$io$dig1_1$AbstractDescriptionRenderingVisitor;

    public void visit(OWLClass owlClass) throws OWLException {
        String className;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLClass owlClass = " + owlClass + ") - start"));
        }
        if ((className = owlClass.getURI().toString()).equals(OWLVocabularyAdapter.INSTANCE.getThing())) {
            this.addNewTop();
            return;
        }
        if (className.equals(OWLVocabularyAdapter.INSTANCE.getNothing())) {
            this.addNewBottom();
            return;
        }
        Named catom = this.addNewCatom();
        catom.setName(className);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLClass) - end");
        }
    }

    public void visit(OWLAnd owlAnd) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLAnd owlAnd = " + owlAnd + ") - start"));
        }
        Concepts andConcept = this.addNewAnd();
        ConceptsRenderingVisitor v = new ConceptsRenderingVisitor(andConcept);
        Iterator it = owlAnd.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLDescriptionVisitor)v);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLAnd) - end");
        }
    }

    public void visit(OWLOr owlOr) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLOr or = " + owlOr + ") - start"));
        }
        Concepts orConcept = this.addNewOr();
        ConceptsRenderingVisitor v = new ConceptsRenderingVisitor(orConcept);
        Iterator it = owlOr.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLDescriptionVisitor)v);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLOr) - end");
        }
    }

    public void visit(OWLNot owlNot) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLNot not = " + owlNot + ") - start"));
        }
        Concept notConcept = this.addNewNot();
        ConceptRenderingVisitor v = new ConceptRenderingVisitor(notConcept);
        OWLDescription desc = owlNot.getOperand();
        desc.accept((OWLDescriptionVisitor)v);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLNot) - end");
        }
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLEnumeration enumeration = " + enumeration + ") - start"));
        }
        Individuals individuals = this.addNewIset();
        Iterator it = enumeration.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual indiv = (OWLIndividual)it.next();
            individuals.addNewIndividual().setName(indiv.toString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLEnumeration) - end");
        }
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLObjectSomeRestriction restriction = " + restriction + ") - start"));
        }
        RoleConceptPair roleConceptPair = this.addNewSome();
        roleConceptPair.addNewRatom().setName(restriction.getObjectProperty().getURI().toString());
        restriction.getDescription().accept((OWLDescriptionVisitor)new RoleConceptPairRenderingVisitor(roleConceptPair));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLObjectSomeRestriction) - end");
        }
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLObjectAllRestriction restriction = " + restriction + ") - start"));
        }
        RoleConceptPair roleConceptPair = this.addNewAll();
        roleConceptPair.addNewRatom().setName(restriction.getObjectProperty().getURI().toString());
        RoleConceptPairRenderingVisitor v = new RoleConceptPairRenderingVisitor(roleConceptPair);
        restriction.getDescription().accept((OWLDescriptionVisitor)v);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLObjectAllRestriction) - end");
        }
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLObjectValueRestriction restriction = " + restriction + ") - start"));
        }
        RoleConceptPair roleConceptPair = this.addNewSome();
        roleConceptPair.addNewRatom().setName(restriction.getObjectProperty().getURI().toString());
        roleConceptPair.addNewIset().addNewIndividual().setName(restriction.getIndividual().getURI().toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLObjectValueRestriction) - end");
        }
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("visit(OWLObjectCardinalityRestriction restriction = " + restriction + ") - start"));
        }
        if (restriction.isExactly()) {
            Concepts concepts = this.addNewAnd();
            NumRoleConceptPair numRoleConceptPair = concepts.addNewAtmost();
            this.addAtMost(restriction, numRoleConceptPair);
            numRoleConceptPair = concepts.addNewAtleast();
            this.addAtLeast(restriction, numRoleConceptPair);
        } else if (restriction.isAtMost()) {
            NumRoleConceptPair numRoleConceptPair = this.addNewAtmost();
            this.addAtMost(restriction, numRoleConceptPair);
        } else if (restriction.isAtLeast()) {
            NumRoleConceptPair numRoleConceptPair = this.addNewAtleast();
            this.addAtLeast(restriction, numRoleConceptPair);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"visit(OWLObjectCardinalityRestriction) - end");
        }
    }

    protected void addAtLeast(OWLObjectCardinalityRestriction restriction, NumRoleConceptPair numRoleConceptPair) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addAtLeast(OWLObjectCardinalityRestriction restriction = " + restriction + ", NumRoleConceptPair numRoleConceptPair = " + numRoleConceptPair + ") - start"));
        }
        int atLeast = restriction.getAtLeast();
        numRoleConceptPair.setNum(BigInteger.valueOf(atLeast));
        numRoleConceptPair.addNewRatom().setName(restriction.getObjectProperty().getURI().toString());
        numRoleConceptPair.addNewTop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"addAtLeast(OWLObjectCardinalityRestriction, NumRoleConceptPair) - end");
        }
    }

    protected void addAtMost(OWLObjectCardinalityRestriction restriction, NumRoleConceptPair numRoleConceptPair) throws OWLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addAtMost(OWLObjectCardinalityRestriction restriction = " + restriction + ", NumRoleConceptPair numRoleConceptPair = " + numRoleConceptPair + ") - start"));
        }
        int atMost = restriction.getAtMost();
        numRoleConceptPair.setNum(BigInteger.valueOf(atMost));
        numRoleConceptPair.addNewRatom().setName(restriction.getObjectProperty().getURI().toString());
        numRoleConceptPair.addNewTop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"addAtMost(OWLObjectCardinalityRestriction, NumRoleConceptPair) - end");
        }
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws NotExpressableInDIGException {
        throw new NotExpressableInDIGException("Can't handle Data cardinality restriction. ");
    }

    public void visit(OWLDataAllRestriction node) throws NotExpressableInDIGException, OWLException {
        throw new NotExpressableInDIGException("Can't handle DataAll restriction\n\t" + node.getDataProperty().getURI() + " " + node.getDataType());
    }

    public void visit(OWLDataSomeRestriction node) throws NotExpressableInDIGException, OWLException {
        throw new NotExpressableInDIGException("Can't handle DataSome restriction\n\t" + node.getDataProperty().getURI() + " " + node.getDataType());
    }

    public void visit(OWLDataValueRestriction node) throws NotExpressableInDIGException, OWLException {
        URI type = node.getValue().getURI();
        if (type == null) {
            this.stringEquals(node);
        } else if (type.toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getString())) {
            this.stringEquals(node);
        } else if (type.toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInteger()) || type.toString().equals(XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getInt())) {
            IntequalsDocument.Intequals intequals = this.addNewIntequals();
            intequals.addNewAttribute().setName(node.getDataProperty().getURI().toString());
            intequals.setVal(new BigInteger(node.getValue().getValue().toString()));
        } else {
            throw new NotExpressableInDIGException(" Can't handle DataValue restriction\n\t" + node.getDataProperty().getURI() + " " + node.getValue());
        }
    }

    void stringEquals(OWLDataValueRestriction node) throws OWLException {
        StringequalsDocument.Stringequals stringequals = this.addNewStringequals();
        stringequals.addNewAttribute().setName(node.getDataProperty().getURI().toString());
        stringequals.setVal(node.getValue().getValue().toString());
    }

    public void visit(OWLFrame node) throws NotExpressableInDIGException {
        throw new NotExpressableInDIGException("Can't handle OWLFrames");
    }

    public abstract XmlObject addNewTop();

    public abstract XmlObject addNewBottom();

    public abstract Named addNewCatom();

    public abstract Concepts addNewAnd();

    public abstract Concepts addNewOr();

    public abstract Concept addNewNot();

    public abstract Individuals addNewIset();

    public abstract RoleConceptPair addNewSome();

    public abstract RoleConceptPair addNewAll();

    public abstract NumRoleConceptPair addNewAtmost();

    public abstract NumRoleConceptPair addNewAtleast();

    public abstract StringequalsDocument.Stringequals addNewStringequals();

    public abstract IntequalsDocument.Intequals addNewIntequals();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

