/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.tptp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import uk.ac.man.cs.img.owl.io.tptp.Renderer;

public class RenderingVisitor
extends OWLObjectVisitorAdapter {
    public static int MAXCARDINALITYHANDLED = 257;
    Renderer renderer;
    StringWriter sw;
    PrintWriter pw;
    int level;
    boolean indenting = true;
    String var;
    Set boundVariables;
    private String[] variables = new String[]{"X", "Y", "Z", "W", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V"};

    public RenderingVisitor(Renderer renderer, String v, Set boundVars) {
        this.renderer = renderer;
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.var = v;
        this.boundVariables = new HashSet(boundVars);
        this.boundVariables.add(v);
    }

    public String result() {
        return this.sw.toString();
    }

    public void visit(OWLClass clazz) throws OWLException {
        this.pw.print(this.renderer.shortForm((OWLNamedObject)clazz) + "(" + this.var + ")");
    }

    public void visit(OWLIndividual ind) throws OWLException {
        this.pw.print(this.renderer.shortForm((OWLNamedObject)ind));
    }

    public void visit(OWLObjectProperty prop) throws OWLException {
        this.pw.print(this.renderer.shortForm((OWLNamedObject)prop));
    }

    public void visit(OWLDataProperty prop) throws OWLException {
        this.pw.print(this.renderer.shortForm((OWLNamedObject)prop));
    }

    public void visit(OWLDataValue cd) throws OWLException {
        throw new RendererException("DataValue encountered....");
    }

    public void visit(OWLAnd and) throws OWLException {
        this.pw.print("(");
        Iterator it = and.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" & ");
        }
        this.pw.print(")");
    }

    public void visit(OWLOr or) throws OWLException {
        this.pw.print("(");
        Iterator it = or.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.pw.print(" | ");
        }
        this.pw.print(")");
    }

    public void visit(OWLNot not) throws OWLException {
        this.pw.print("(abstractDomain(" + this.var + ") & ");
        this.pw.print("(~(");
        OWLDescription desc = not.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.pw.print("))");
        this.pw.print(")");
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        if (enumeration.getIndividuals().isEmpty()) {
            this.pw.print("(cowlNothing(" + this.var + "))");
        } else {
            this.pw.print("(");
            Iterator it = enumeration.getIndividuals().iterator();
            while (it.hasNext()) {
                OWLIndividual ind = (OWLIndividual)it.next();
                this.pw.print("equal(" + this.var + "," + this.renderer.shortForm((OWLNamedObject)ind) + ")");
                if (!it.hasNext()) continue;
                this.pw.print(" | ");
            }
            this.pw.print(")");
        }
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        String newVar = this.getNewUnboundVar();
        this.pw.print("(?[" + newVar + "]: (");
        this.pw.print(this.renderer.shortForm((OWLNamedObject)restriction.getObjectProperty()));
        this.pw.print("(" + this.var + "," + newVar + ") & ");
        HashSet s = new HashSet(this.boundVariables);
        RenderingVisitor rv = new RenderingVisitor(this.renderer, newVar, s);
        restriction.getDescription().accept((OWLObjectVisitor)rv);
        this.pw.print(rv.result() + ")");
        this.pw.print(")");
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        String newVar = this.getNewUnboundVar();
        this.pw.print("(abstractDomain(" + this.var + ") & ");
        this.pw.print("(![" + newVar + "]: (");
        this.pw.print(this.renderer.shortForm((OWLNamedObject)restriction.getObjectProperty()));
        this.pw.print("(" + this.var + "," + newVar + ") => ");
        HashSet s = new HashSet(this.boundVariables);
        RenderingVisitor rv = new RenderingVisitor(this.renderer, newVar, s);
        restriction.getDescription().accept((OWLObjectVisitor)rv);
        this.pw.print(rv.result() + ")");
        this.pw.print(")");
        this.pw.print(")");
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        this.pw.print("(" + this.renderer.shortForm((OWLNamedObject)restriction.getObjectProperty()) + "(" + this.var + ",");
        this.pw.print(this.renderer.shortForm((OWLNamedObject)restriction.getIndividual()));
        this.pw.print("))");
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        int min = -1;
        int max = -1;
        if (restriction.isExactly()) {
            min = restriction.getAtLeast();
            max = restriction.getAtMost();
        } else if (restriction.isAtMost()) {
            max = restriction.getAtMost();
        } else if (restriction.isAtLeast()) {
            min = restriction.getAtLeast();
        }
        this.doCardinality((OWLProperty)restriction.getObjectProperty(), min, max);
    }

    public void visit(OWLDataSomeRestriction restriction) throws OWLException {
        String newVar = this.getNewUnboundVar();
        this.pw.print("(?[" + newVar + "]: (");
        this.pw.print(this.renderer.shortForm((OWLNamedObject)restriction.getDataProperty()));
        this.pw.print("(" + this.var + "," + newVar + ") & ");
        HashSet s = new HashSet(this.boundVariables);
        RenderingVisitor rv = new RenderingVisitor(this.renderer, newVar, s);
        restriction.getDataType().accept((OWLObjectVisitor)rv);
        this.pw.print(rv.result() + ")");
        this.pw.print(")");
    }

    public void visit(OWLDataAllRestriction restriction) throws OWLException {
        String newVar = this.getNewUnboundVar();
        this.pw.print("(abstractDomain(" + this.var + ") & ");
        this.pw.print("(![" + newVar + "]: (");
        this.pw.print(this.renderer.shortForm((OWLNamedObject)restriction.getDataProperty()));
        this.pw.print("(" + this.var + "," + newVar + ") => ");
        HashSet s = new HashSet(this.boundVariables);
        RenderingVisitor rv = new RenderingVisitor(this.renderer, newVar, s);
        restriction.getDataType().accept((OWLObjectVisitor)rv);
        this.pw.print(rv.result() + ")");
        this.pw.print(")");
        this.pw.print(")");
    }

    private void doCardinality(OWLProperty prop, int min, int max) throws OWLException {
        int j;
        int i;
        String newVar;
        if (min > MAXCARDINALITYHANDLED) {
            this.renderer.cardinalityException("Cardinality with min " + min + " encountered.");
        }
        if (max > MAXCARDINALITYHANDLED) {
            this.renderer.cardinalityException("Cardinality with max " + max + " encountered.");
        }
        this.pw.print("(");
        if (min > 0) {
            newVar = this.getNewUnboundVar();
            this.pw.print("(?[");
            for (i = 0; i < min; ++i) {
                if (i > 0) {
                    this.pw.print(",");
                }
                this.pw.print(newVar + this.intToString(i));
            }
            this.pw.print("]:(");
            for (i = 0; i < min; ++i) {
                if (i > 0) {
                    this.pw.print(" & ");
                }
                this.pw.print(this.renderer.shortForm((OWLNamedObject)prop) + "(" + this.var + "," + newVar + this.intToString(i) + ")");
            }
            for (i = 0; i < min; ++i) {
                for (j = i + 1; j < min; ++j) {
                    if (i < min && j < min) {
                        this.pw.print(" & ");
                    }
                    this.pw.print("~equal(" + newVar + this.intToString(i) + "," + newVar + this.intToString(j) + ")");
                }
            }
            this.pw.print("))");
        }
        if (max > -1) {
            if (min > 0) {
                this.pw.print(" & ");
            }
            this.pw.print("(abstractDomain(" + this.var + ") & ");
            if (max == 0) {
                newVar = this.getNewUnboundVar();
                this.pw.print("(~(?[" + newVar + "]:(" + this.renderer.shortForm((OWLNamedObject)prop) + "(" + this.var + "," + newVar + "))))");
            } else {
                newVar = this.getNewUnboundVar();
                this.pw.print("(![");
                for (i = 0; i < max + 1; ++i) {
                    if (i > 0) {
                        this.pw.print(",");
                    }
                    this.pw.print(newVar + this.intToString(i));
                }
                this.pw.print("]:((");
                for (i = 0; i < max + 1; ++i) {
                    if (i > 0) {
                        this.pw.print(" & ");
                    }
                    this.pw.print(this.renderer.shortForm((OWLNamedObject)prop) + "(" + this.var + "," + newVar + this.intToString(i) + ")");
                }
                this.pw.print(") => (");
                for (i = 0; i < max + 1; ++i) {
                    for (j = i + 1; j < max + 1; ++j) {
                        this.pw.print("equal(" + newVar + this.intToString(i) + "," + newVar + this.intToString(j) + ")");
                        if (i == max - 1 && j == max) continue;
                        this.pw.print(" | ");
                    }
                }
                this.pw.print(")))");
            }
            this.pw.print(")");
        }
        this.pw.print(")");
    }

    private String intToString(int i) {
        String s = Integer.toString(i);
        return s;
    }

    public void visit(OWLDataValueRestriction restriction) throws OWLException {
        this.pw.print("(" + this.renderer.shortForm((OWLNamedObject)restriction.getDataProperty()) + "(" + this.var + ",");
        this.pw.print(this.renderer.canonicalize(restriction.getValue()));
        this.pw.print("))");
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws OWLException {
        int min = -1;
        int max = -1;
        if (restriction.isExactly()) {
            min = restriction.getAtLeast();
            max = restriction.getAtMost();
        } else if (restriction.isAtMost()) {
            max = restriction.getAtMost();
        } else if (restriction.isAtLeast()) {
            min = restriction.getAtLeast();
        }
        this.doCardinality((OWLProperty)restriction.getDataProperty(), min, max);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        throw new RendererException(" Axiom ");
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        throw new RendererException(" Axiom ");
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        throw new RendererException(" Axiom ");
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        throw new RendererException(" Axiom ");
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        throw new RendererException(" Axiom ");
    }

    public void visit(OWLDifferentIndividualsAxiom ax) throws OWLException {
        throw new RendererException(" Axiom ");
    }

    public void visit(OWLSameIndividualsAxiom ax) throws OWLException {
        throw new RendererException(" Axiom ");
    }

    public void visit(OWLDataType ocdt) throws OWLException {
        this.pw.print(this.renderer.typeFor(ocdt) + "(" + this.var + ")");
    }

    public void visit(OWLDataEnumeration enumeration) throws OWLException {
        if (enumeration.getValues().isEmpty()) {
            this.pw.print("(cowlNothing(" + this.var + "))");
        } else {
            this.pw.print("(");
            Iterator it = enumeration.getValues().iterator();
            while (it.hasNext()) {
                OWLDataValue dv = (OWLDataValue)it.next();
                this.pw.print("equal(" + this.var + "," + this.renderer.canonicalize(dv) + ")");
                if (!it.hasNext()) continue;
                this.pw.print(" | ");
            }
            this.pw.print(")");
        }
    }

    private String getNewUnboundVar() throws OWLException {
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.boundVariables.contains(this.variables[i])) continue;
            return this.variables[i];
        }
        throw new RendererException("Ran out of variables!!!");
    }
}

