/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import wsdlanalyzer.mapping.Mapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingPartList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<Mapping> mappingPartList = new ArrayList();
    private int score = 0;

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void addMapping(Mapping mapping) {
        this.score += mapping.getScore();
        this.mappingPartList.add(mapping);
    }

    public Iterator<Mapping> mappingIterator() {
        return this.mappingPartList.iterator();
    }

    public Mapping get(int arg0) {
        return this.mappingPartList.get(arg0);
    }

    public boolean isEmpty() {
        return this.mappingPartList.isEmpty();
    }

    public int size() {
        return this.mappingPartList.size();
    }

    public MappingPartList copy() {
        MappingPartList copy = new MappingPartList();
        Iterator<Mapping> mappingIterator = this.mappingPartList.iterator();
        while (mappingIterator.hasNext()) {
            copy.addMapping(mappingIterator.next());
        }
        return copy;
    }

    public Mapping getMappingForCandidate(String name) {
        if (this.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.mappingPartList.size()) {
            Mapping mapping = this.get(i).getMappingForCandidate(name);
            if (mapping != null) {
                return mapping;
            }
            ++i;
        }
        return null;
    }

    public Mapping getMappingForRequirement(String name) {
        if (this.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.mappingPartList.size()) {
            Mapping mapping = this.get(i).getMappingForRequirement(name);
            if (mapping != null) {
                return mapping;
            }
            ++i;
        }
        return null;
    }

    public void print(int i) {
        if (!this.mappingPartList.isEmpty()) {
            int j = 0;
            while (j < this.mappingPartList.size()) {
                Mapping mapping = this.mappingPartList.get(j);
                mapping.printMapping(i);
                ++j;
            }
        }
    }

    public String log(int i) {
        String mappingPartListLog = "";
        if (!this.mappingPartList.isEmpty()) {
            int j = 0;
            while (j < this.mappingPartList.size()) {
                Mapping mapping = this.mappingPartList.get(j);
                mappingPartListLog = String.valueOf(mappingPartListLog) + "\n" + mapping.log(i);
                ++j;
            }
        }
        return mappingPartListLog;
    }
}

