/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.matcher;

import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wsdlanalyzer.matcher.StopWords;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameTokens {
    HashSet<String> tokens = new HashSet();

    public NameTokens(String name, StopWords stop) {
        Pattern capitalLetter = Pattern.compile("(\\p{Lower}[\\p{Lower}\\d]+)|(\\p{Upper}{1}?[\\p{Lower}\\d]+)");
        Matcher matcher = capitalLetter.matcher(name);
        if (!matcher.find()) {
            this.tokens.add(name);
        } else {
            matcher.reset();
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                String token = matcher.group().toLowerCase();
                if (stop.contains(token) || token.length() <= 1) continue;
                this.tokens.add(token);
            }
        }
    }

    public HashSet<String> getTokens() {
        return this.tokens;
    }

    public boolean contains(Object arg0) {
        return this.tokens.contains(arg0);
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public Iterator<String> iterator() {
        return this.tokens.iterator();
    }

    public void printTokens() {
        Iterator<String> siter = this.tokens.iterator();
        while (siter.hasNext()) {
            System.out.println("name-token: " + siter.next());
        }
    }

    public int size() {
        return this.tokens.size();
    }
}

