/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.matcher;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import net.didion.jwnl.JWNLException;
import wsdlanalyzer.mapping.Mapping;
import wsdlanalyzer.matcher.FileScore;
import wsdlanalyzer.matcher.WsdlFileMatcher;
import wsdlanalyzer.parser.SimpleTypeLookupTable;
import wsdlanalyzer.parser.WsdlFileParser;
import wsdlanalyzer.types.WsdlFile;
import wsdlanalyzer.wordnet.DictInstance;

public class WsdlFileListMatcher {
    private WsdlFile candidate;
    private WsdlFile requirementsFile;
    private SimpleTypeLookupTable lookupTable;
    private String directory;
    private String requirementsFileName;
    private TreeSet<FileScore> ranking;
    private HashMap<String, Mapping> mappinglist;
    private int maxMappingScore;
    private int fileCount;
    private float pr10;
    private float pr20;
    private float pr30;
    private float aus10;
    private float aus20;
    private float aus30;
    private DictInstance dictionary;

    public WsdlFileListMatcher(String filename, String dirname, DictInstance dict, int number) {
        this.requirementsFileName = filename;
        this.directory = dirname;
        this.dictionary = dict;
        this.ranking = new TreeSet();
        this.mappinglist = new HashMap();
        this.fileCount = number;
    }

    public void match() {
        this.lookupTable = new SimpleTypeLookupTable();
        WsdlFileParser requirementsparser = new WsdlFileParser(this.requirementsFileName, this.lookupTable);
        requirementsparser.parseWsdl();
        this.requirementsFile = requirementsparser.getWsdlfile();
        try {
            WsdlFileMatcher matcher = new WsdlFileMatcher(this.requirementsFileName, this.requirementsFile, this.requirementsFileName, this.lookupTable, this.dictionary);
            matcher.setStructural();
            matcher.match();
            Mapping maxMapping = matcher.getFilemapping();
            this.maxMappingScore = maxMapping.getScore();
        }
        catch (JWNLException e) {
            e.printStackTrace();
        }
        File wsdldir = new File(this.directory);
        this.scanDirectory(wsdldir);
        this.printRanking();
    }

    public void scanDirectory(File dir) {
        File[] dirs = dir.listFiles();
        int j = 0;
        while (j < dirs.length) {
            if (dirs[j].isDirectory()) {
                this.scanDirectory(dirs[j]);
            } else if (dirs[j].getAbsolutePath().endsWith(".wsdl") || dirs[j].getAbsolutePath().endsWith(".WSDL")) {
                this.matchFile(dirs[j]);
            }
            ++j;
        }
    }

    public void matchFile(File wsdlfile) {
        String candidateFileName = wsdlfile.getAbsolutePath();
        try {
            WsdlFileMatcher matcher = new WsdlFileMatcher(this.requirementsFileName, this.requirementsFile, candidateFileName, this.lookupTable, this.dictionary);
            matcher.setStructural();
            matcher.match();
            Mapping fileMapping = matcher.getFilemapping();
            FileScore fileMatch = new FileScore(candidateFileName, fileMapping.getScore());
            fileMatch.setSimilarity((float)fileMapping.getScore() / (float)this.maxMappingScore);
            this.ranking.add(fileMatch);
            this.mappinglist.put(candidateFileName, fileMapping);
        }
        catch (JWNLException e) {
            e.printStackTrace();
        }
    }

    public Mapping getMapping(String requirementsfilename) {
        return this.mappinglist.get(requirementsfilename);
    }

    public void printRanking() {
        System.out.println("\n!!!!!!ranked matching for " + this.requirementsFileName + "!!!!!!!\n");
        int baslash = this.requirementsFileName.lastIndexOf("\\");
        String vergleich = this.requirementsFileName.substring(0, baslash);
        Iterator<FileScore> it = this.ranking.iterator();
        int rank = this.ranking.size();
        int count = -1;
        int count2 = -1;
        int count3 = -1;
        while (it.hasNext()) {
            FileScore sco = it.next();
            if (rank < 31) {
                int bslash = sco.getWsdlFile().lastIndexOf("\\");
                if (vergleich.equals(sco.getWsdlFile().substring(0, bslash))) {
                    ++count;
                }
                if (rank < 21 && vergleich.equals(sco.getWsdlFile().substring(0, bslash))) {
                    ++count3;
                }
                if (rank < 11 && vergleich.equals(sco.getWsdlFile().substring(0, bslash))) {
                    ++count2;
                }
                String hlp = sco.getWsdlFile();
                int le = hlp.length();
                int t = 0;
                while (t < 95 - le) {
                    hlp = String.valueOf(hlp) + " ";
                    ++t;
                }
                hlp = String.valueOf(hlp) + sco.getSimilarity() + ", " + sco.getScore();
                System.out.println(String.valueOf(rank) + ". " + hlp);
            }
            --rank;
        }
        this.pr10 = (float)count2 / 10.0f;
        this.pr20 = (float)count3 / 20.0f;
        this.pr30 = (float)count / 30.0f;
        this.aus10 = (float)count2 / (float)(this.fileCount - 1);
        this.aus20 = (float)count3 / (float)(this.fileCount - 1);
        this.aus30 = (float)count / (float)(this.fileCount - 1);
        System.out.println("Treffer30: " + count + "  Treffer20: " + count3 + "  Treffer10: " + count2);
        System.out.println("Pr\u00e4zisison30: " + this.pr30 + "  Pr\u00e4zisison20: " + this.pr20 + " Pr\u00e4zision10: " + this.pr10 + "  Ausbeute30: " + this.aus30 + "  Ausbeute20: " + this.aus20 + "  Ausbeute10: " + this.aus10);
    }

    public float getAus10() {
        return this.aus10;
    }

    public float getAus30() {
        return this.aus30;
    }

    public float getPr10() {
        return this.pr10;
    }

    public float getPr30() {
        return this.pr30;
    }

    public float getAus20() {
        return this.aus20;
    }

    public float getPr20() {
        return this.pr20;
    }
}

