/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.matcher;

import net.didion.jwnl.JWNLException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.commons.logging.Log;
import wsdlanalyzer.mapping.Mapping;
import wsdlanalyzer.mapping.MappingPartList;
import wsdlanalyzer.matcher.WsdlServiceMatcher;
import wsdlanalyzer.parser.SimpleTypeLookupTable;
import wsdlanalyzer.parser.WsdlFileParser;
import wsdlanalyzer.types.Service;
import wsdlanalyzer.types.ServiceList;
import wsdlanalyzer.types.WsdlFile;
import wsdlanalyzer.wordnet.DictInstance;

public class WsdlFileMatcher {
    private String requirementsFileName;
    private String candidateFileName;
    private ServiceList requirementsServices;
    private ServiceList candidateServices;
    private WsdlFile requirementsFile;
    private WsdlFile candidateFile;
    private SimpleTypeLookupTable lookupTable;
    private Mapping fileMapping;
    private boolean edit;
    private int matchStrategy;
    private int structureWeight = 1;
    private int nameWeight = 1;
    private int wordnetWeight = 1;
    private DictInstance dictionary;
    private boolean strictSequence;
    protected static Log log = LogFactory.getLog((String)WsdlFileMatcher.class.getName());

    public WsdlFileMatcher(String requirements, String candidate, DictInstance dict) {
        this.lookupTable = new SimpleTypeLookupTable();
        this.requirementsFileName = requirements;
        WsdlFileParser requirementsparser = new WsdlFileParser(this.requirementsFileName, this.lookupTable);
        requirementsparser.parseWsdl();
        this.requirementsFile = requirementsparser.getWsdlfile();
        this.requirementsServices = this.requirementsFile.getServicelist();
        this.candidateFileName = candidate;
        WsdlFileParser candidateparser = new WsdlFileParser(this.candidateFileName, this.lookupTable);
        candidateparser.parseWsdl();
        this.candidateFile = candidateparser.getWsdlfile();
        this.candidateServices = this.candidateFile.getServicelist();
        this.matchStrategy = 0;
        this.strictSequence = true;
        this.dictionary = dict;
        this.fileMapping = new Mapping(this.requirementsFileName, this.candidateFileName);
    }

    public WsdlFileMatcher(String requirements, WsdlFile reqFile, String candidate, SimpleTypeLookupTable lookup, DictInstance dict) {
        this.lookupTable = lookup;
        this.requirementsFileName = requirements;
        this.requirementsFile = reqFile;
        this.requirementsServices = this.requirementsFile.getServicelist();
        this.candidateFileName = candidate;
        WsdlFileParser candidateparser = new WsdlFileParser(this.candidateFileName, this.lookupTable);
        candidateparser.parseWsdl();
        this.candidateFile = candidateparser.getWsdlfile();
        this.candidateServices = this.candidateFile.getServicelist();
        this.matchStrategy = 0;
        this.strictSequence = true;
        this.dictionary = dict;
        this.fileMapping = new Mapping(this.requirementsFileName, this.candidateFileName);
    }

    public void match() throws JWNLException {
        for (String requirementsname : this.requirementsServices.keySet()) {
            Service requirementsservice = this.requirementsServices.get(requirementsname);
            for (String candidatename : this.candidateServices.keySet()) {
                Service candidateservice = this.candidateServices.get(candidatename);
                WsdlServiceMatcher matcher = new WsdlServiceMatcher(requirementsservice, this.requirementsFile, candidateservice, this.candidateFile, this.lookupTable, this.matchStrategy, this.structureWeight, this.nameWeight, this.wordnetWeight, this.strictSequence, this.dictionary);
                matcher.setEdit(this.edit);
                int score = matcher.matchServices();
                MappingPartList servicePartList = new MappingPartList();
                servicePartList.addMapping(matcher.getServiceMapping());
                this.fileMapping.addMappingPartList(servicePartList);
            }
        }
        int wsdlscore = this.fileMapping.getScore();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.fileMapping.log(0));
        }
    }

    public Mapping getFilemapping() {
        return this.fileMapping;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public int getMatchStrategy() {
        return this.matchStrategy;
    }

    public void setStructural() {
        this.matchStrategy = 0;
    }

    public void setName() {
        this.matchStrategy = 1;
    }

    public void setWordnet() {
        this.matchStrategy = 2;
    }

    public void setStructuralName() {
        this.matchStrategy = 3;
    }

    public void setStructuralWordnet() {
        this.matchStrategy = 4;
    }

    public void setNameWordnet() {
        this.matchStrategy = 5;
    }

    public void setAll() {
        this.matchStrategy = 6;
    }

    public int getNameWeight() {
        return this.nameWeight;
    }

    public void setNameWeight(int nameWeight) {
        this.nameWeight = nameWeight;
    }

    public int getStructureWeight() {
        return this.structureWeight;
    }

    public void setStructureWeight(int structureWeight) {
        this.structureWeight = structureWeight;
    }

    public int getWordnetWeight() {
        return this.wordnetWeight;
    }

    public void setWordnetWeight(int wordnetweight) {
        this.wordnetWeight = wordnetweight;
    }

    public boolean isStrictSequence() {
        return this.strictSequence;
    }

    public void setStrictSequence(boolean strictSequence) {
        this.strictSequence = strictSequence;
    }
}

