/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import net.didion.jwnl.JWNLException;
import wsdlanalyzer.mapping.Mapping;
import wsdlanalyzer.mapping.MappingPartList;
import wsdlanalyzer.matcher.NameTokens;
import wsdlanalyzer.matcher.SimpleTokenMatcher;
import wsdlanalyzer.matcher.StopWords;
import wsdlanalyzer.matrix.ScoreMap;
import wsdlanalyzer.parser.SimpleTypeLookupTable;
import wsdlanalyzer.types.Attribute;
import wsdlanalyzer.types.BindingList;
import wsdlanalyzer.types.ComplexType;
import wsdlanalyzer.types.Element;
import wsdlanalyzer.types.ElementList;
import wsdlanalyzer.types.Message;
import wsdlanalyzer.types.MessageList;
import wsdlanalyzer.types.MessageParameter;
import wsdlanalyzer.types.NodeIdentifier;
import wsdlanalyzer.types.Operation;
import wsdlanalyzer.types.OperationList;
import wsdlanalyzer.types.PortType;
import wsdlanalyzer.types.PortTypeList;
import wsdlanalyzer.types.Sequence;
import wsdlanalyzer.types.Service;
import wsdlanalyzer.types.TypeList;
import wsdlanalyzer.types.WsdlFile;
import wsdlanalyzer.wordnet.DictInstance;

public class WsdlServiceMatcher {
    private String requirementsFileName;
    private String candidateFileName;
    private Service requirementsService;
    private Service candidateService;
    private BindingList requirementsBindings;
    private BindingList candidateBindings;
    private PortTypeList requirementsPortTypes;
    private PortTypeList candidatePortTypes;
    private MessageList requirementsMessages;
    private MessageList candidateMessages;
    private TypeList requirementsTypes;
    private TypeList candidateTypes;
    private ElementList requirementsElements;
    private ElementList candidateElements;
    private SimpleTypeLookupTable lookupTable;
    private ScoreMap scoreMatrix;
    private int minScore = 0;
    private int maxScore = 10;
    private int groupingBonus = 10;
    private int arrayBonus = 2;
    private int sequenceBonus = 5;
    private boolean edit = true;
    private Mapping serviceMapping;
    private StopWords stopWords;
    private int matchStrategy;
    private int structureWeight;
    private int nameWeight;
    private int wordnetWeight;
    private boolean strictSequence;
    private DictInstance dictionary;

    public WsdlServiceMatcher(Service requirements, WsdlFile requirementsfile, Service candidate, WsdlFile candidatefile, SimpleTypeLookupTable l, int strategy, DictInstance dict) {
        this.matchStrategy = strategy;
        this.dictionary = dict;
        this.requirementsFileName = requirementsfile.getWsdlFileName();
        this.requirementsService = requirements;
        this.requirementsBindings = requirementsfile.getBindings();
        this.requirementsPortTypes = requirementsfile.getPorttypelist();
        this.requirementsMessages = requirementsfile.getMessageList();
        this.requirementsTypes = requirementsfile.getTypeList();
        this.requirementsElements = requirementsfile.getElementlist();
        this.candidateFileName = candidatefile.getWsdlFileName();
        this.candidateService = candidate;
        this.candidateBindings = candidatefile.getBindings();
        this.candidatePortTypes = candidatefile.getPorttypelist();
        this.candidateMessages = candidatefile.getMessageList();
        this.candidateTypes = candidatefile.getTypeList();
        this.candidateElements = candidatefile.getElementlist();
        this.lookupTable = l;
        this.stopWords = new StopWords();
        this.serviceMapping = new Mapping(this.requirementsService.getName(), this.candidateService.getName(), this.requirementsService.getNodeIdentifier(), this.candidateService.getNodeIdentifier());
    }

    public WsdlServiceMatcher(Service requirements, WsdlFile requirementsfile, Service candidate, WsdlFile candidatefile, SimpleTypeLookupTable l, int strategy, int strucWeight, int namWeight, int wordntWeight, boolean strictseq, DictInstance dict) {
        this.matchStrategy = strategy;
        this.structureWeight = strucWeight;
        this.nameWeight = namWeight;
        this.wordnetWeight = wordntWeight;
        this.strictSequence = strictseq;
        this.dictionary = dict;
        this.requirementsFileName = requirementsfile.getWsdlFileName();
        this.requirementsService = requirements;
        this.requirementsBindings = requirementsfile.getBindings();
        this.requirementsPortTypes = requirementsfile.getPorttypelist();
        this.requirementsMessages = requirementsfile.getMessageList();
        this.requirementsTypes = requirementsfile.getTypeList();
        this.requirementsElements = requirementsfile.getElementlist();
        this.candidateFileName = candidatefile.getWsdlFileName();
        this.candidateService = candidate;
        this.candidateBindings = candidatefile.getBindings();
        this.candidatePortTypes = candidatefile.getPorttypelist();
        this.candidateMessages = candidatefile.getMessageList();
        this.candidateTypes = candidatefile.getTypeList();
        this.candidateElements = candidatefile.getElementlist();
        this.lookupTable = l;
        this.stopWords = new StopWords();
        this.serviceMapping = new Mapping(this.requirementsService.getName(), this.candidateService.getName(), this.requirementsService.getNodeIdentifier(), this.candidateService.getNodeIdentifier());
    }

    public int matchServices() throws JWNLException {
        for (String requirementsPortName : this.requirementsService.keySet()) {
            String requirementsBinding = this.requirementsService.get(requirementsPortName).getBinding();
            String requirementsName = this.requirementsBindings.get(requirementsBinding).getPortType();
            PortType requirementsPortType = this.requirementsPortTypes.get(requirementsName);
            for (String candidatePortName : this.candidateService.keySet()) {
                Mapping portMapping = new Mapping(requirementsPortName, candidatePortName, this.requirementsService.get(requirementsPortName).getNodeIdentifier(), this.candidateService.get(candidatePortName).getNodeIdentifier());
                String candidateBinding = this.candidateService.get(candidatePortName).getBinding();
                Mapping bindingMapping = new Mapping(requirementsBinding, candidateBinding, this.requirementsBindings.get(requirementsBinding).getNodeIdentifier(), this.candidateBindings.get(candidateBinding).getNodeIdentifier());
                String candidateName = this.candidateBindings.get(candidateBinding).getPortType();
                PortType candidatePortType = this.candidatePortTypes.get(candidateName);
                Mapping portTypeMapping = this.matchPortTypes(requirementsPortType, candidatePortType);
                if (portTypeMapping == null) continue;
                MappingPartList portTypePartList = new MappingPartList();
                portTypePartList.addMapping(portTypeMapping);
                bindingMapping.addMappingPartList(portTypePartList);
                MappingPartList bindingPartList = new MappingPartList();
                bindingPartList.addMapping(bindingMapping);
                portMapping.addMappingPartList(bindingPartList);
                MappingPartList portPartList = new MappingPartList();
                portPartList.addMapping(portMapping);
                this.serviceMapping.addMappingPartList(portPartList);
            }
        }
        switch (this.matchStrategy) {
            case 0: {
                break;
            }
            case 1: {
                int nameScore = this.nameWeight * this.matchNames(this.requirementsService.getName(), this.candidateService.getName());
                if (nameScore <= 0) break;
                this.serviceMapping.addScoreBonus(nameScore);
                break;
            }
            case 2: {
                int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(this.requirementsService.getToken(), this.requirementsService.getName(), this.candidateService.getToken(), this.candidateService.getName());
                if (wordnetScore <= 0) break;
                this.serviceMapping.addScoreBonus(wordnetScore);
                break;
            }
            case 3: {
                int nameScore = this.nameWeight * this.matchNames(this.requirementsService.getName(), this.candidateService.getName());
                if (nameScore <= 0) break;
                this.serviceMapping.addScoreBonus(nameScore);
                break;
            }
            case 4: {
                int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(this.requirementsService.getToken(), this.requirementsService.getName(), this.candidateService.getToken(), this.candidateService.getName());
                if (wordnetScore <= 0) break;
                this.serviceMapping.addScoreBonus(wordnetScore);
                break;
            }
            case 5: {
                int nameScore = this.nameWeight * this.matchNames(this.requirementsService.getName(), this.candidateService.getName()) + this.wordnetWeight * this.simpleWordnetMatch(this.requirementsService.getToken(), this.requirementsService.getName(), this.candidateService.getToken(), this.candidateService.getName());
                if (nameScore <= 0) break;
                this.serviceMapping.addScoreBonus(nameScore);
                break;
            }
            case 6: {
                int nameScore = this.nameWeight * this.matchNames(this.requirementsService.getName(), this.candidateService.getName()) + this.wordnetWeight * this.simpleWordnetMatch(this.requirementsService.getToken(), this.requirementsService.getName(), this.candidateService.getToken(), this.candidateService.getName());
                if (nameScore <= 0) break;
                this.serviceMapping.addScoreBonus(nameScore);
            }
        }
        return this.serviceMapping.getScore();
    }

    public Mapping matchPortTypes(PortType requirementsPortType, PortType candidatePortType) throws JWNLException {
        OperationList requirementsOperations = requirementsPortType.getOperationlist();
        OperationList candidateOperations = candidatePortType.getOperationlist();
        if (!requirementsOperations.isEmpty() && !candidateOperations.isEmpty()) {
            ScoreMap operationMatrix = new ScoreMap(requirementsOperations.length(), candidateOperations.length(), requirementsPortType.getName(), candidatePortType.getName(), this.edit);
            int porttypescore = -1;
            for (String requirementsName : requirementsOperations.keySet()) {
                Operation requirementsOperation = requirementsOperations.getOperation(requirementsName);
                for (String candidateName : candidateOperations.keySet()) {
                    Operation candidateOperation = candidateOperations.getOperation(candidateName);
                    Mapping operationMapping = this.matchOperations(requirementsOperation, candidateOperation);
                    operationMatrix.setValue(operationMapping);
                }
            }
            operationMatrix.computeMatches();
            Mapping portTypeMapping = operationMatrix.getMapping();
            portTypeMapping.setRequirementsIdentifier(requirementsPortType.getNodeIdentifier());
            portTypeMapping.setCandidateIdentifier(candidatePortType.getNodeIdentifier());
            portTypeMapping.isAnymatch();
            switch (this.matchStrategy) {
                case 0: {
                    break;
                }
                case 1: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsPortType.getName(), candidatePortType.getName());
                    if (nameScore <= 0) break;
                    portTypeMapping.addScoreBonus(nameScore);
                    break;
                }
                case 2: {
                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsPortType.getToken(), requirementsPortType.getName(), candidatePortType.getToken(), candidatePortType.getName());
                    if (wordnetScore <= 0) break;
                    portTypeMapping.addScoreBonus(wordnetScore);
                    break;
                }
                case 3: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsPortType.getName(), candidatePortType.getName());
                    if (nameScore <= 0) break;
                    portTypeMapping.addScoreBonus(nameScore);
                    break;
                }
                case 4: {
                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsPortType.getToken(), requirementsPortType.getName(), candidatePortType.getToken(), candidatePortType.getName());
                    if (wordnetScore <= 0) break;
                    portTypeMapping.addScoreBonus(wordnetScore);
                    break;
                }
                case 5: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsPortType.getName(), candidatePortType.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsPortType.getToken(), requirementsPortType.getName(), candidatePortType.getToken(), candidatePortType.getName());
                    if (nameScore <= 0) break;
                    portTypeMapping.addScoreBonus(nameScore);
                    break;
                }
                case 6: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsPortType.getName(), candidatePortType.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsPortType.getToken(), requirementsPortType.getName(), candidatePortType.getToken(), candidatePortType.getName());
                    if (nameScore <= 0) break;
                    portTypeMapping.addScoreBonus(nameScore);
                }
            }
            return portTypeMapping;
        }
        Mapping nullMapping = new Mapping(requirementsPortType.getName(), candidatePortType.getName(), requirementsPortType.getNodeIdentifier(), candidatePortType.getNodeIdentifier());
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchOperations(Operation requirementsOp, Operation candidateOp) throws JWNLException {
        Mapping operationMapping;
        block21: {
            block20: {
                MappingPartList outputPartList;
                Mapping messageMapping;
                boolean mapped = false;
                operationMapping = new Mapping(requirementsOp.getName(), candidateOp.getName(), requirementsOp.getNodeIdentifier(), candidateOp.getNodeIdentifier());
                MappingPartList messagePartList = new MappingPartList();
                if (requirementsOp.getInput() != null && candidateOp.getInput() != null) {
                    Message requirementsInputMessage = this.requirementsMessages.getMessage(requirementsOp.getInput());
                    Message candidateInputMessage = this.candidateMessages.getMessage(candidateOp.getInput());
                    Mapping inputMapping = new Mapping(requirementsOp.getInput(), candidateOp.getInput(), requirementsOp.getInputId(), candidateOp.getInputId());
                    messageMapping = this.matchMessages(requirementsInputMessage, candidateInputMessage);
                    messageMapping.setRequirementsIdentifier(requirementsInputMessage.getNodeIdentifier());
                    messageMapping.setCandidateIdentifier(candidateInputMessage.getNodeIdentifier());
                    MappingPartList inputPartList = new MappingPartList();
                    inputPartList.addMapping(messageMapping);
                    inputMapping.addMappingPartList(inputPartList);
                    messagePartList.addMapping(inputMapping);
                    mapped = true;
                }
                if (requirementsOp.getOutput() != null && candidateOp.getOutput() != null) {
                    Message requirementsOutputMessage = this.requirementsMessages.getMessage(requirementsOp.getOutput());
                    Message candidateOutputMessage = this.candidateMessages.getMessage(candidateOp.getOutput());
                    Mapping outputMapping = new Mapping(requirementsOp.getOutput(), candidateOp.getOutput(), requirementsOp.getOutputId(), candidateOp.getOutputId());
                    messageMapping = this.matchMessages(requirementsOutputMessage, candidateOutputMessage);
                    messageMapping.setRequirementsIdentifier(requirementsOutputMessage.getNodeIdentifier());
                    messageMapping.setCandidateIdentifier(candidateOutputMessage.getNodeIdentifier());
                    outputPartList = new MappingPartList();
                    outputPartList.addMapping(messageMapping);
                    outputMapping.addMappingPartList(outputPartList);
                    messagePartList.addMapping(outputMapping);
                    mapped = true;
                }
                if (requirementsOp.getFault() != null && candidateOp.getFault() != null) {
                    Message requirementsFaultMessage = this.requirementsMessages.getMessage(requirementsOp.getFault());
                    Message candidateFaultMessage = this.candidateMessages.getMessage(candidateOp.getFault());
                    Mapping faultMapping = new Mapping(requirementsOp.getFault(), candidateOp.getFault(), requirementsOp.getFaultId(), candidateOp.getFaultId());
                    messageMapping = this.matchMessages(requirementsFaultMessage, candidateFaultMessage);
                    messageMapping.setRequirementsIdentifier(requirementsFaultMessage.getNodeIdentifier());
                    messageMapping.setCandidateIdentifier(candidateFaultMessage.getNodeIdentifier());
                    outputPartList = new MappingPartList();
                    outputPartList.addMapping(messageMapping);
                    faultMapping.addMappingPartList(outputPartList);
                    messagePartList.addMapping(faultMapping);
                    mapped = true;
                }
                if (!mapped) break block20;
                operationMapping.addMappingPartList(messagePartList);
                switch (this.matchStrategy) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int nameScore = this.nameWeight * this.matchNames(requirementsOp.getName(), candidateOp.getName());
                        if (nameScore > 0) {
                            operationMapping.addScoreBonus(nameScore);
                            break;
                        }
                        break block21;
                    }
                    case 2: {
                        int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsOp.getToken(), requirementsOp.getName(), candidateOp.getToken(), candidateOp.getName());
                        if (wordnetScore > 0) {
                            operationMapping.addScoreBonus(wordnetScore);
                            break;
                        }
                        break block21;
                    }
                    case 3: {
                        int nameScore = this.nameWeight * this.matchNames(requirementsOp.getName(), candidateOp.getName());
                        if (nameScore > 0) {
                            operationMapping.addScoreBonus(nameScore);
                            break;
                        }
                        break block21;
                    }
                    case 4: {
                        int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsOp.getToken(), requirementsOp.getName(), candidateOp.getToken(), candidateOp.getName());
                        if (wordnetScore > 0) {
                            operationMapping.addScoreBonus(wordnetScore);
                            break;
                        }
                        break block21;
                    }
                    case 5: {
                        int nameScore = this.nameWeight * this.matchNames(requirementsOp.getName(), candidateOp.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsOp.getToken(), requirementsOp.getName(), candidateOp.getToken(), candidateOp.getName());
                        if (nameScore > 0) {
                            operationMapping.addScoreBonus(nameScore);
                            break;
                        }
                        break block21;
                    }
                    case 6: {
                        int nameScore = this.nameWeight * this.matchNames(requirementsOp.getName(), candidateOp.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsOp.getToken(), requirementsOp.getName(), candidateOp.getToken(), candidateOp.getName());
                        if (nameScore <= 0) break block21;
                        operationMapping.addScoreBonus(nameScore);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block21;
            }
            operationMapping.setScore(this.minScore);
        }
        return operationMapping;
    }

    private Mapping matchMessages(Message requirementsMessage, Message candidateMessage) throws JWNLException {
        ScoreMap parameterMatrix = new ScoreMap(requirementsMessage.getParameterList().size(), candidateMessage.getParameterList().size(), requirementsMessage.getName(), candidateMessage.getName(), this.edit);
        if (!requirementsMessage.isEmpty() && !candidateMessage.isEmpty()) {
            ListIterator<MessageParameter> requirementsList = requirementsMessage.getParameterList().listIterator();
            while (requirementsList.hasNext()) {
                MessageParameter requirementsParameter = requirementsList.next();
                ListIterator<MessageParameter> candidateList = candidateMessage.getParameterList().listIterator();
                while (candidateList.hasNext()) {
                    MessageParameter candidateParameter = candidateList.next();
                    Mapping parameterMapping = this.matchParameter(requirementsParameter, candidateParameter);
                    parameterMatrix.setValue(parameterMapping);
                }
            }
            parameterMatrix.computeMatches();
            Mapping messageMapping = parameterMatrix.getMapping();
            switch (this.matchStrategy) {
                case 0: {
                    break;
                }
                case 1: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsMessage.getName(), candidateMessage.getName());
                    if (nameScore <= 0) break;
                    messageMapping.addScoreBonus(nameScore);
                    break;
                }
                case 2: {
                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsMessage.getToken(), requirementsMessage.getName(), candidateMessage.getToken(), candidateMessage.getName());
                    if (wordnetScore <= 0) break;
                    messageMapping.addScoreBonus(wordnetScore);
                    break;
                }
                case 3: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsMessage.getName(), candidateMessage.getName());
                    if (nameScore <= 0) break;
                    messageMapping.addScoreBonus(nameScore);
                    break;
                }
                case 4: {
                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsMessage.getToken(), requirementsMessage.getName(), candidateMessage.getToken(), candidateMessage.getName());
                    if (wordnetScore <= 0) break;
                    messageMapping.addScoreBonus(wordnetScore);
                    break;
                }
                case 5: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsMessage.getName(), candidateMessage.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsMessage.getToken(), requirementsMessage.getName(), candidateMessage.getToken(), candidateMessage.getName());
                    if (nameScore <= 0) break;
                    messageMapping.addScoreBonus(nameScore);
                    break;
                }
                case 6: {
                    int nameScore = this.nameWeight * this.matchNames(requirementsMessage.getName(), candidateMessage.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsMessage.getToken(), requirementsMessage.getName(), candidateMessage.getToken(), candidateMessage.getName());
                    if (nameScore <= 0) break;
                    messageMapping.addScoreBonus(nameScore);
                }
            }
            return messageMapping;
        }
        Mapping nullMapping = new Mapping(requirementsMessage.getName(), candidateMessage.getName(), requirementsMessage.getNodeIdentifier(), candidateMessage.getNodeIdentifier());
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchParameter(MessageParameter requirementsParameter, MessageParameter candidateParameter) throws JWNLException {
        ComplexType complextype;
        Mapping parameterMapping = new Mapping(requirementsParameter.getName(), candidateParameter.getName(), requirementsParameter.getNodeIdentifier(), candidateParameter.getNodeIdentifier());
        if (this.lookupTable.lookupSimpleType(requirementsParameter.getType())) {
            if (this.lookupTable.lookupSimpleType(candidateParameter.getType())) {
                if (this.matchStrategy == 0 || this.matchStrategy == 3 || this.matchStrategy == 4 || this.matchStrategy == 6) {
                    parameterMapping.setScore(this.structureWeight * this.lookupTable.getMatchingScore(requirementsParameter.getType(), candidateParameter.getType()));
                }
            } else {
                complextype = this.candidateTypes.getType(candidateParameter.getType());
                Mapping typeMapping = this.matchMixedTypes(requirementsParameter.getName(), requirementsParameter.getType(), candidateParameter.getName(), complextype, null);
                MappingPartList typePartList = new MappingPartList();
                typePartList.addMapping(typeMapping);
                parameterMapping.addMappingPartList(typePartList);
            }
        } else if (this.lookupTable.lookupSimpleType(candidateParameter.getType())) {
            complextype = this.requirementsTypes.getType(requirementsParameter.getType());
            Mapping typeMapping = this.matchMixedTypes(requirementsParameter.getName(), complextype, candidateParameter.getName(), candidateParameter.getType(), null);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            parameterMapping.addMappingPartList(typePartList);
        } else {
            ComplexType requirementstype = this.requirementsTypes.getType(requirementsParameter.getType());
            ComplexType candidatetype = this.candidateTypes.getType(candidateParameter.getType());
            Mapping typeMapping = this.matchComplexTypes(requirementsParameter.getName(), requirementstype, candidateParameter.getName(), candidatetype);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            parameterMapping.addMappingPartList(typePartList);
        }
        switch (this.matchStrategy) {
            case 0: {
                break;
            }
            case 1: {
                int nameScore = this.nameWeight * this.matchNames(requirementsParameter.getName(), candidateParameter.getName());
                if (nameScore <= 0) break;
                parameterMapping.addScoreBonus(nameScore);
                break;
            }
            case 2: {
                int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsParameter.getToken(), requirementsParameter.getName(), candidateParameter.getToken(), candidateParameter.getName());
                if (wordnetScore <= 0) break;
                parameterMapping.addScoreBonus(wordnetScore);
                break;
            }
            case 3: {
                int nameScore = this.nameWeight * this.matchNames(requirementsParameter.getName(), candidateParameter.getName());
                if (nameScore <= 0) break;
                parameterMapping.addScoreBonus(nameScore);
                break;
            }
            case 4: {
                int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsParameter.getToken(), requirementsParameter.getName(), candidateParameter.getToken(), candidateParameter.getName());
                if (wordnetScore <= 0) break;
                parameterMapping.addScoreBonus(wordnetScore);
                break;
            }
            case 5: {
                int nameScore = this.nameWeight * this.matchNames(requirementsParameter.getName(), candidateParameter.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsParameter.getToken(), requirementsParameter.getName(), candidateParameter.getToken(), candidateParameter.getName());
                if (nameScore <= 0) break;
                parameterMapping.addScoreBonus(nameScore);
                break;
            }
            case 6: {
                int nameScore = this.nameWeight * this.matchNames(requirementsParameter.getName(), candidateParameter.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsParameter.getToken(), requirementsParameter.getName(), candidateParameter.getToken(), candidateParameter.getName());
                if (nameScore <= 0) break;
                parameterMapping.addScoreBonus(nameScore);
            }
        }
        return parameterMapping;
    }

    private int matchIdenticalTypes(ComplexType type) {
        int elementcount = type.getElementList().size();
        int groupingcount = 1;
        for (Element element : type.getElementList()) {
            if (this.lookupTable.lookupSimpleType(element.getType())) continue;
            ComplexType complextype = this.requirementsTypes.getType(element.getType());
            elementcount += this.matchIdenticalTypes(complextype);
            ++groupingcount;
        }
        return (elementcount + groupingcount) * this.maxScore * 2;
    }

    private Mapping matchMixedTypes(String requirementsName, ComplexType requirementsType, String candidateName, String candidateType, NodeIdentifier id) throws JWNLException {
        if (requirementsType != null) {
            ScoreMap typeMatrix = new ScoreMap(requirementsType.getElementList().size(), 1, requirementsName, candidateName, this.edit);
            int typeScore = -1;
            if (!requirementsType.isArray()) {
                if (!requirementsType.getElementList().isEmpty()) {
                    ListIterator<Element> elements = requirementsType.getElementList().listIterator();
                    while (elements.hasNext()) {
                        Element requirementsElement = elements.next();
                        if (this.lookupTable.lookupSimpleType(requirementsElement.getType())) {
                            Mapping elementMapping = new Mapping(requirementsElement.getName(), candidateName);
                            elementMapping.setRequirementsIdentifier(requirementsElement.getNodeIdentifier());
                            if (id != null) {
                                elementMapping.setCandidateIdentifier(id);
                            }
                            switch (this.matchStrategy) {
                                case 0: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateType);
                                    elementMapping.setScore(matchScore);
                                    break;
                                }
                                case 1: {
                                    int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateName);
                                    if (nameScore <= 0) break;
                                    elementMapping.setScore(nameScore);
                                    break;
                                }
                                case 2: {
                                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), new NameTokens(candidateName, this.stopWords), candidateName);
                                    if (wordnetScore <= 0) break;
                                    elementMapping.setScore(wordnetScore);
                                    break;
                                }
                                case 3: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateType);
                                    elementMapping.setScore(matchScore);
                                    int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateName);
                                    if (nameScore <= 0) break;
                                    elementMapping.addScoreBonus(nameScore);
                                    break;
                                }
                                case 4: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateType);
                                    elementMapping.setScore(matchScore);
                                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), new NameTokens(candidateName, this.stopWords), candidateName);
                                    if (wordnetScore <= 0) break;
                                    elementMapping.addScoreBonus(wordnetScore);
                                    break;
                                }
                                case 5: {
                                    int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateName) + this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), new NameTokens(candidateName, this.stopWords), candidateName);
                                    if (nameScore <= 0) break;
                                    elementMapping.setScore(nameScore);
                                    break;
                                }
                                case 6: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateType);
                                    elementMapping.setScore(matchScore);
                                    int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateName) + this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), new NameTokens(candidateName, this.stopWords), candidateName);
                                    if (nameScore <= 0) break;
                                    elementMapping.addScoreBonus(nameScore);
                                }
                            }
                            typeMatrix.setValue(elementMapping);
                            continue;
                        }
                        ComplexType complextypeelement = this.requirementsTypes.getType(requirementsElement.getType());
                        Mapping elementMapping = this.matchMixedTypes(requirementsElement.getName(), complextypeelement, candidateName, candidateType, id);
                        typeMatrix.setValue(elementMapping);
                    }
                    typeMatrix.computeMatches();
                    Mapping typeMapping = typeMatrix.getMapping();
                    typeMapping.setRequirementsIdentifier(requirementsType.getNodeIdentifier());
                    if (id != null) {
                        typeMapping.setCandidateIdentifier(id);
                    }
                    return typeMapping;
                }
                Mapping nullMapping = new Mapping(requirementsName, candidateName);
                nullMapping.setScore(0);
                return nullMapping;
            }
            Mapping nullMapping = new Mapping(requirementsName, candidateName);
            nullMapping.setScore(0);
            return nullMapping;
        }
        Mapping nullMapping = new Mapping(requirementsName, candidateName);
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchMixedTypes(String requirementsName, String requirementsType, String candidateName, ComplexType candidateType, NodeIdentifier id) throws JWNLException {
        if (candidateType != null) {
            ScoreMap typeMatrix = new ScoreMap(1, candidateType.getElementList().size(), requirementsName, candidateName, this.edit);
            int typeScore = -1;
            if (!candidateType.isArray()) {
                if (!candidateType.getElementList().isEmpty()) {
                    ListIterator<Element> elements = candidateType.getElementList().listIterator();
                    while (elements.hasNext()) {
                        Element candidateelement = elements.next();
                        if (this.lookupTable.lookupSimpleType(candidateelement.getType())) {
                            Mapping elementMapping = new Mapping(requirementsName, candidateelement.getName());
                            elementMapping.setCandidateIdentifier(candidateelement.getNodeIdentifier());
                            if (id != null) {
                                elementMapping.setRequirementsIdentifier(id);
                            }
                            switch (this.matchStrategy) {
                                case 0: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsType, candidateelement.getType());
                                    elementMapping.setScore(matchScore);
                                    break;
                                }
                                case 1: {
                                    int nameScore = this.nameWeight * this.matchNames(requirementsName, candidateelement.getName());
                                    if (nameScore <= 0) break;
                                    elementMapping.setScore(nameScore);
                                    break;
                                }
                                case 2: {
                                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(new NameTokens(requirementsName, this.stopWords), requirementsName, candidateelement.getToken(), candidateelement.getName());
                                    if (wordnetScore <= 0) break;
                                    elementMapping.setScore(wordnetScore);
                                    break;
                                }
                                case 3: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsType, candidateelement.getType());
                                    elementMapping.setScore(matchScore);
                                    int nameScore = this.nameWeight * this.matchNames(requirementsName, candidateelement.getName());
                                    if (nameScore <= 0) break;
                                    elementMapping.addScoreBonus(nameScore);
                                    break;
                                }
                                case 4: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsType, candidateelement.getType());
                                    elementMapping.setScore(matchScore);
                                    int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(new NameTokens(requirementsName, this.stopWords), requirementsName, candidateelement.getToken(), candidateelement.getName());
                                    if (wordnetScore <= 0) break;
                                    elementMapping.addScoreBonus(wordnetScore);
                                    break;
                                }
                                case 5: {
                                    int nameScore = this.nameWeight * this.matchNames(requirementsName, candidateelement.getName()) + this.wordnetWeight * this.simpleWordnetMatch(new NameTokens(requirementsName, this.stopWords), requirementsName, candidateelement.getToken(), candidateelement.getName());
                                    if (nameScore <= 0) break;
                                    elementMapping.setScore(nameScore);
                                    break;
                                }
                                case 6: {
                                    int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsType, candidateelement.getType());
                                    elementMapping.setScore(matchScore);
                                    int nameScore = this.nameWeight * this.matchNames(requirementsName, candidateelement.getName()) + this.wordnetWeight * this.simpleWordnetMatch(new NameTokens(requirementsName, this.stopWords), requirementsName, candidateelement.getToken(), candidateelement.getName());
                                    if (nameScore <= 0) break;
                                    elementMapping.addScoreBonus(nameScore);
                                }
                            }
                            typeMatrix.setValue(elementMapping);
                            continue;
                        }
                        ComplexType complextypeelement = this.candidateTypes.getType(candidateelement.getType());
                        Mapping elementMapping = this.matchMixedTypes(requirementsName, requirementsType, candidateelement.getName(), complextypeelement, id);
                        typeMatrix.setValue(elementMapping);
                    }
                    typeMatrix.computeMatches();
                    Mapping typeMapping = typeMatrix.getMapping();
                    if (id != null) {
                        typeMapping.setRequirementsIdentifier(id);
                    }
                    typeMapping.setCandidateIdentifier(candidateType.getNodeIdentifier());
                    return typeMapping;
                }
                Mapping nullMapping = new Mapping(requirementsName, candidateName);
                nullMapping.setScore(0);
                return nullMapping;
            }
            Mapping nullMapping = new Mapping(requirementsName, candidateName);
            nullMapping.setScore(0);
            return nullMapping;
        }
        Mapping nullMapping = new Mapping(requirementsName, candidateName);
        nullMapping.setScore(0);
        return nullMapping;
    }

    /*
     * Unable to fully structure code
     */
    private Mapping matchComplexTypes(String requirementsName, ComplexType requirementsType, String candidateName, ComplexType candidateType) throws JWNLException {
        block25: {
            typeMapping = new Mapping(requirementsType.getName(), candidateType.getName(), requirementsType.getNodeIdentifier(), candidateType.getNodeIdentifier());
            elementListMapping = null;
            attributeMapping = null;
            if (requirementsType == null || candidateType == null) break block25;
            typeScore = 0;
            if (requirementsType.hasAttributes() && candidateType.hasAttributes()) {
                attributeMapping = this.matchAttributeLists(requirementsType, candidateType);
                requirementsAttributeIdentifier = new NodeIdentifier("Attributes", "complexTypeMember", requirementsType.getNodeIdentifier());
                candidateAttributeIdentifier = new NodeIdentifier("Attributes", "complexTypeMember", candidateType.getNodeIdentifier());
                attributeMapping.setRequirementsIdentifier(requirementsAttributeIdentifier);
                attributeMapping.setCandidateIdentifier(candidateAttributeIdentifier);
            }
            if (!requirementsType.isArray()) ** GOTO lbl19
            if (candidateType.isArray()) {
                elementListMapping = this.matchArrayTypes(requirementsType, candidateType);
            } else {
                nullMapping = new Mapping(requirementsName, candidateName);
                nullMapping.setScore(0);
                return nullMapping;
lbl19:
                // 1 sources

                if (candidateType.isArray()) {
                    nullMapping = new Mapping(requirementsName, candidateName);
                    nullMapping.setScore(0);
                    return nullMapping;
                }
                Score = false;
                if (requirementsType.getNumberOfNonLeafElements() == candidateType.getNumberOfNonLeafElements() - 1 && requirementsType.getNumberOfLeafElements() > candidateType.getNumberOfLeafElements() + 1 && requirementsType.getNumberOfLeafElements() != candidateType.getNumberOfLeafElements()) {
                    requirementsType.getNumberOfNonLeafElements();
                    candidateType.getNumberOfNonLeafElements();
                }
                if (requirementsType.getGrouping() == candidateType.getGrouping()) {
                    typeScore += this.groupingBonus;
                }
                if (requirementsType.getGrouping() == 1 && candidateType.getGrouping() == 1 && this.strictSequence) {
                    requirementssequence = this.generateSequence(requirementsType);
                    candidatesequence = this.generateSequence(candidateType);
                    elementListMapping = this.matchSequences(requirementsType, requirementssequence, candidateType, candidatesequence);
                    if (this.matchStrategy == 0 || this.matchStrategy == 3 || this.matchStrategy == 4 || this.matchStrategy == 6) {
                        elementListMapping.addScoreBonus(this.structureWeight * typeScore);
                    }
                } else if (!requirementsType.isEmpty() && !candidateType.isEmpty()) {
                    typeMatrix = new ScoreMap(requirementsType.getElementList().size(), candidateType.getElementList().size(), requirementsName, candidateName, this.edit);
                    requirementselements = requirementsType.getElementList().listIterator();
                    while (requirementselements.hasNext()) {
                        requirementselement = requirementselements.next();
                        candidateelements = candidateType.getElementList().listIterator();
                        while (candidateelements.hasNext()) {
                            candidateelement = candidateelements.next();
                            elementMapping = this.matchElements(requirementselement, candidateelement);
                            typeMatrix.setValue(elementMapping);
                        }
                    }
                    typeMatrix.computeMatches();
                    elementListMapping = typeMatrix.getMapping();
                    if (this.matchStrategy == 0 || this.matchStrategy == 3 || this.matchStrategy == 4 || this.matchStrategy == 6) {
                        elementListMapping.addScoreBonus(this.structureWeight * typeScore);
                    }
                } else {
                    nullMapping = new Mapping(requirementsName, candidateName);
                    nullMapping.setScore(0);
                    return nullMapping;
                }
            }
            requirementsElementListIdentifier = new NodeIdentifier("Elements", "complexTypeMember", requirementsType.getNodeIdentifier());
            candidateElementListIdentifier = new NodeIdentifier("Elements", "complexTypeMember", candidateType.getNodeIdentifier());
            elementListMapping.setRequirementsIdentifier(requirementsElementListIdentifier);
            elementListMapping.setCandidateIdentifier(candidateElementListIdentifier);
            typePartList = new MappingPartList();
            if (elementListMapping != null) {
                typePartList.addMapping(elementListMapping);
            }
            if (attributeMapping != null) {
                typePartList.addMapping(attributeMapping);
            }
            typeMapping.addMappingPartList(typePartList);
            switch (this.matchStrategy) {
                case 0: {
                    break;
                }
                case 1: {
                    nameScore = this.nameWeight * this.matchNames(requirementsName, candidateName);
                    if (nameScore <= 0) break;
                    typeMapping.addScoreBonus(nameScore);
                    break;
                }
                case 2: {
                    wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsType.getToken(), requirementsName, candidateType.getToken(), candidateName);
                    if (wordnetScore <= 0) break;
                    typeMapping.addScoreBonus(wordnetScore);
                    break;
                }
                case 3: {
                    nameScore = this.nameWeight * this.matchNames(requirementsName, candidateName);
                    if (nameScore <= 0) break;
                    typeMapping.addScoreBonus(nameScore);
                    break;
                }
                case 4: {
                    wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsType.getToken(), requirementsName, candidateType.getToken(), candidateName);
                    if (wordnetScore <= 0) break;
                    typeMapping.addScoreBonus(wordnetScore);
                    break;
                }
                case 5: {
                    nameScore = this.nameWeight * this.matchNames(requirementsName, candidateName) + this.wordnetWeight * this.simpleWordnetMatch(requirementsType.getToken(), requirementsName, candidateType.getToken(), candidateName);
                    if (nameScore <= 0) break;
                    typeMapping.addScoreBonus(nameScore);
                    break;
                }
                case 6: {
                    nameScore = this.nameWeight * this.matchNames(requirementsName, candidateName) + this.wordnetWeight * this.simpleWordnetMatch(requirementsType.getToken(), requirementsName, candidateType.getToken(), candidateName);
                    if (nameScore <= 0) break;
                    typeMapping.addScoreBonus(nameScore);
                }
            }
            return typeMapping;
        }
        nullMapping = new Mapping(requirementsName, candidateName);
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchArrayTypes(ComplexType requirementsType, ComplexType candidateType) throws JWNLException {
        Mapping arrayMapping = new Mapping(requirementsType.getName(), candidateType.getName(), requirementsType.getNodeIdentifier(), candidateType.getNodeIdentifier());
        int arrayscore = -1;
        String requirementsarraytype = requirementsType.getArrayType();
        String candidatearraytype = candidateType.getArrayType();
        if (this.lookupTable.lookupSimpleType(requirementsarraytype)) {
            if (this.lookupTable.lookupSimpleType(candidatearraytype)) {
                if (this.matchStrategy == 0 || this.matchStrategy == 3 || this.matchStrategy == 4 || this.matchStrategy == 6) {
                    arrayscore = this.lookupTable.getMatchingScore(requirementsarraytype, candidatearraytype) * this.arrayBonus;
                    arrayMapping.setScore(this.structureWeight * arrayscore * this.arrayBonus);
                }
                return arrayMapping;
            }
            ComplexType complextype = this.candidateTypes.getType(candidatearraytype);
            Mapping typeMapping = this.matchMixedTypes(requirementsType.getName(), requirementsarraytype, candidateType.getName(), complextype, null);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            arrayMapping.addMappingPartList(typePartList);
            if (this.matchStrategy == 0 || this.matchStrategy == 3 || this.matchStrategy == 4 || this.matchStrategy == 6) {
                arrayMapping.setScore(this.structureWeight * arrayMapping.getScore() * this.arrayBonus);
            }
            return arrayMapping;
        }
        if (this.lookupTable.lookupSimpleType(candidatearraytype)) {
            ComplexType complextype = this.requirementsTypes.getType(requirementsarraytype);
            Mapping typeMapping = this.matchMixedTypes(requirementsType.getName(), complextype, candidateType.getName(), candidatearraytype, null);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            arrayMapping.addMappingPartList(typePartList);
            if (this.matchStrategy == 0 || this.matchStrategy == 3 || this.matchStrategy == 4 || this.matchStrategy == 6) {
                arrayMapping.setScore(this.structureWeight * arrayMapping.getScore() * this.arrayBonus);
            }
            return arrayMapping;
        }
        ComplexType complexrequirementstype = this.requirementsTypes.getType(requirementsarraytype);
        ComplexType complexcandidatetype = this.candidateTypes.getType(candidatearraytype);
        Mapping typeMapping = this.matchComplexTypes(requirementsType.getName(), complexrequirementstype, candidateType.getName(), complexcandidatetype);
        MappingPartList typePartList = new MappingPartList();
        typePartList.addMapping(typeMapping);
        arrayMapping.addMappingPartList(typePartList);
        switch (this.matchStrategy) {
            case 0: {
                arrayMapping.setScore(this.structureWeight * arrayMapping.getScore() * this.arrayBonus);
                break;
            }
            case 1: {
                int nameScore = this.nameWeight * this.matchNames(requirementsarraytype, candidatearraytype);
                if (nameScore <= 0) break;
                arrayMapping.addScoreBonus(nameScore);
                break;
            }
            case 2: {
                int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(complexrequirementstype.getToken(), complexrequirementstype.getName(), complexcandidatetype.getToken(), complexcandidatetype.getName());
                if (wordnetScore <= 0) break;
                arrayMapping.addScoreBonus(wordnetScore);
                break;
            }
            case 3: {
                arrayMapping.setScore(this.structureWeight * arrayMapping.getScore() * this.arrayBonus);
                int nameScore = this.nameWeight * this.matchNames(requirementsarraytype, candidatearraytype);
                if (nameScore <= 0) break;
                arrayMapping.addScoreBonus(nameScore);
                break;
            }
            case 4: {
                arrayMapping.setScore(this.structureWeight * arrayMapping.getScore() * this.arrayBonus);
                int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(complexrequirementstype.getToken(), complexrequirementstype.getName(), complexcandidatetype.getToken(), complexcandidatetype.getName());
                if (wordnetScore <= 0) break;
                typeMapping.addScoreBonus(wordnetScore);
                break;
            }
            case 5: {
                int nameScore = this.nameWeight * this.matchNames(requirementsarraytype, candidatearraytype) + this.wordnetWeight * this.simpleWordnetMatch(complexrequirementstype.getToken(), complexrequirementstype.getName(), complexcandidatetype.getToken(), complexcandidatetype.getName());
                if (nameScore <= 0) break;
                arrayMapping.addScoreBonus(nameScore);
                break;
            }
            case 6: {
                arrayMapping.setScore(this.structureWeight * arrayMapping.getScore() * this.arrayBonus);
                int nameScore = this.nameWeight * this.matchNames(requirementsarraytype, candidatearraytype) + this.wordnetWeight * this.simpleWordnetMatch(complexrequirementstype.getToken(), complexrequirementstype.getName(), complexcandidatetype.getToken(), complexcandidatetype.getName());
                if (nameScore <= 0) break;
                arrayMapping.addScoreBonus(nameScore);
            }
        }
        return arrayMapping;
    }

    private Mapping matchElements(Element requirementsElement, Element candidateElement) throws JWNLException {
        Mapping elementMapping;
        block22: {
            block23: {
                int elementScore;
                block21: {
                    elementMapping = new Mapping(requirementsElement.getName(), candidateElement.getName(), requirementsElement.getNodeIdentifier(), candidateElement.getNodeIdentifier());
                    elementScore = 0;
                    elementMapping.setRequirementminoccur(requirementsElement.getMinOccur());
                    elementMapping.setRequirementmaxoccur(requirementsElement.getMaxOccur());
                    elementMapping.setCandidateminoccur(candidateElement.getMinOccur());
                    elementMapping.setCandidatemaxoccur(candidateElement.getMaxOccur());
                    if (requirementsElement.getMinOccur() >= 0 && candidateElement.getMinOccur() >= 0 && requirementsElement.getMinOccur() == candidateElement.getMinOccur()) {
                        ++elementScore;
                    }
                    if (requirementsElement.getMaxOccur() >= 0 && candidateElement.getMaxOccur() >= 0 && requirementsElement.getMaxOccur() == candidateElement.getMaxOccur()) {
                        ++elementScore;
                    }
                    if (this.lookupTable.lookupSimpleType(requirementsElement.getType())) break block21;
                    ComplexType complexRequirementsType = this.requirementsTypes.getType(requirementsElement.getType());
                    if (this.lookupTable.lookupSimpleType(candidateElement.getType())) {
                        String simpletype = candidateElement.getType();
                        Mapping typeMapping = this.matchMixedTypes(requirementsElement.getType(), complexRequirementsType, candidateElement.getName(), candidateElement.getType(), candidateElement.getNodeIdentifier());
                        MappingPartList typePartList = new MappingPartList();
                        typePartList.addMapping(typeMapping);
                        elementMapping.addMappingPartList(typePartList);
                    } else {
                        ComplexType complexCandidateType = this.candidateTypes.getType(candidateElement.getType());
                        Mapping typeMapping = this.matchComplexTypes(requirementsElement.getType(), complexRequirementsType, candidateElement.getType(), complexCandidateType);
                        MappingPartList typePartList = new MappingPartList();
                        typePartList.addMapping(typeMapping);
                        elementMapping.addMappingPartList(typePartList);
                    }
                    break block22;
                }
                if (!this.lookupTable.lookupSimpleType(candidateElement.getType())) break block23;
                elementMapping.setRequirementsName(requirementsElement.getName());
                elementMapping.setCandidateName(candidateElement.getName());
                switch (this.matchStrategy) {
                    case 0: {
                        int matchScore = this.structureWeight * (elementScore + this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateElement.getType()));
                        elementMapping.setScore(matchScore);
                        break;
                    }
                    case 1: {
                        int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateElement.getName());
                        if (nameScore > 0) {
                            elementMapping.setScore(nameScore);
                            break;
                        }
                        break block22;
                    }
                    case 2: {
                        int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), candidateElement.getToken(), candidateElement.getName());
                        if (wordnetScore > 0) {
                            elementMapping.setScore(wordnetScore);
                            break;
                        }
                        break block22;
                    }
                    case 3: {
                        int matchScore = this.structureWeight * (elementScore + this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateElement.getType()));
                        elementMapping.setScore(matchScore);
                        int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateElement.getName());
                        if (nameScore > 0) {
                            elementMapping.addScoreBonus(nameScore);
                            break;
                        }
                        break block22;
                    }
                    case 4: {
                        int matchScore = this.structureWeight * (elementScore + this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateElement.getType()));
                        elementMapping.setScore(matchScore);
                        int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), candidateElement.getToken(), candidateElement.getName());
                        if (wordnetScore > 0) {
                            elementMapping.addScoreBonus(wordnetScore);
                            break;
                        }
                        break block22;
                    }
                    case 5: {
                        int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateElement.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), candidateElement.getToken(), candidateElement.getName());
                        if (nameScore > 0) {
                            elementMapping.setScore(nameScore);
                            break;
                        }
                        break block22;
                    }
                    case 6: {
                        int matchScore = this.structureWeight * (elementScore + this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateElement.getType()));
                        elementMapping.setScore(matchScore);
                        int nameScore = this.nameWeight * this.matchNames(requirementsElement.getName(), candidateElement.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsElement.getToken(), requirementsElement.getName(), candidateElement.getToken(), candidateElement.getName());
                        if (nameScore <= 0) break block22;
                        elementMapping.addScoreBonus(nameScore);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block22;
            }
            ComplexType complexCandidateType = this.candidateTypes.getType(candidateElement.getType());
            Mapping typeMapping = this.matchMixedTypes(requirementsElement.getName(), requirementsElement.getType(), candidateElement.getType(), complexCandidateType, requirementsElement.getNodeIdentifier());
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            elementMapping.addMappingPartList(typePartList);
        }
        return elementMapping;
    }

    private Mapping matchSequences(ComplexType requirementsType, Sequence requirements, ComplexType candidateType, Sequence candidate) throws JWNLException {
        Mapping sequenceMapping = new Mapping(requirementsType.getName(), candidateType.getName(), requirementsType.getNodeIdentifier(), candidateType.getNodeIdentifier());
        int sequenceScore = 0;
        int elementScore = 0;
        ArrayList<Integer> index = new ArrayList<Integer>();
        if (requirements.getLength() == candidate.getLength()) {
            MappingPartList mappingPartList = new MappingPartList();
            int i = 0;
            while (i < requirements.getLength()) {
                Element requirementselement = requirements.getElement(i);
                Element candidateelement = candidate.getElement(i);
                Mapping elementMapping = this.matchElements(requirementselement, candidateelement);
                mappingPartList.addMapping(elementMapping);
                ++i;
            }
            sequenceMapping.addMappingPartList(mappingPartList);
            sequenceMapping.addScoreBonus(this.sequenceBonus);
            return sequenceMapping;
        }
        if (requirements.getLength() < candidate.getLength()) {
            ArrayList<MappingPartList> tmplist = new ArrayList<MappingPartList>();
            int j = 0;
            while (j <= candidate.getLength() - requirements.getLength()) {
                int tmpScore = 0;
                MappingPartList mappingPartList = new MappingPartList();
                int i = 0;
                while (i < requirements.getLength()) {
                    Element requirementselement = requirements.getElement(i);
                    Element candidateelement = candidate.getElement(i + j);
                    Mapping elementMapping = this.matchElements(requirementselement, candidateelement);
                    elementScore = elementMapping.getScore();
                    tmpScore += elementScore;
                    mappingPartList.addMapping(elementMapping);
                    ++i;
                }
                if (sequenceScore < tmpScore) {
                    index.clear();
                    index.add(j);
                    tmplist.clear();
                    tmplist.add(mappingPartList);
                    sequenceScore = tmpScore;
                } else if (sequenceScore == tmpScore) {
                    index.add(j);
                    tmplist.add(mappingPartList);
                }
                ++j;
            }
            sequenceMapping.setMappingPartLists(tmplist);
            return sequenceMapping;
        }
        if (requirements.getLength() > candidate.getLength()) {
            ArrayList<MappingPartList> tmplist = new ArrayList<MappingPartList>();
            int j = 0;
            while (j <= requirements.getLength() - candidate.getLength()) {
                int tmpScore = 0;
                MappingPartList mappingPartList = new MappingPartList();
                int i = 0;
                while (i < candidate.getLength()) {
                    Element requirementsElement = requirements.getElement(i + j);
                    Element candidateElement = candidate.getElement(i);
                    Mapping elementMapping = this.matchElements(requirementsElement, candidateElement);
                    elementScore = elementMapping.getScore();
                    tmpScore += elementScore;
                    mappingPartList.addMapping(elementMapping);
                    ++i;
                }
                if (sequenceScore < tmpScore) {
                    index.clear();
                    index.add(j);
                    tmplist.clear();
                    tmplist.add(mappingPartList);
                    sequenceScore = tmpScore;
                } else if (sequenceScore == tmpScore) {
                    index.add(j);
                    tmplist.add(mappingPartList);
                }
                ++j;
            }
            sequenceMapping.setMappingPartLists(tmplist);
            return sequenceMapping;
        }
        return null;
    }

    private Mapping matchAttributeLists(ComplexType requirementsType, ComplexType candidateType) throws JWNLException {
        HashMap<String, Attribute> requirementsAttributes = requirementsType.getAttributeList();
        HashMap<String, Attribute> candidateAttributes = candidateType.getAttributeList();
        ScoreMap attributeMap = new ScoreMap(requirementsAttributes.size(), candidateAttributes.size(), "Attributes of " + requirementsType.getName(), "Attributes of " + candidateType.getName(), this.edit);
        Iterator<String> requirementsIterator = requirementsAttributes.keySet().iterator();
        while (requirementsIterator.hasNext()) {
            Attribute requirementsAttribute = requirementsAttributes.get(requirementsIterator.next());
            Iterator<String> candidateIterator = candidateAttributes.keySet().iterator();
            while (candidateIterator.hasNext()) {
                Attribute candidateAttribute = candidateAttributes.get(candidateIterator.next());
                Mapping attributeMapping = this.matchAttributes(requirementsAttribute, candidateAttribute);
                attributeMap.setValue(attributeMapping);
            }
        }
        return attributeMap.getMapping();
    }

    private Mapping matchAttributes(Attribute requirementsAttribute, Attribute candidateAttribute) throws JWNLException {
        Mapping attributeMapping = new Mapping(requirementsAttribute.getName(), candidateAttribute.getName(), requirementsAttribute.getId(), candidateAttribute.getId());
        switch (this.matchStrategy) {
            case 0: {
                int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsAttribute.getType(), candidateAttribute.getType());
                attributeMapping.setScore(matchScore);
                if (requirementsAttribute.getUse() == null || candidateAttribute.getUse() == null || !requirementsAttribute.getUse().equals(candidateAttribute.getUse())) break;
                attributeMapping.addScoreBonus(this.structureWeight * this.maxScore / 2);
                break;
            }
            case 1: {
                int nameScore = this.nameWeight * this.matchNames(requirementsAttribute.getName(), candidateAttribute.getName());
                if (nameScore <= 0) break;
                attributeMapping.setScore(nameScore);
                break;
            }
            case 2: {
                int wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsAttribute.getToken(), requirementsAttribute.getName(), candidateAttribute.getToken(), candidateAttribute.getName());
                if (wordnetScore <= 0) break;
                attributeMapping.setScore(wordnetScore);
                break;
            }
            case 3: {
                int nameScore;
                int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsAttribute.getType(), candidateAttribute.getType());
                attributeMapping.setScore(matchScore);
                if (requirementsAttribute.getUse() != null && candidateAttribute.getUse() != null && requirementsAttribute.getUse().equals(candidateAttribute.getUse())) {
                    attributeMapping.addScoreBonus(this.structureWeight * this.maxScore / 2);
                }
                if ((nameScore = this.nameWeight * this.matchNames(requirementsAttribute.getName(), candidateAttribute.getName())) <= 0) break;
                attributeMapping.addScoreBonus(nameScore);
                break;
            }
            case 4: {
                int wordnetScore;
                int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsAttribute.getType(), candidateAttribute.getType());
                attributeMapping.setScore(matchScore);
                if (requirementsAttribute.getUse() != null && candidateAttribute.getUse() != null && requirementsAttribute.getUse().equals(candidateAttribute.getUse())) {
                    attributeMapping.addScoreBonus(this.structureWeight * this.maxScore / 2);
                }
                if ((wordnetScore = this.wordnetWeight * this.simpleWordnetMatch(requirementsAttribute.getToken(), requirementsAttribute.getName(), candidateAttribute.getToken(), candidateAttribute.getName())) <= 0) break;
                attributeMapping.addScoreBonus(wordnetScore);
                break;
            }
            case 5: {
                int nameScore = this.nameWeight * this.matchNames(requirementsAttribute.getName(), candidateAttribute.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsAttribute.getToken(), requirementsAttribute.getName(), candidateAttribute.getToken(), candidateAttribute.getName());
                if (nameScore <= 0) break;
                attributeMapping.setScore(nameScore);
                break;
            }
            case 6: {
                int nameScore;
                int matchScore = this.structureWeight * this.lookupTable.getMatchingScore(requirementsAttribute.getType(), candidateAttribute.getType());
                attributeMapping.setScore(matchScore);
                if (requirementsAttribute.getUse() != null && candidateAttribute.getUse() != null && requirementsAttribute.getUse().equals(candidateAttribute.getUse())) {
                    attributeMapping.addScoreBonus(this.structureWeight * this.maxScore / 2);
                }
                if ((nameScore = this.nameWeight * this.matchNames(requirementsAttribute.getName(), candidateAttribute.getName()) + this.wordnetWeight * this.simpleWordnetMatch(requirementsAttribute.getToken(), requirementsAttribute.getName(), candidateAttribute.getToken(), candidateAttribute.getName())) <= 0) break;
                attributeMapping.addScoreBonus(nameScore);
            }
        }
        return attributeMapping;
    }

    private int matchNames(String requirementsName, String candidateName) {
        NameTokens requirementsTokens = new NameTokens(requirementsName, this.stopWords);
        NameTokens candidateTokens = new NameTokens(candidateName, this.stopWords);
        SimpleTokenMatcher serviceNameMatcher = new SimpleTokenMatcher(requirementsTokens, candidateTokens);
        return serviceNameMatcher.match();
    }

    private int simpleWordnetMatch(NameTokens requirements, String requirementsName, NameTokens candidate, String candidateName) throws JWNLException {
        if (requirements.size() > 0 && candidate.size() > 0) {
            ScoreMap map = new ScoreMap(requirements.size(), candidate.size(), requirementsName, candidateName, false);
            Iterator<String> requirementsit = requirements.iterator();
            while (requirementsit.hasNext()) {
                String requirementsToken = requirementsit.next();
                Iterator<String> candidateit = candidate.iterator();
                while (candidateit.hasNext()) {
                    String candidateToken = candidateit.next();
                    Mapping tokenMapping = new Mapping(requirementsToken, candidateToken);
                    int depth = this.dictionary.getCommonSynonyms(requirementsToken, candidateToken);
                    if (depth == 0) {
                        tokenMapping.setScore(this.maxScore);
                    } else if (depth < 10) {
                        tokenMapping.setScore(this.maxScore - depth);
                    } else if (depth >= 10) {
                        if (depth == 0) {
                            tokenMapping.setScore(this.maxScore / 2);
                        } else if (depth < 5) {
                            tokenMapping.setScore(this.maxScore / 2 - depth);
                        } else {
                            tokenMapping.setScore(this.minScore);
                        }
                    }
                    map.setValue(tokenMapping);
                }
            }
            map.computeMatches();
            return map.getMapping().getScore();
        }
        return this.minScore;
    }

    private Sequence generateSequence(ComplexType type) {
        Sequence sequence = new Sequence(type.getElementList().size());
        ListIterator<Element> elements = type.getElementList().listIterator();
        while (elements.hasNext()) {
            Element element = elements.next();
            sequence.setElement(elements.nextIndex() - 1, element);
        }
        return sequence;
    }

    public Mapping getServiceMapping() {
        return this.serviceMapping;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public int getMatchStrategy() {
        return this.matchStrategy;
    }

    public boolean isStrictSequence() {
        return this.strictSequence;
    }

    public void setStrictSequence(boolean strictSequence) {
        this.strictSequence = strictSequence;
    }
}

