/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import wsdlanalyzer.mapping.Mapping;
import wsdlanalyzer.mapping.MappingPartList;
import wsdlanalyzer.matrix.ScoreMap;
import wsdlanalyzer.parser.SimpleTypeLookupTable;
import wsdlanalyzer.types.Attribute;
import wsdlanalyzer.types.ComplexType;
import wsdlanalyzer.types.Element;
import wsdlanalyzer.types.NodeIdentifier;
import wsdlanalyzer.types.Sequence;
import wsdlanalyzer.types.TypeList;
import wsdlanalyzer.types.WsdlFile;

public class WsdlStructuralTypeMatcher {
    private TypeList requirementsTypes;
    private TypeList candidateTypes;
    private SimpleTypeLookupTable lookupTable;
    private int maxScore = 1;
    private int groupingBonus = 0;
    private int arrayBonus = 0;
    private int sequenceBonus = 0;
    private boolean edit = false;
    private boolean strictSequence;

    public WsdlStructuralTypeMatcher(WsdlFile requirementsfile, WsdlFile candidatefile, SimpleTypeLookupTable l) {
        this.requirementsTypes = requirementsfile.getTypeList();
        this.candidateTypes = candidatefile.getTypeList();
        this.lookupTable = l;
    }

    /*
     * Unable to fully structure code
     */
    public Mapping matchComplexTypes(String requirementsName, ComplexType requirementsType, String candidateName, ComplexType candidateType) {
        block14: {
            typeMapping = new Mapping(requirementsType.getName(), candidateType.getName(), requirementsType.getNodeIdentifier(), candidateType.getNodeIdentifier());
            elementListMapping = null;
            attributeMapping = null;
            if (requirementsType == null || candidateType == null) break block14;
            typeScore = 0;
            if (requirementsType.hasAttributes() && candidateType.hasAttributes()) {
                attributeMapping = this.matchAttributeLists(requirementsType, candidateType);
                requirementsAttributeIdentifier = new NodeIdentifier("Attributes", "complexTypeMember", requirementsType.getNodeIdentifier());
                candidateAttributeIdentifier = new NodeIdentifier("Attributes", "complexTypeMember", candidateType.getNodeIdentifier());
                attributeMapping.setRequirementsIdentifier(requirementsAttributeIdentifier);
                attributeMapping.setCandidateIdentifier(candidateAttributeIdentifier);
            }
            if (!requirementsType.isArray()) ** GOTO lbl19
            if (candidateType.isArray()) {
                elementListMapping = this.matchArrayTypes(requirementsType, candidateType);
            } else {
                nullMapping = new Mapping(requirementsName, candidateName);
                nullMapping.setScore(0);
                return nullMapping;
lbl19:
                // 1 sources

                if (candidateType.isArray()) {
                    nullMapping = new Mapping(requirementsName, candidateName);
                    nullMapping.setScore(0);
                    return nullMapping;
                }
                if (requirementsType.getNumberOfNonLeafElements() == candidateType.getNumberOfNonLeafElements() - 1 && requirementsType.getNumberOfLeafElements() > candidateType.getNumberOfLeafElements() + 1 && requirementsType.getNumberOfLeafElements() != candidateType.getNumberOfLeafElements()) {
                    requirementsType.getNumberOfNonLeafElements();
                    candidateType.getNumberOfNonLeafElements();
                }
                if (requirementsType.getGrouping() == candidateType.getGrouping()) {
                    typeScore += this.groupingBonus;
                }
                if (requirementsType.getGrouping() == 1 && candidateType.getGrouping() == 1 && this.strictSequence) {
                    requirementssequence = this.generateSequence(requirementsType);
                    candidatesequence = this.generateSequence(candidateType);
                    elementListMapping = this.matchSequences(requirementsType, requirementssequence, candidateType, candidatesequence);
                    elementListMapping.addScoreBonus(typeScore);
                } else if (!requirementsType.isEmpty() && !candidateType.isEmpty()) {
                    typeMatrix = new ScoreMap(requirementsType.getElementList().size(), candidateType.getElementList().size(), requirementsName, candidateName, this.edit);
                    requirementselements = requirementsType.getElementList().listIterator();
                    while (requirementselements.hasNext()) {
                        requirementselement = requirementselements.next();
                        candidateelements = candidateType.getElementList().listIterator();
                        while (candidateelements.hasNext()) {
                            candidateelement = candidateelements.next();
                            elementMapping = this.matchElements(requirementselement, candidateelement);
                            typeMatrix.setValue(elementMapping);
                        }
                    }
                    typeMatrix.computeMatches();
                    elementListMapping = typeMatrix.getMapping();
                    elementListMapping.addScoreBonus(typeScore);
                } else {
                    nullMapping = new Mapping(requirementsName, candidateName);
                    nullMapping.setScore(0);
                    return nullMapping;
                }
            }
            requirementsElementListIdentifier = new NodeIdentifier("Elements", "complexTypeMember", requirementsType.getNodeIdentifier());
            candidateElementListIdentifier = new NodeIdentifier("Elements", "complexTypeMember", candidateType.getNodeIdentifier());
            elementListMapping.setRequirementsIdentifier(requirementsElementListIdentifier);
            elementListMapping.setCandidateIdentifier(candidateElementListIdentifier);
            typePartList = new MappingPartList();
            if (elementListMapping != null) {
                typePartList.addMapping(elementListMapping);
            }
            if (attributeMapping != null) {
                typePartList.addMapping(attributeMapping);
            }
            typeMapping.addMappingPartList(typePartList);
            return typeMapping;
        }
        nullMapping = new Mapping(requirementsName, candidateName);
        nullMapping.setScore(0);
        return nullMapping;
    }

    private Mapping matchAttributeLists(ComplexType requirementsType, ComplexType candidateType) {
        HashMap<String, Attribute> requirementsAttributes = requirementsType.getAttributeList();
        HashMap<String, Attribute> candidateAttributes = candidateType.getAttributeList();
        ScoreMap attributeMap = new ScoreMap(requirementsAttributes.size(), candidateAttributes.size(), "Attributes of " + requirementsType.getName(), "Attributes of " + candidateType.getName(), this.edit);
        Iterator<String> requirementsIterator = requirementsAttributes.keySet().iterator();
        while (requirementsIterator.hasNext()) {
            Attribute requirementsAttribute = requirementsAttributes.get(requirementsIterator.next());
            Iterator<String> candidateIterator = candidateAttributes.keySet().iterator();
            while (candidateIterator.hasNext()) {
                Attribute candidateAttribute = candidateAttributes.get(candidateIterator.next());
                Mapping attributeMapping = this.matchAttributes(requirementsAttribute, candidateAttribute);
                attributeMap.setValue(attributeMapping);
            }
        }
        return attributeMap.getMapping();
    }

    private Mapping matchAttributes(Attribute requirementsAttribute, Attribute candidateAttribute) {
        Mapping attributeMapping = new Mapping(requirementsAttribute.getName(), candidateAttribute.getName(), requirementsAttribute.getId(), candidateAttribute.getId());
        int matchScore = this.lookupTable.getMatchingScore(requirementsAttribute.getType(), candidateAttribute.getType());
        attributeMapping.setScore(matchScore);
        if (requirementsAttribute.getUse() != null && candidateAttribute.getUse() != null && requirementsAttribute.getUse().equals(candidateAttribute.getUse())) {
            attributeMapping.addScoreBonus(0);
        }
        return attributeMapping;
    }

    private Mapping matchArrayTypes(ComplexType requirementsType, ComplexType candidateType) {
        Mapping arrayMapping = new Mapping(requirementsType.getName(), candidateType.getName(), requirementsType.getNodeIdentifier(), candidateType.getNodeIdentifier());
        int arrayscore = -1;
        String requirementsarraytype = requirementsType.getArrayType();
        String candidatearraytype = candidateType.getArrayType();
        if (this.lookupTable.lookupSimpleType(requirementsarraytype)) {
            if (this.lookupTable.lookupSimpleType(candidatearraytype)) {
                arrayscore = this.lookupTable.getMatchingScore(requirementsarraytype, candidatearraytype) * this.arrayBonus;
                arrayMapping.setScore(arrayscore);
                return arrayMapping;
            }
            ComplexType complextype = this.candidateTypes.getType(candidatearraytype);
            Mapping typeMapping = this.matchMixedTypes(requirementsType.getName(), requirementsarraytype, candidateType.getName(), complextype);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            arrayMapping.addMappingPartList(typePartList);
            arrayMapping.setScore(arrayMapping.getScore());
            return arrayMapping;
        }
        if (this.lookupTable.lookupSimpleType(candidatearraytype)) {
            ComplexType complextype = this.requirementsTypes.getType(requirementsarraytype);
            Mapping typeMapping = this.matchMixedTypes(requirementsType.getName(), complextype, candidateType.getName(), candidatearraytype);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            arrayMapping.addMappingPartList(typePartList);
            arrayMapping.setScore(arrayMapping.getScore());
            return arrayMapping;
        }
        ComplexType complexrequirementstype = this.requirementsTypes.getType(requirementsarraytype);
        ComplexType complexcandidatetype = this.candidateTypes.getType(candidatearraytype);
        Mapping typeMapping = this.matchComplexTypes(requirementsType.getName(), complexrequirementstype, candidateType.getName(), complexcandidatetype);
        MappingPartList typePartList = new MappingPartList();
        typePartList.addMapping(typeMapping);
        arrayMapping.addMappingPartList(typePartList);
        arrayMapping.setScore(arrayMapping.getScore());
        return arrayMapping;
    }

    private Sequence generateSequence(ComplexType type) {
        Sequence sequence = new Sequence(type.getElementList().size());
        ListIterator<Element> elements = type.getElementList().listIterator();
        while (elements.hasNext()) {
            Element element = elements.next();
            sequence.setElement(elements.nextIndex() - 1, element);
        }
        return sequence;
    }

    private Mapping matchSequences(ComplexType requirementsType, Sequence requirements, ComplexType candidateType, Sequence candidate) {
        Mapping sequenceMapping = new Mapping(requirementsType.getName(), candidateType.getName(), requirementsType.getNodeIdentifier(), candidateType.getNodeIdentifier());
        int sequenceScore = 0;
        int elementScore = 0;
        ArrayList<Integer> index = new ArrayList<Integer>();
        if (requirements.getLength() == candidate.getLength()) {
            MappingPartList mappingPartList = new MappingPartList();
            int i = 0;
            while (i < requirements.getLength()) {
                Element requirementselement = requirements.getElement(i);
                Element candidateelement = candidate.getElement(i);
                Mapping elementMapping = this.matchElements(requirementselement, candidateelement);
                mappingPartList.addMapping(elementMapping);
                ++i;
            }
            sequenceMapping.addMappingPartList(mappingPartList);
            return sequenceMapping;
        }
        if (requirements.getLength() < candidate.getLength()) {
            ArrayList<MappingPartList> tmplist = new ArrayList<MappingPartList>();
            int j = 0;
            while (j <= candidate.getLength() - requirements.getLength()) {
                int tmpScore = 0;
                MappingPartList mappingPartList = new MappingPartList();
                int i = 0;
                while (i < requirements.getLength()) {
                    Element requirementselement = requirements.getElement(i);
                    Element candidateelement = candidate.getElement(i + j);
                    Mapping elementMapping = this.matchElements(requirementselement, candidateelement);
                    elementScore = elementMapping.getScore();
                    tmpScore += elementScore;
                    mappingPartList.addMapping(elementMapping);
                    ++i;
                }
                if (sequenceScore < tmpScore) {
                    index.clear();
                    index.add(j);
                    tmplist.clear();
                    tmplist.add(mappingPartList);
                    sequenceScore = tmpScore;
                } else if (sequenceScore == tmpScore) {
                    index.add(j);
                    tmplist.add(mappingPartList);
                }
                ++j;
            }
            sequenceMapping.setMappingPartLists(tmplist);
            return sequenceMapping;
        }
        if (requirements.getLength() > candidate.getLength()) {
            ArrayList<MappingPartList> tmplist = new ArrayList<MappingPartList>();
            int j = 0;
            while (j <= requirements.getLength() - candidate.getLength()) {
                int tmpScore = 0;
                MappingPartList mappingPartList = new MappingPartList();
                int i = 0;
                while (i < candidate.getLength()) {
                    Element requirementsElement = requirements.getElement(i + j);
                    Element candidateElement = candidate.getElement(i);
                    Mapping elementMapping = this.matchElements(requirementsElement, candidateElement);
                    elementScore = elementMapping.getScore();
                    tmpScore += elementScore;
                    mappingPartList.addMapping(elementMapping);
                    ++i;
                }
                if (sequenceScore < tmpScore) {
                    index.clear();
                    index.add(j);
                    tmplist.clear();
                    tmplist.add(mappingPartList);
                    sequenceScore = tmpScore;
                } else if (sequenceScore == tmpScore) {
                    index.add(j);
                    tmplist.add(mappingPartList);
                }
                ++j;
            }
            sequenceMapping.setMappingPartLists(tmplist);
            return sequenceMapping;
        }
        return null;
    }

    private Mapping matchElements(Element requirementsElement, Element candidateElement) {
        Mapping elementMapping = new Mapping(requirementsElement.getName(), candidateElement.getName(), requirementsElement.getNodeIdentifier(), candidateElement.getNodeIdentifier());
        int elementScore = 0;
        elementMapping.setRequirementminoccur(requirementsElement.getMinOccur());
        elementMapping.setRequirementmaxoccur(requirementsElement.getMaxOccur());
        elementMapping.setCandidateminoccur(candidateElement.getMinOccur());
        elementMapping.setCandidatemaxoccur(candidateElement.getMaxOccur());
        if (requirementsElement.getMinOccur() >= 0 && candidateElement.getMinOccur() >= 0 && requirementsElement.getMinOccur() == candidateElement.getMinOccur()) {
            ++elementScore;
        }
        if (requirementsElement.getMaxOccur() >= 0 && candidateElement.getMaxOccur() >= 0 && requirementsElement.getMaxOccur() == candidateElement.getMaxOccur()) {
            ++elementScore;
        }
        if (!this.lookupTable.lookupSimpleType(requirementsElement.getType())) {
            ComplexType complexRequirementsType = this.requirementsTypes.getType(requirementsElement.getType());
            if (this.lookupTable.lookupSimpleType(candidateElement.getType())) {
                String simpletype = candidateElement.getType();
                Mapping typeMapping = this.matchMixedTypes(requirementsElement.getType(), complexRequirementsType, candidateElement.getName(), candidateElement.getType());
                MappingPartList typePartList = new MappingPartList();
                typePartList.addMapping(typeMapping);
                elementMapping.addMappingPartList(typePartList);
            } else {
                ComplexType complexCandidateType = this.candidateTypes.getType(candidateElement.getType());
                Mapping typeMapping = this.matchComplexTypes(requirementsElement.getType(), complexRequirementsType, candidateElement.getType(), complexCandidateType);
                MappingPartList typePartList = new MappingPartList();
                typePartList.addMapping(typeMapping);
                elementMapping.addMappingPartList(typePartList);
            }
        } else if (this.lookupTable.lookupSimpleType(candidateElement.getType())) {
            elementMapping.setRequirementsName(requirementsElement.getName());
            elementMapping.setCandidateName(candidateElement.getName());
            elementMapping.setScore(this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateElement.getType()));
        } else {
            ComplexType complexCandidateType = this.candidateTypes.getType(candidateElement.getType());
            Mapping typeMapping = this.matchMixedTypes(requirementsElement.getName(), requirementsElement.getType(), candidateElement.getType(), complexCandidateType);
            MappingPartList typePartList = new MappingPartList();
            typePartList.addMapping(typeMapping);
            elementMapping.addMappingPartList(typePartList);
        }
        return elementMapping;
    }

    public Mapping matchMixedTypes(String requirementsName, ComplexType requirementsType, String candidateName, String candidateType) {
        if (requirementsType != null) {
            ScoreMap typeMatrix = new ScoreMap(requirementsType.getElementList().size(), 1, requirementsName, candidateName, this.edit);
            if (!requirementsType.isArray()) {
                if (!requirementsType.getElementList().isEmpty()) {
                    ListIterator<Element> elements = requirementsType.getElementList().listIterator();
                    while (elements.hasNext()) {
                        Element requirementsElement = elements.next();
                        if (this.lookupTable.lookupSimpleType(requirementsElement.getType())) {
                            Mapping elementMapping = new Mapping(requirementsElement.getName(), candidateName);
                            elementMapping.setRequirementsIdentifier(requirementsElement.getNodeIdentifier());
                            int matchScore = this.lookupTable.getMatchingScore(requirementsElement.getType(), candidateType);
                            elementMapping.setScore(matchScore);
                            typeMatrix.setValue(elementMapping);
                            continue;
                        }
                        ComplexType complextypeelement = this.requirementsTypes.getType(requirementsElement.getType());
                        Mapping elementMapping = this.matchMixedTypes(requirementsElement.getName(), complextypeelement, candidateName, candidateType);
                        typeMatrix.setValue(elementMapping);
                    }
                    typeMatrix.computeMatches();
                    Mapping typeMapping = typeMatrix.getMapping();
                    typeMapping.setRequirementsIdentifier(requirementsType.getNodeIdentifier());
                    return typeMapping;
                }
                Mapping nullMapping = new Mapping(requirementsName, candidateName);
                nullMapping.setScore(0);
                return nullMapping;
            }
            Mapping nullMapping = new Mapping(requirementsName, candidateName);
            nullMapping.setScore(0);
            return nullMapping;
        }
        Mapping nullMapping = new Mapping(requirementsName, candidateName);
        nullMapping.setScore(0);
        return nullMapping;
    }

    public Mapping matchMixedTypes(String requirementsName, String requirementsType, String candidateName, ComplexType candidateType) {
        if (candidateType != null) {
            ScoreMap typeMatrix = new ScoreMap(1, candidateType.getElementList().size(), requirementsName, candidateName, this.edit);
            if (!candidateType.isArray()) {
                if (!candidateType.getElementList().isEmpty()) {
                    ListIterator<Element> elements = candidateType.getElementList().listIterator();
                    while (elements.hasNext()) {
                        Element candidateelement = elements.next();
                        if (this.lookupTable.lookupSimpleType(candidateelement.getType())) {
                            Mapping elementMapping = new Mapping(requirementsName, candidateelement.getName());
                            elementMapping.setCandidateIdentifier(candidateelement.getNodeIdentifier());
                            int matchScore = this.lookupTable.getMatchingScore(requirementsType, candidateelement.getType());
                            elementMapping.setScore(matchScore);
                            typeMatrix.setValue(elementMapping);
                            continue;
                        }
                        ComplexType complextypeelement = this.candidateTypes.getType(candidateelement.getType());
                        Mapping elementMapping = this.matchMixedTypes(requirementsName, requirementsType, candidateelement.getName(), complextypeelement);
                        typeMatrix.setValue(elementMapping);
                    }
                    typeMatrix.computeMatches();
                    Mapping typeMapping = typeMatrix.getMapping();
                    typeMapping.setCandidateIdentifier(candidateType.getNodeIdentifier());
                    return typeMapping;
                }
                Mapping nullMapping = new Mapping(requirementsName, candidateName);
                nullMapping.setScore(0);
                return nullMapping;
            }
            Mapping nullMapping = new Mapping(requirementsName, candidateName);
            nullMapping.setScore(0);
            return nullMapping;
        }
        Mapping nullMapping = new Mapping(requirementsName, candidateName);
        nullMapping.setScore(0);
        return nullMapping;
    }
}

