/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.matrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import wsdlanalyzer.mapping.Mapping;
import wsdlanalyzer.mapping.MappingPartList;
import wsdlanalyzer.matrix.ColumnList;
import wsdlanalyzer.matrix.DecreasingSorter;
import wsdlanalyzer.matrix.RowMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreMap {
    private int matchCount;
    private int sizeDifference;
    private int maxScore = 10;
    private int minScore = 0;
    private String requirementsName;
    private String candidateName;
    private TreeMap<Integer, ArrayList<Mapping>> matchingMap;
    private TreeMap<Integer, RowMap> scoreMap;
    private Mapping mapping;
    private int entries;
    private boolean treeEdit;
    private boolean debug;

    public ScoreMap(int i, int j, String requirements, String candidate, Boolean edit) {
        this.matchCount = Math.min(i, j);
        this.sizeDifference = Math.abs(i - j);
        this.scoreMap = new TreeMap(new DecreasingSorter());
        this.requirementsName = requirements;
        this.candidateName = candidate;
        this.matchingMap = new TreeMap();
        this.entries = i * j;
        this.treeEdit = edit;
        this.mapping = new Mapping(this.requirementsName, this.candidateName);
        this.debug = false;
    }

    public void setValue(Mapping mappingpart) {
        String row = mappingpart.getRequirementsName();
        String column = mappingpart.getCandidateName();
        Integer score = new Integer(mappingpart.getScore());
        if (!this.scoreMap.containsKey(score)) {
            ColumnList columnindices = new ColumnList();
            columnindices.addColumn(column, mappingpart);
            RowMap rowindices = new RowMap();
            rowindices.putRow(row, columnindices);
            this.scoreMap.put(score, rowindices);
        } else if (!this.scoreMap.get(score).containsKey(row)) {
            ColumnList columnindices = new ColumnList();
            columnindices.addColumn(column, mappingpart);
            this.scoreMap.get(score).putRow(row, columnindices);
        } else {
            this.scoreMap.get(score).getColumnList(row).addColumn(column, mappingpart);
        }
    }

    public void computeMatches() {
        int score = -1;
        if (this.debug) {
            this.print();
        }
        if (this.scoreMap.size() == 1) {
            score = this.matchCount * this.scoreMap.firstKey();
            if (this.entries > 1) {
                this.mapping.setScore(score);
                this.mapping.setAnymatch(true);
            } else {
                RowMap rows = this.scoreMap.get(this.scoreMap.firstKey());
                Iterator<String> rowiterator = rows.getIterator();
                while (rowiterator.hasNext()) {
                    String row = rowiterator.next();
                    ColumnList columns = this.scoreMap.get(this.scoreMap.firstKey()).getColumnList(row);
                    Iterator<String> columniterator = columns.getColumnIterator();
                    while (columniterator.hasNext()) {
                        String column = columniterator.next();
                        Mapping subMapping = columns.getMapping(column);
                        MappingPartList mappingPartList = new MappingPartList();
                        mappingPartList.addMapping(subMapping);
                        this.mapping.addMappingPartList(mappingPartList);
                    }
                }
                if (this.treeEdit) {
                    int malus = this.sizeDifference * this.maxScore;
                    int editScore = this.mapping.getScore() - malus;
                    if (editScore < 0) {
                        this.mapping.setScore(this.minScore);
                    } else {
                        this.mapping.setScore(editScore);
                    }
                }
            }
        } else {
            Integer max = this.scoreMap.firstKey();
            RowMap rows = this.scoreMap.get(max);
            Iterator<String> rowiterator = rows.getIterator();
            while (rowiterator.hasNext()) {
                String row = rowiterator.next();
                ColumnList columns = rows.getColumnList(row);
                Iterator<String> columniterator = columns.getColumnIterator();
                while (columniterator.hasNext()) {
                    String column = columniterator.next();
                    HashMap<String, Boolean> selectedrows = new HashMap<String, Boolean>();
                    HashMap<String, Boolean> selectedcolumns = new HashMap<String, Boolean>();
                    selectedrows.put(row, true);
                    selectedcolumns.put(column, true);
                    Mapping subMapping = columns.getMapping(column);
                    MappingPartList mappingPartList = new MappingPartList();
                    mappingPartList.addMapping(subMapping);
                    if (this.computeMatches(selectedrows, selectedcolumns, mappingPartList, this.matchCount - 1)) continue;
                    this.mapping.addMappingPartList(mappingPartList);
                }
            }
            if (this.treeEdit) {
                int malus = this.sizeDifference * this.maxScore;
                int editScore = this.mapping.getScore() - malus;
                if (editScore < 0) {
                    this.mapping.setScore(this.minScore);
                } else {
                    this.mapping.setScore(editScore);
                }
            }
        }
    }

    private boolean computeMatches(HashMap<String, Boolean> rows, HashMap<String, Boolean> columns, MappingPartList list, int count) {
        if (count > 0) {
            MappingPartList base = list;
            for (Integer value : this.scoreMap.keySet()) {
                RowMap tmprows = this.scoreMap.get(value);
                Iterator<String> rowiterator = tmprows.getIterator();
                while (rowiterator.hasNext()) {
                    String row = rowiterator.next();
                    if (rows.containsKey(row)) continue;
                    ColumnList tmpcolumns = this.scoreMap.get(value).getColumnList(row);
                    Iterator<String> columniterator = tmpcolumns.getColumnIterator();
                    while (columniterator.hasNext()) {
                        String column = columniterator.next();
                        if (columns.containsKey(column)) continue;
                        MappingPartList alternative = base.copy();
                        rows.put(row, true);
                        columns.put(column, true);
                        Mapping subMapping = tmpcolumns.getMapping(column);
                        alternative.addMapping(subMapping);
                        if (this.computeMatches(rows, columns, alternative, count - 1)) continue;
                        this.mapping.addMappingPartList(alternative);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public int getEntryNumber() {
        return this.entries;
    }

    public Set<String> getMaxRows() {
        RowMap rows = this.scoreMap.get(this.scoreMap.firstKey());
        return rows.keySet();
    }

    public int getMaxValue() {
        return this.scoreMap.firstKey();
    }

    public int getEntries() {
        return this.entries;
    }

    private void print() {
        for (Integer score : this.scoreMap.keySet()) {
            System.out.println("ScoreKey: " + score + "\n");
            RowMap rowMap = this.scoreMap.get(score);
            rowMap.print();
            System.out.println("** end of score **\n");
        }
    }
}

