/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.types;

import java.util.HashMap;
import java.util.Set;
import wsdlanalyzer.matcher.NameTokens;
import wsdlanalyzer.types.BindingOperation;
import wsdlanalyzer.types.NodeIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Binding {
    private String name;
    private String portType;
    private NameTokens token;
    private String bindingType;
    private boolean bindingStyle;
    private String transport;
    private HashMap<String, BindingOperation> operationList;
    NodeIdentifier nodeIdentifier;

    public Binding() {
        this.name = null;
        this.operationList = new HashMap();
        this.nodeIdentifier = new NodeIdentifier();
    }

    public Binding(String s) {
        this.name = s;
        this.operationList = new HashMap();
        this.nodeIdentifier = new NodeIdentifier();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPortType() {
        return this.portType;
    }

    public void setPortType(String portType) {
        this.portType = portType;
    }

    public NameTokens getToken() {
        return this.token;
    }

    public void setToken(NameTokens token) {
        this.token = token;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(NodeIdentifier nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public boolean isRPCStyle() {
        return this.bindingStyle;
    }

    public void setRPCStyle(boolean bindingStyle) {
        this.bindingStyle = bindingStyle;
    }

    public String getBindingType() {
        return this.bindingType;
    }

    public void setBindingType(String bindingType) {
        this.bindingType = bindingType;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public HashMap<String, BindingOperation> getOperationList() {
        return this.operationList;
    }

    public BindingOperation addBindingOperation(String name, BindingOperation operation) {
        return this.operationList.put(name, operation);
    }

    public void print() {
        System.out.println("++Binding**\n");
        System.out.println("Name: " + this.name);
        System.out.println("PortType: " + this.portType);
        System.out.println("Type: " + this.bindingType);
        if (this.bindingStyle) {
            System.out.println("Style: RPC");
        } else {
            System.out.println("Style: Document");
        }
        System.out.println("Transport: " + this.transport);
        Set<String> kset = this.operationList.keySet();
        for (String key : kset) {
            BindingOperation op = this.operationList.get(key);
            op.print();
        }
        System.out.println("\n++End of Binding++");
    }
}

