/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import wsdlanalyzer.matcher.NameTokens;
import wsdlanalyzer.types.Attribute;
import wsdlanalyzer.types.Element;
import wsdlanalyzer.types.NodeIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexType {
    private String name;
    private String nameSpace;
    private int grouping;
    private boolean array;
    private String arrayPrefix;
    private String arrayType;
    private ArrayList<Element> elements;
    private HashMap<String, Attribute> attributeList;
    private int numberOfLeafElements;
    private int numberOfNonLeafElements;
    private int totalLeaves;
    private NameTokens token;
    NodeIdentifier nodeIdentifier;

    public ComplexType() {
        this.array = false;
        this.arrayType = null;
        this.elements = new ArrayList();
        this.attributeList = new HashMap();
        this.grouping = 0;
        this.numberOfLeafElements = 0;
        this.numberOfNonLeafElements = 0;
        this.totalLeaves = -1;
        this.nodeIdentifier = new NodeIdentifier();
    }

    public ComplexType(String s) {
        this.name = s;
        this.array = false;
        this.arrayType = null;
        this.elements = new ArrayList();
        this.attributeList = new HashMap();
        this.grouping = 0;
        this.numberOfLeafElements = 0;
        this.numberOfNonLeafElements = 0;
        this.totalLeaves = -1;
        this.nodeIdentifier = new NodeIdentifier();
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void setNameSpace(String s) {
        this.nameSpace = s;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setGrouping(int i) {
        this.grouping = i;
    }

    public int getGrouping() {
        return this.grouping;
    }

    public void setArray() {
        this.array = true;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArrayPrefix(String s) {
        this.arrayPrefix = s;
    }

    public String getArrayPrefix() {
        return this.arrayPrefix;
    }

    public void setArrayType(String s) {
        this.arrayType = s;
    }

    public String getArrayType() {
        return this.arrayType;
    }

    public void addElement(Element t) {
        this.elements.add(t);
    }

    public void addElementList(ArrayList<Element> list) {
        this.elements.addAll(list);
    }

    public ArrayList<Element> getElementList() {
        return this.elements;
    }

    public boolean hasElements() {
        return !this.elements.isEmpty();
    }

    public boolean hasAttributes() {
        return !this.attributeList.isEmpty();
    }

    public boolean hasAttribute(Object arg0) {
        return this.attributeList.containsKey(arg0);
    }

    public Attribute getAttribute(Object arg0) {
        return this.attributeList.get(arg0);
    }

    public Attribute addAttribute(String arg0, Attribute arg1) {
        return this.attributeList.put(arg0, arg1);
    }

    public int attributeListSize() {
        return this.attributeList.size();
    }

    public HashMap<String, Attribute> getAttributeList() {
        return this.attributeList;
    }

    public Iterator<Attribute> attributeIterator() {
        return this.attributeList.values().iterator();
    }

    public boolean equals(ComplexType t) {
        return this.name.equals(t.getName()) && this.grouping == t.getGrouping();
    }

    public int getNumberOfLeafElements() {
        return this.numberOfLeafElements;
    }

    public void setNumberOfLeafElements(int numberOfLeaafElements) {
        this.numberOfLeafElements = numberOfLeaafElements;
    }

    public void increaseNumberOfLeafElements() {
        ++this.numberOfLeafElements;
    }

    public int getNumberOfNonLeafElements() {
        return this.numberOfNonLeafElements;
    }

    public void setNumberOfNonLeafElements(int numberOfNonLeafElements) {
        this.numberOfNonLeafElements = numberOfNonLeafElements;
    }

    public void increaseNumberOfNonLeafElements() {
        ++this.numberOfNonLeafElements;
    }

    public int getTotalLeaves() {
        return this.totalLeaves;
    }

    public void setTotalLeaves(int totalLeaves) {
        this.totalLeaves = totalLeaves;
    }

    public void increaseTotalLeaves(int i) {
        this.totalLeaves += i;
    }

    public NameTokens getToken() {
        return this.token;
    }

    public void setToken(NameTokens token) {
        this.token = token;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(NodeIdentifier nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public NodeIdentifier getElementMemberIdentifier() {
        if (this.hasElements()) {
            return new NodeIdentifier("Elements", "complexTypeMember", this.nodeIdentifier);
        }
        return null;
    }

    public NodeIdentifier getAttributeMemberIdentifier() {
        if (this.hasAttributes()) {
            return new NodeIdentifier("Attributes", "complexTypeMember", this.nodeIdentifier);
        }
        return null;
    }

    public void printComplexType() {
        System.out.println("*** ComplexType ***\n");
        System.out.println("targetnamespace: " + this.nameSpace);
        System.out.println("name: " + this.name);
        System.out.println("grouping: " + this.grouping);
        System.out.println("array: " + this.array);
        System.out.println("type of array: " + this.arrayType);
        System.out.println("** elements**\n");
        ListIterator<Element> enumeration = this.elements.listIterator();
        while (enumeration.hasNext()) {
            Element element = enumeration.next();
            element.printElement();
        }
        System.out.println("***end of complexType***\n\n");
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }
}

