/*
 * Decompiled with CFR 0.152.
 */
package wsdlanalyzer.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeIdentifier
implements Serializable {
    private ArrayList<IdentifierItem> identifierList = new ArrayList();

    public NodeIdentifier() {
    }

    public NodeIdentifier(String name, String type) {
        this();
        this.identifierList.add(new IdentifierItem(name, type));
    }

    public NodeIdentifier(String name, String type, NodeIdentifier ni) {
        this(ni);
        this.identifierList.add(new IdentifierItem(name, type));
    }

    public NodeIdentifier(NodeIdentifier ni) {
        this();
        this.identifierList.addAll(ni.getIdentifierList());
    }

    protected String stringConcatenation() {
        String ret = "";
        Iterator<IdentifierItem> it = this.identifierList.iterator();
        while (it.hasNext()) {
            ret = String.valueOf(ret) + it.next().toString();
        }
        return ret;
    }

    public boolean equals(Object object) {
        try {
            NodeIdentifier ni = (NodeIdentifier)object;
            return this.stringConcatenation().equals(ni.stringConcatenation());
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.stringConcatenation().hashCode();
    }

    public boolean isEmpty() {
        return this.identifierList.isEmpty();
    }

    public void addIdentifier(String name, String type) {
        this.identifierList.add(new IdentifierItem(name, type));
    }

    public ArrayList<IdentifierItem> getIdentifierList() {
        return this.identifierList;
    }

    public Iterator<IdentifierItem> getIdentifierIterator() {
        return this.identifierList.iterator();
    }

    public void setIdentifierList(ArrayList<IdentifierItem> identifierList) {
        this.identifierList = identifierList;
    }

    public String toString() {
        return this.identifierList.toString();
    }

    public NodeIdentifier getBottomSubIdentifier() {
        if (this.identifierList.size() < 2) {
            return null;
        }
        NodeIdentifier ret = new NodeIdentifier();
        int i = 1;
        while (i < this.identifierList.size()) {
            ret.addIdentifier(this.identifierList.get((int)i).name, this.identifierList.get((int)i).type);
            ++i;
        }
        return ret;
    }

    public NodeIdentifier getTopSubIdentifier() {
        if (this.identifierList.size() < 2) {
            return null;
        }
        NodeIdentifier ret = new NodeIdentifier();
        int i = 0;
        while (i < this.identifierList.size() - 1) {
            ret.addIdentifier(this.identifierList.get((int)i).name, this.identifierList.get((int)i).type);
            ++i;
        }
        return ret;
    }

    public IdentifierItem getLastidentifier() {
        if (this.identifierList.size() > 0) {
            return this.identifierList.get(this.identifierList.size() - 1);
        }
        return null;
    }

    public void addParentIdentifier(String name, String type) {
        this.identifierList.add(0, new IdentifierItem(name, type));
    }

    public void printNodeIdentifier() {
        System.out.println("\n++ NodeIdentifier ++");
        Iterator<IdentifierItem> it = this.identifierList.iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
    }

    public class IdentifierItem
    implements Serializable {
        public String name;
        public String type;

        public IdentifierItem(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return String.valueOf(this.type) + " : " + this.name;
        }

        public boolean equals(IdentifierItem item) {
            return this.name.equals(item.name) && this.type.equals(item.type);
        }
    }
}

